/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.confluence.common;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.component.ComponentLocator;
import javax.inject.Inject;
import net.savignano.snotify.atlassian.common.properties.ASnotifyAppProperties;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class SnotifyAppProperties
extends ASnotifyAppProperties {
    private static final Logger log = LoggerFactory.getLogger(SnotifyAppProperties.class);
    @Inject
    @ComponentImport
    private BandanaManager manager;

    @Override
    protected String getString(String key) {
        String value;
        try {
            value = (String)this.getManager().getValue((BandanaContext)ConfluenceBandanaContext.GLOBAL_CONTEXT, key);
        }
        catch (ClassCastException e) {
            log.error("ClassCastException loading application property " + key + ".", (Throwable)e);
            this.getManager().removeValue((BandanaContext)ConfluenceBandanaContext.GLOBAL_CONTEXT, key);
            return null;
        }
        if (StringUtils.isBlank((String)value)) {
            log.trace("App property \"{}\" is considered null.", (Object)key);
            return null;
        }
        log.trace("App property \"{}\" is: {}", (Object)key, (Object)value);
        return value;
    }

    @Override
    protected void setString(String key, String value) {
        Object oldValue = this.getManager().getValue((BandanaContext)ConfluenceBandanaContext.GLOBAL_CONTEXT, key);
        if (!(oldValue == null || value != null && oldValue instanceof String)) {
            log.trace("Removing app property \"{}\".", (Object)key);
            this.getManager().removeValue((BandanaContext)ConfluenceBandanaContext.GLOBAL_CONTEXT, key);
        }
        if (value != null) {
            log.trace("Setting app property \"{}\" to: {}", (Object)key, (Object)value);
            this.getManager().setValue((BandanaContext)ConfluenceBandanaContext.GLOBAL_CONTEXT, key, (Object)value);
        }
        if (log.isTraceEnabled()) {
            Object newValue = this.getManager().getValue((BandanaContext)ConfluenceBandanaContext.GLOBAL_CONTEXT, key);
            if (value == null ? newValue != null : !value.equals(newValue)) {
                log.error("Setting of app property \"{}\" failed. Expected value: \"{}\". Actual value: \"{}\"", new Object[]{key, value, newValue});
            }
        }
    }

    private BandanaManager getManager() {
        if (this.manager == null) {
            log.trace("Injection of BandanaManager failed. Loading manually.");
            this.manager = (BandanaManager)ComponentLocator.getComponent(BandanaManager.class);
        }
        return this.manager;
    }
}

