/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.confluence.gui.action;

import com.atlassian.confluence.user.ConfluenceUserImpl;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.user.User;
import com.atlassian.velocity.htmlsafe.HtmlSafe;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.naming.ConfigurationException;
import javax.servlet.http.HttpServletRequest;
import net.savignano.cryptography.connector.LdapConnector;
import net.savignano.cryptography.enums.ECryptographyType;
import net.savignano.cryptography.enums.EEncryptionTypePriority;
import net.savignano.cryptography.enums.EKeySource;
import net.savignano.cryptography.key.loader.pgp.PgpGlobalDirectoryLoader;
import net.savignano.cryptography.key.loader.pgp.PgpKeyServerLoader;
import net.savignano.cryptography.key.loader.smime.SmimeLdapLoader;
import net.savignano.snotify.atlassian.common.EProperty;
import net.savignano.snotify.atlassian.common.ISnotifyI18n;
import net.savignano.snotify.atlassian.common.KeySourceComperator;
import net.savignano.snotify.atlassian.common.connector.AtlassianLdapConnector;
import net.savignano.snotify.atlassian.gui.keysource.verification.AKeySourceVerification;
import net.savignano.snotify.atlassian.gui.keysource.verification.EVerificationStatus;
import net.savignano.snotify.atlassian.gui.keysource.verification.UserKeySourceVerification;
import net.savignano.snotify.atlassian.gui.keysource.verification.VerificationStatus;
import net.savignano.snotify.atlassian.gui.keysource.verification.pgp.PgpGlobalDirectoryVerification;
import net.savignano.snotify.atlassian.gui.keysource.verification.pgp.PgpKeyBoxVerification;
import net.savignano.snotify.atlassian.gui.keysource.verification.pgp.PgpKeyServerVerification;
import net.savignano.snotify.atlassian.gui.keysource.verification.pgp.PgpPublicKeyStoreVerification;
import net.savignano.snotify.atlassian.gui.keysource.verification.smime.SmimeKeyStoreVerification;
import net.savignano.snotify.atlassian.gui.keysource.verification.smime.SmimeLdapVerification;
import net.savignano.snotify.atlassian.gui.keysource.verification.smime.SmimeP7bVerification;
import net.savignano.snotify.atlassian.gui.templates.handler.IValueHandler;
import net.savignano.snotify.atlassian.gui.templates.handler.IValueHandlerProvider;
import net.savignano.snotify.atlassian.gui.templates.handler.impl.CheckBoxHandler;
import net.savignano.snotify.atlassian.gui.templates.handler.impl.InputHandler;
import net.savignano.snotify.atlassian.gui.templates.handler.impl.RadioHandler;
import net.savignano.snotify.atlassian.gui.templates.handler.impl.provider.ExternalLdapHandlerProvider;
import net.savignano.snotify.atlassian.gui.templates.handler.impl.provider.ValueHandlerContainer;
import net.savignano.snotify.confluence.common.ConfluenceUser;
import net.savignano.snotify.confluence.common.SnotifyUserProperties;
import net.savignano.snotify.confluence.gui.action.SnotifyAdminSettingsAction;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnotifyKeystoreSettingsAction
extends SnotifyAdminSettingsAction
implements IValueHandlerProvider {
    private static final long serialVersionUID = 1247124257993104660L;
    private static final String SMIME_PUBLIC_KEYSTORE_LOCATION_ID = "smimePublicKeystoreLocation";
    private static final String SMIME_PUBLIC_KEYSTORE_TYPE_ID = "smimePublicKeystoreType";
    private static final String PGP_PUBLIC_KEYSTORE_LOCATION_ID = "pgpPublicKeystoreLocation";
    private static final String PGP_PUBLIC_KEYSTORE_TYPE_ID = "pgpPublicKeystoreType";
    private static final String PGP_PUBLIC_KEYSERVER_LOCATION_ID = "pgpPublicKeyserverLocation";
    private static final String ALLOW_PGP_PUBLIC_KEY_OVERWRITE_ID = "allowPublicPgpKeyOverwrite";
    private static final String ALLOW_SMIME_CERTIFICATE_OVERWRITE_ID = "allowPublicSmimeCertOverwrite";
    private static final String USE_SMIME_PUBLIC_USER_DIRECTORY_ID = "smimePublicUserDirectory";
    private static final String VERIFICATION_EMAIL_PARAM = "verificationEmail";
    private static final String ACTIVE_TAB_PARAM = "activeTab";
    private static final String VERIFY_BUTTON_PARAM = "Test settings";
    private static final String CLEAR_CACHE_BUTTON_PARAM = "Clear Cache";
    private static final String SUBMIT_BUTTON_PARAM = "Update";
    private static final Logger log = LoggerFactory.getLogger(SnotifyKeystoreSettingsAction.class);
    private ValueHandlerContainer valueContainer;
    private ExternalLdapHandlerProvider ldapProvider;
    private String verifyMessage;
    private boolean expireKeys;
    private String verificationEmail;
    private EEncryptionTypePriority typePriority;
    private ECryptographyType lastSubmit;

    public String doInput() {
        if (!this.hasAdminRights()) {
            com.atlassian.confluence.user.ConfluenceUser user = this.getAuthenticatedUser();
            log.warn("Unauthorized access to view global S/Notify values from user: {}", (Object)(user != null ? user.getFullName() : "<Unknown User>"));
            return "error";
        }
        this.createValueHandlers();
        this.valueContainer.read();
        this.ldapProvider.read();
        this.verificationEmail = this.getAuthenticatedUser().getEmail();
        return "input";
    }

    public String doSubmit() {
        HttpServletRequest request = this.getCurrentRequest();
        if (!"POST".equals(request.getMethod())) {
            log.debug("Access to submit method redirected to input method, as request method wasn't 'POST'. Used method: " + request.getMethod());
            return this.doInput();
        }
        if (!this.hasAdminRights()) {
            com.atlassian.confluence.user.ConfluenceUser user = this.getAuthenticatedUser();
            log.warn("Unauthorized access to submit global S/Notify values from user: {}", (Object)(user != null ? user.getFullName() : "<Unknown User>"));
            return "error";
        }
        this.createValueHandlers();
        this.valueContainer.receive(request);
        this.ldapProvider.receive(request);
        this.lastSubmit = this.getSelectedTab(request.getParameter(ACTIVE_TAB_PARAM));
        this.verificationEmail = request.getParameter(VERIFICATION_EMAIL_PARAM);
        if (StringUtils.isBlank((String)this.verificationEmail)) {
            this.verificationEmail = this.getAuthenticatedUser().getEmail();
        }
        this.clearCache();
        if (request.getParameter(SUBMIT_BUTTON_PARAM) != null) {
            this.storeSettings();
        } else if (request.getParameter(VERIFY_BUTTON_PARAM) != null) {
            this.verifySettings(this.valueContainer, this.ldapProvider);
        } else if (request.getParameter(CLEAR_CACHE_BUTTON_PARAM) != null) {
            this.expireKeys = true;
        } else {
            log.error("Unknown submit option used.");
        }
        return "input";
    }

    private void createValueHandlers() {
        if (this.valueContainer != null) {
            return;
        }
        this.valueContainer = new ValueHandlerContainer();
        this.valueContainer.add(new InputHandler(SMIME_PUBLIC_KEYSTORE_LOCATION_ID, this.getAppProps(), EProperty.PUBLIC_KEYSTORE_SMIME_LOCATION));
        this.valueContainer.add(new RadioHandler(SMIME_PUBLIC_KEYSTORE_TYPE_ID, this.getAppProps(), EProperty.PUBLIC_KEYSTORE_SMIME_TYPE));
        this.valueContainer.add(new CheckBoxHandler(USE_SMIME_PUBLIC_USER_DIRECTORY_ID, this.getAppProps(), EProperty.USER_DIRECTORY_LDAP_QUERY_SMIME));
        this.valueContainer.add(new CheckBoxHandler(ALLOW_SMIME_CERTIFICATE_OVERWRITE_ID, this.getAppProps(), EProperty.ALLOW_SMIME_CERTIFICATE_OVERWRITE));
        this.valueContainer.add(new InputHandler(PGP_PUBLIC_KEYSTORE_LOCATION_ID, this.getAppProps(), EProperty.PUBLIC_KEYSTORE_PGP_LOCATION));
        this.valueContainer.add(new RadioHandler(PGP_PUBLIC_KEYSTORE_TYPE_ID, this.getAppProps(), EProperty.PUBLIC_KEYSTORE_PGP_TYPE));
        this.valueContainer.add(new InputHandler(PGP_PUBLIC_KEYSERVER_LOCATION_ID, this.getAppProps(), EProperty.PUBLIC_KEYSERVER_PGP_LOCATION));
        this.valueContainer.add(new CheckBoxHandler(ALLOW_PGP_PUBLIC_KEY_OVERWRITE_ID, this.getAppProps(), EProperty.ALLOW_PGP_PUBLIC_KEY_OVERWRITE));
        this.ldapProvider = new ExternalLdapHandlerProvider(this.getAppProps());
    }

    private void storeSettings() {
        this.valueContainer.store();
        this.ldapProvider.store();
        this.setShowUpdated(true);
    }

    private void verifySettings(IValueHandlerProvider provider, ExternalLdapHandlerProvider ldapProvider) {
        this.expireKeys = false;
        ArrayList<VerificationStatus> statusList = new ArrayList<VerificationStatus>();
        for (List<VerificationStatus> smimeStatus : this.createSmimeVerifications(provider, ldapProvider).values()) {
            statusList.addAll(smimeStatus);
        }
        for (List<VerificationStatus> smimeStatus : this.createPgpVerifications(provider).values()) {
            statusList.addAll(smimeStatus);
        }
        StringBuilder builder = new StringBuilder(512 * statusList.size());
        for (VerificationStatus status : statusList) {
            builder.append(status.getHtmlStatus());
        }
        this.verifyMessage = builder.toString();
    }

    private SortedMap<EKeySource, List<VerificationStatus>> createSmimeVerifications(IValueHandlerProvider provider, ExternalLdapHandlerProvider ldapProvider) {
        TreeMap<EKeySource, List<VerificationStatus>> statusMap = new TreeMap<EKeySource, List<VerificationStatus>>(new KeySourceComperator());
        String smimeKeyStoreLocation = (String)provider.getValue(SMIME_PUBLIC_KEYSTORE_LOCATION_ID);
        if (StringUtils.isNotBlank((String)smimeKeyStoreLocation)) {
            String keyStoreType = (String)provider.getValue(SMIME_PUBLIC_KEYSTORE_TYPE_ID);
            statusMap.put(EKeySource.KEYSTORE, this.verifySmimePublicKeystore(smimeKeyStoreLocation, keyStoreType));
        }
        if (ldapProvider.isValid()) {
            LdapConnector connector = ldapProvider.buildConnector();
            connector.setDisableTrustCheck(this.getAppProps().getBoolean(EProperty.TWEAK_EXTERNAL_LDAP_INSECURE));
            String mailAttr = (String)ldapProvider.getValue("smimePublicLdapMailAttr");
            statusMap.put(EKeySource.STANDARD_LDAP, this.verifySmimePublicLdap(connector, mailAttr));
        }
        if (((Boolean)provider.getValue(USE_SMIME_PUBLIC_USER_DIRECTORY_ID)).booleanValue()) {
            statusMap.put(EKeySource.ATLASSIAN_DIRECTORY, this.verifySmimePublicUserDirectory());
        }
        if (((Boolean)provider.getValue(ALLOW_SMIME_CERTIFICATE_OVERWRITE_ID)).booleanValue()) {
            statusMap.put(EKeySource.USER, this.verifySmimeUserUpload());
        }
        return statusMap;
    }

    private SortedMap<EKeySource, List<VerificationStatus>> createPgpVerifications(IValueHandlerProvider provider) {
        String pgpKeyServerLocation;
        TreeMap<EKeySource, List<VerificationStatus>> statusMap = new TreeMap<EKeySource, List<VerificationStatus>>(new KeySourceComperator());
        String pgpKeyStoreLocation = (String)provider.getValue(PGP_PUBLIC_KEYSTORE_LOCATION_ID);
        if (StringUtils.isNotBlank((String)pgpKeyStoreLocation)) {
            String keyStoreType = (String)provider.getValue(PGP_PUBLIC_KEYSTORE_TYPE_ID);
            statusMap.put(EKeySource.KEYSTORE, this.verifyPgpPublicKeystore(pgpKeyStoreLocation, keyStoreType));
        }
        if (StringUtils.isNotBlank((String)(pgpKeyServerLocation = (String)provider.getValue(PGP_PUBLIC_KEYSERVER_LOCATION_ID)))) {
            statusMap.put(EKeySource.KEYSERVER, this.verifyPgpPublicKeyserver(pgpKeyServerLocation));
        }
        if (((Boolean)provider.getValue(ALLOW_PGP_PUBLIC_KEY_OVERWRITE_ID)).booleanValue()) {
            statusMap.put(EKeySource.USER, this.verifyPgpUserUpload());
        }
        return statusMap;
    }

    private List<VerificationStatus> verifySmimeUserUpload() {
        log.info("Verifying S/MIME key upload for user.");
        SnotifyUserProperties userProps = new SnotifyUserProperties();
        UserKeySourceVerification verification = new UserKeySourceVerification(ECryptographyType.SMIME, userProps, this.getSnotifyI18n());
        verification.useEmail(this.getVerificationEmail(), ConfluenceUser::lookupUser);
        return verification.verify();
    }

    private List<VerificationStatus> verifySmimePublicKeystore(String smimePublicKeystoreLocation, String smimePublicKeystoreType) {
        log.info("Verifying S/MIME public key store at location: {}", (Object)smimePublicKeystoreLocation);
        String email = this.getVerificationEmail();
        ISnotifyI18n i18n = this.getSnotifyI18n();
        switch (smimePublicKeystoreType) {
            case "BKS": {
                SmimeKeyStoreVerification ksVerification = new SmimeKeyStoreVerification(smimePublicKeystoreLocation, smimePublicKeystoreType, i18n);
                if (email != null) {
                    ksVerification.getEmails().add(email);
                }
                return ksVerification.verify();
            }
            case "PKCS7": {
                SmimeP7bVerification p7bVerification = new SmimeP7bVerification(smimePublicKeystoreLocation, i18n);
                if (email != null) {
                    p7bVerification.getEmails().add(email);
                }
                return p7bVerification.verify();
            }
        }
        log.error("Unknown key store type encountered: {}", (Object)smimePublicKeystoreType);
        VerificationStatus status = new VerificationStatus();
        status.status = EVerificationStatus.ERROR;
        status.title = i18n.getText("snotify-keystore-settings-webwork.input.smime.public.keystore.verification.typeError.title");
        status.message = i18n.getText("snotify-keystore-settings-webwork.input.smime.public.keystore.verification.typeError.message", (Object)smimePublicKeystoreType);
        return Collections.singletonList(status);
    }

    private List<VerificationStatus> verifyPgpUserUpload() {
        log.info("Verifying PGP key upload for user.");
        SnotifyUserProperties userProps = new SnotifyUserProperties();
        UserKeySourceVerification verification = new UserKeySourceVerification(ECryptographyType.PGP, userProps, this.getSnotifyI18n());
        verification.useEmail(this.getVerificationEmail(), ConfluenceUser::lookupUser);
        return verification.verify();
    }

    private List<VerificationStatus> verifyPgpPublicKeystore(String pgpPublicKeystoreLocation, String pgpPublicKeystoreType) {
        log.info("Verifying PGP public key store at location: {}", (Object)pgpPublicKeystoreLocation);
        String email = this.getVerificationEmail();
        ISnotifyI18n i18n = this.getSnotifyI18n();
        switch (pgpPublicKeystoreType) {
            case "KEYRING": {
                PgpPublicKeyStoreVerification keyringVerification = new PgpPublicKeyStoreVerification(pgpPublicKeystoreLocation, i18n);
                keyringVerification.setEmail(email);
                return keyringVerification.verify();
            }
            case "KBX": {
                PgpKeyBoxVerification kbxVerification = new PgpKeyBoxVerification(pgpPublicKeystoreLocation, i18n);
                kbxVerification.setEmail(email);
                return kbxVerification.verify();
            }
        }
        log.error("Unknown key store type encountered: {}", (Object)pgpPublicKeystoreLocation);
        VerificationStatus status = new VerificationStatus();
        status.status = EVerificationStatus.ERROR;
        status.title = i18n.getText("snotify-keystore-settings-webwork.input.pgp.public.keystore.verification.typeError.title");
        status.message = i18n.getText("snotify-keystore-settings-webwork.input.pgp.public.keystore.verification.typeError.message", (Object)pgpPublicKeystoreLocation);
        return Collections.singletonList(status);
    }

    private List<VerificationStatus> verifyPgpPublicKeyserver(String pgpPublicKeyserverLocation) {
        AKeySourceVerification verification;
        URI uri;
        log.info("Verifying PGP public key server at location: {}", (Object)pgpPublicKeyserverLocation);
        String email = this.getVerificationEmail();
        ISnotifyI18n i18n = this.getSnotifyI18n();
        try {
            uri = new URI(pgpPublicKeyserverLocation);
        }
        catch (URISyntaxException e) {
            log.debug("Given url was not valid: {}", (Object)pgpPublicKeyserverLocation);
            VerificationStatus status = new VerificationStatus();
            status.status = EVerificationStatus.ERROR;
            status.title = i18n.getText("snotify-keystore-settings-webwork.input.smime.public.keyserver.verification.invalidUrl.title");
            status.message = i18n.getText("snotify-keystore-settings-webwork.input.smime.public.keyserver.verification.invalid.message", (Object)pgpPublicKeyserverLocation);
            return Collections.singletonList(status);
        }
        if (uri.getScheme() != null && uri.getScheme().startsWith("ldap")) {
            LdapConnector connector = new LdapConnector();
            connector.setHost(uri.getHost());
            connector.setPort(uri.getPort());
            connector.setSsl(uri.getScheme().equals("ldaps"));
            PgpGlobalDirectoryLoader loader = new PgpGlobalDirectoryLoader(connector);
            PgpGlobalDirectoryVerification pgdVerification = new PgpGlobalDirectoryVerification(loader, i18n);
            pgdVerification.setEmail(email);
            verification = pgdVerification;
        } else {
            PgpKeyServerLoader loader = new PgpKeyServerLoader(pgpPublicKeyserverLocation);
            verification = new PgpKeyServerVerification(loader, email, i18n);
        }
        return verification.verify();
    }

    private List<VerificationStatus> verifySmimePublicUserDirectory() {
        AtlassianLdapConnector connector;
        Directory directory;
        log.info("Verifying user directory for S/MIME public certificates.");
        String email = this.getVerificationEmail();
        ISnotifyI18n i18n = this.getSnotifyI18n();
        ConfluenceUser userForEmail = ConfluenceUser.lookupUser(email);
        if (userForEmail == null) {
            log.debug("Could not find user with email <{}>.", (Object)email);
            VerificationStatus status = new VerificationStatus();
            status.status = EVerificationStatus.WARNING;
            status.title = i18n.getText("snotify-keystore-settings-webwork.input.smime.public.directory.verification.unknownUser.title");
            status.message = i18n.getText("snotify-keystore-settings-webwork.input.smime.public.directory.verification.unknownUser.message", (Object)email);
            return Collections.singletonList(status);
        }
        com.atlassian.crowd.embedded.api.User user = this.getCrowdUser(userForEmail.getActualUser());
        if (user == null) {
            log.debug("Could not find a crowd user for user: {}", (Object)this.getAuthenticatedUser());
            VerificationStatus status = new VerificationStatus();
            status.status = EVerificationStatus.WARNING;
            status.title = i18n.getText("snotify-keystore-settings-webwork.input.smime.public.directory.verification.dirUserNotFound.title");
            status.message = i18n.getText("snotify-keystore-settings-webwork.input.smime.public.directory.verification.dirUserNotFound.message", (Object)this.getAuthenticatedUser());
            return Collections.singletonList(status);
        }
        long directoryId = user.getDirectoryId();
        String userName = user.getName();
        DirectoryManager manager = (DirectoryManager)ComponentLocator.getComponent(DirectoryManager.class);
        try {
            directory = manager.findDirectoryById(directoryId);
        }
        catch (DirectoryNotFoundException e) {
            log.error("Could not find directory with ID " + directoryId + ". Error message: " + e.getMessage(), (Throwable)e);
            VerificationStatus status = new VerificationStatus();
            status.status = EVerificationStatus.ERROR;
            status.title = i18n.getText("snotify-keystore-settings-webwork.input.smime.public.directory.verification.dirNotFound.title");
            status.message = i18n.getText("snotify-keystore-settings-webwork.input.smime.public.directory.verification.dirNotFound.message", (Object)directoryId, (Object)e.getMessage());
            return Collections.singletonList(status);
        }
        if (!AtlassianLdapConnector.isConnector(directory)) {
            log.debug("Directory {} is probably not an LDAP directory.", (Object)directory.getName());
            VerificationStatus status = new VerificationStatus();
            status.status = EVerificationStatus.WARNING;
            status.title = i18n.getText("snotify-keystore-settings-webwork.input.smime.public.directory.verification.dirNotLdap.title");
            status.message = i18n.getText("snotify-keystore-settings-webwork.input.smime.public.directory.verification.dirNotLdap.message", (Object)directory.getName(), (Object)userName);
            return Collections.singletonList(status);
        }
        try {
            connector = AtlassianLdapConnector.createConnector(directory);
        }
        catch (ConfigurationException e) {
            log.error("Could not create an LDAP connection from directory " + directory.getName() + ". Error message: " + e.getMessage());
            VerificationStatus status = new VerificationStatus();
            status.status = EVerificationStatus.ERROR;
            status.title = i18n.getText("snotify-keystore-settings-webwork.input.smime.public.directory.verification.dirError.title");
            status.message = i18n.getText("snotify-keystore-settings-webwork.input.smime.public.directory.verification.dirError.message", (Object)e.getMessage());
            return Collections.singletonList(status);
        }
        connector.setDisableTrustCheck(connector.isDisableTrustCheck() && this.getAppProps().getBoolean(EProperty.TWEAK_USER_DIRECTORY_INSECURE));
        SmimeLdapLoader loader = new SmimeLdapLoader(connector);
        loader.setKeySource(EKeySource.ATLASSIAN_DIRECTORY);
        if (this.getAppProps().hasKey(EProperty.TWEAK_LDAP_CONTEXT_REFERRAL)) {
            loader.setEnvironment(Collections.singletonMap("java.naming.referral", this.getAppProps().getString(EProperty.TWEAK_LDAP_CONTEXT_REFERRAL)));
        }
        loader.setExpectP7b(this.getAppProps().getBoolean(EProperty.TWEAK_EXPECT_P7B_IN_LDAP));
        String userFilter = "(" + connector.getUserNameKey() + "=" + userName + ")";
        SmimeLdapVerification verification = new SmimeLdapVerification(loader, userFilter, i18n);
        verification.setEmail(user.getEmailAddress());
        verification.setUserNotFoundStatus(EVerificationStatus.ERROR);
        return verification.verify();
    }

    private List<VerificationStatus> verifySmimePublicLdap(LdapConnector connector, String mailAttr) {
        log.info("Verifying LDAP configuration for S/MIME public certificates.");
        SmimeLdapLoader loader = new SmimeLdapLoader(connector);
        if (this.getAppProps().hasKey(EProperty.TWEAK_LDAP_CONTEXT_REFERRAL)) {
            loader.setEnvironment(Collections.singletonMap("java.naming.referral", this.getAppProps().getString(EProperty.TWEAK_LDAP_CONTEXT_REFERRAL)));
        }
        String email = this.getVerificationEmail();
        String userFilter = "(" + mailAttr + "=" + email + ")";
        SmimeLdapVerification verification = new SmimeLdapVerification(loader, userFilter, this.getSnotifyI18n());
        verification.setEmail(email);
        return verification.verify();
    }

    private com.atlassian.crowd.embedded.api.User getCrowdUser(User user) {
        if (user instanceof com.atlassian.crowd.embedded.api.User) {
            return (com.atlassian.crowd.embedded.api.User)user;
        }
        if (user instanceof ConfluenceUserImpl) {
            return this.getCrowdUser(((ConfluenceUserImpl)user).getBackingUser());
        }
        return null;
    }

    private void clearCache() {
        this.getAppProps().setLong(EProperty.EXPIRE_KEYS_PUBLIC_TIMESTAMP, System.currentTimeMillis());
    }

    private EEncryptionTypePriority getTypePriority() {
        if (this.typePriority == null) {
            this.typePriority = this.getAppProps().getEnum(EProperty.ENCRYPTION_TYPE_PRIORITY, EEncryptionTypePriority.class);
        }
        return this.typePriority;
    }

    @Override
    public <T> IValueHandler<T> getValueHandler(String id) {
        IValueHandler handler = this.valueContainer.getValueHandler(id);
        if (handler != null) {
            return handler;
        }
        return this.ldapProvider.getValueHandler(id);
    }

    public boolean isSmimeSelected() {
        if (this.lastSubmit == ECryptographyType.SMIME) {
            return true;
        }
        if (this.lastSubmit == ECryptographyType.PGP) {
            return false;
        }
        switch (this.getTypePriority()) {
            case SMIME_ONLY: 
            case SMIME_PREFERED: {
                return true;
            }
            case PGP_ONLY: 
            case PGP_PREFERED: {
                return false;
            }
        }
        log.error("Type priority not yet implemented: {}", (Object)this.getTypePriority());
        return false;
    }

    public boolean isPgpSelected() {
        if (this.lastSubmit == ECryptographyType.PGP) {
            return true;
        }
        if (this.lastSubmit == ECryptographyType.SMIME) {
            return false;
        }
        switch (this.getTypePriority()) {
            case SMIME_ONLY: 
            case SMIME_PREFERED: {
                return false;
            }
            case PGP_ONLY: 
            case PGP_PREFERED: {
                return true;
            }
        }
        log.error("Type priority not yet implemented: {}", (Object)this.getTypePriority());
        return false;
    }

    public String getActiveTab() {
        if (this.isSmimeSelected()) {
            return ECryptographyType.SMIME.name();
        }
        if (this.isPgpSelected()) {
            return ECryptographyType.PGP.name();
        }
        log.warn("Unknown tab selected. Defaulting to S/MIME tab.");
        return ECryptographyType.SMIME.name();
    }

    private ECryptographyType getSelectedTab(String tab) {
        try {
            return ECryptographyType.valueOf(tab);
        }
        catch (Exception e) {
            log.warn("Unknown tab \"" + tab + "\" encountered. Defaulting to S/MIME tab. Error message: " + e.getMessage(), (Throwable)e);
            return ECryptographyType.SMIME;
        }
    }

    public boolean isShowExpireCacheInfo() {
        return this.expireKeys;
    }

    public boolean isShowLeavingPageWarning() {
        return this.verifyMessage != null;
    }

    @HtmlSafe
    public String getVerificationMessage() {
        return this.verifyMessage == null ? "" : this.verifyMessage;
    }

    public String getVerificationEmail() {
        return this.verificationEmail;
    }
}

