/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.confluence.gui.action;

import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.mail.server.MailServerManager;
import com.atlassian.mail.server.SMTPMailServer;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.velocity.htmlsafe.HtmlSafe;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import net.savignano.cryptography.enums.ECryptographyType;
import net.savignano.cryptography.enums.EEncryptionTypePriority;
import net.savignano.cryptography.util.SecurityUtil;
import net.savignano.snotify.atlassian.common.EProperty;
import net.savignano.snotify.atlassian.common.ISnotifyI18n;
import net.savignano.snotify.atlassian.common.properties.ASnotifyAppProperties;
import net.savignano.snotify.atlassian.gui.keysource.verification.VerificationStatus;
import net.savignano.snotify.atlassian.gui.keysource.verification.pgp.PgpPrivateKeyStoreVerification;
import net.savignano.snotify.atlassian.gui.keysource.verification.smime.SmimeKeyStoreVerification;
import net.savignano.snotify.atlassian.gui.templates.handler.IValueHandler;
import net.savignano.snotify.atlassian.gui.templates.handler.IValueHandlerProvider;
import net.savignano.snotify.atlassian.gui.templates.handler.impl.InputHandler;
import net.savignano.snotify.atlassian.gui.templates.handler.impl.PasswordHandler;
import net.savignano.snotify.atlassian.gui.templates.handler.impl.provider.ValueHandlerContainer;
import net.savignano.snotify.confluence.gui.action.SnotifyAdminSettingsAction;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnotifyPrivateKeystoreSettingsAction
extends SnotifyAdminSettingsAction
implements IValueHandlerProvider {
    private static final long serialVersionUID = -5096387841643437917L;
    private static final String SMIME_PRIVATE_KEYSTORE_LOCATION_ID = "smimePrivateKeystoreLocation";
    private static final String SMIME_PRIVATE_KEYSTORE_PASSWORD_ID = "smimePrivateKeystorePassword";
    private static final String PGP_PRIVATE_KEYSTORE_LOCATION_ID = "pgpPrivateKeystoreLocation";
    private static final String PGP_PRIVATE_KEY_PASSWORD_ID = "pgpPrivateKeyPassword";
    private static final String VERIFY_PGP_BUTTON_PARAM = "Test settings pgp";
    private static final String VERIFY_SMIME_BUTTON_PARAM = "Test settings smime";
    private static final String CLEAR_CACHE_PGP_BUTTON_PARAM = "Clear Cache pgp";
    private static final String CLEAR_CACHE_SMIME_PARAM = "Clear Cache smime";
    private static final String SUBMIT_PGP_BUTTON_PARAM = "Update pgp";
    private static final String SUBMIT_SMIME_BUTTON_PARAM = "Update smime";
    private static final Logger log = LoggerFactory.getLogger(SnotifyPrivateKeystoreSettingsAction.class);
    private ValueHandlerContainer valueContainer;
    private String verifyMessage;
    private boolean expireKeys;
    private EEncryptionTypePriority typePriority;
    private ECryptographyType lastSubmit;
    private String mailServerEmail;

    public String doInput() {
        if (!this.hasAdminRights()) {
            ConfluenceUser user = this.getAuthenticatedUser();
            log.warn("Unauthorized access to view global S/Notify values from user: {}", (Object)(user != null ? user.getFullName() : "<Unknown User>"));
            return "error";
        }
        this.createValueHandlers();
        this.valueContainer.read();
        return "input";
    }

    public String doSubmit() {
        HttpServletRequest request = this.getCurrentRequest();
        if (!"POST".equals(request.getMethod())) {
            log.debug("Access to submit method redirected to input method, as request method wasn't 'POST'. Used method: " + request.getMethod());
            return this.doInput();
        }
        if (!this.hasAdminRights()) {
            ConfluenceUser user = this.getAuthenticatedUser();
            log.warn("Unauthorized access to submit private S/Notify values from user: {}", (Object)(user != null ? user.getFullName() : "<Unknown User>"));
            return "error";
        }
        this.createValueHandlers();
        this.valueContainer.receive(request);
        this.clearCache();
        if (request.getParameter(SUBMIT_PGP_BUTTON_PARAM) != null) {
            this.lastSubmit = ECryptographyType.PGP;
            this.storeSettings();
            return "input";
        }
        if (request.getParameter(SUBMIT_SMIME_BUTTON_PARAM) != null) {
            this.lastSubmit = ECryptographyType.SMIME;
            this.storeSettings();
            return "input";
        }
        if (request.getParameter(VERIFY_PGP_BUTTON_PARAM) != null) {
            this.lastSubmit = ECryptographyType.PGP;
            this.verifySettings(this.valueContainer);
            return "input";
        }
        if (request.getParameter(VERIFY_SMIME_BUTTON_PARAM) != null) {
            this.lastSubmit = ECryptographyType.SMIME;
            this.verifySettings(this.valueContainer);
            return "input";
        }
        if (request.getParameter(CLEAR_CACHE_PGP_BUTTON_PARAM) != null) {
            this.lastSubmit = ECryptographyType.PGP;
            this.expireKeys = true;
            return "input";
        }
        if (request.getParameter(CLEAR_CACHE_SMIME_PARAM) != null) {
            this.lastSubmit = ECryptographyType.SMIME;
            this.expireKeys = true;
            return "input";
        }
        log.error("Unknown submit option used.");
        return "input";
    }

    private void createValueHandlers() {
        if (this.valueContainer != null) {
            return;
        }
        this.valueContainer = new ValueHandlerContainer();
        this.valueContainer.add(new InputHandler(SMIME_PRIVATE_KEYSTORE_LOCATION_ID, this.getAppProps(), EProperty.PRIVATE_SMIME_KEYSTORE_LOCATION));
        this.valueContainer.add(new PasswordHandler(SMIME_PRIVATE_KEYSTORE_PASSWORD_ID, (ASnotifyAppProperties)this.getAppProps(), EProperty.PRIVATE_SMIME_KEY_PASSWORD));
        this.valueContainer.add(new InputHandler(PGP_PRIVATE_KEYSTORE_LOCATION_ID, this.getAppProps(), EProperty.PRIVATE_PGP_KEYSTORE_LOCATION));
        this.valueContainer.add(new PasswordHandler(PGP_PRIVATE_KEY_PASSWORD_ID, (ASnotifyAppProperties)this.getAppProps(), EProperty.PRIVATE_PGP_KEY_PASSWORD));
    }

    private void storeSettings() {
        this.valueContainer.store();
        this.valueContainer.read();
        this.setShowUpdated(true);
    }

    private void verifySettings(IValueHandlerProvider provider) {
        String pgpPrivateKeystoreLocation;
        ArrayList<VerificationStatus> statusList = new ArrayList<VerificationStatus>();
        String smimePrivateKeystoreLocation = (String)provider.getValue(SMIME_PRIVATE_KEYSTORE_LOCATION_ID);
        if (StringUtils.isNotBlank((String)smimePrivateKeystoreLocation)) {
            char[] smimePrivateKeystorePassword = (char[])provider.getValue(SMIME_PRIVATE_KEYSTORE_PASSWORD_ID);
            smimePrivateKeystorePassword = (char[])provider.getValue(SMIME_PRIVATE_KEYSTORE_PASSWORD_ID);
            statusList.addAll(this.verifySmimePrivateKeystore(smimePrivateKeystoreLocation, smimePrivateKeystorePassword));
            SecurityUtil.clearPassword(smimePrivateKeystorePassword);
        }
        if (StringUtils.isNotBlank((String)(pgpPrivateKeystoreLocation = (String)provider.getValue(PGP_PRIVATE_KEYSTORE_LOCATION_ID)))) {
            char[] pgpPrivateKeyPassword = (char[])provider.getValue(PGP_PRIVATE_KEY_PASSWORD_ID);
            statusList.addAll(this.verifyPgpPrivateKeystore(pgpPrivateKeystoreLocation, pgpPrivateKeyPassword));
            SecurityUtil.clearPassword(pgpPrivateKeyPassword);
        }
        StringBuilder builder = new StringBuilder(512 * statusList.size());
        for (VerificationStatus status : statusList) {
            builder.append(status.getHtmlStatus());
        }
        this.verifyMessage = builder.toString();
    }

    private List<VerificationStatus> verifySmimePrivateKeystore(String smimePrivateKeystoreLocation, char[] smimePrivateKeystorePassword) {
        log.info("Verifying S/MIME private key store at location: {}", (Object)smimePrivateKeystoreLocation);
        ISnotifyI18n i18n = this.getSnotifyI18n();
        SmimeKeyStoreVerification verification = new SmimeKeyStoreVerification(smimePrivateKeystoreLocation, "PKCS12", i18n);
        verification.getEmails().addAll(this.getEmails());
        verification.setEnablePrivateKeyCheck(true);
        verification.setKeyStorePassword(smimePrivateKeystorePassword);
        verification.setKeyPassword(smimePrivateKeystorePassword);
        return verification.verify();
    }

    private List<VerificationStatus> verifyPgpPrivateKeystore(String pgpPrivateKeystoreLocation, char[] pgpPrivateKeyPassword) {
        log.info("Verifying PGP private key store at location: {}", (Object)pgpPrivateKeystoreLocation);
        ISnotifyI18n i18n = this.getSnotifyI18n();
        PgpPrivateKeyStoreVerification verification = new PgpPrivateKeyStoreVerification(pgpPrivateKeystoreLocation, i18n);
        verification.getEmails().addAll(this.getEmails());
        verification.setPassword(pgpPrivateKeyPassword);
        return verification.verify();
    }

    private void clearCache() {
        this.getAppProps().setLong(EProperty.EXPIRE_KEYS_PRIVATE_TIMESTAMP, System.currentTimeMillis());
    }

    private EEncryptionTypePriority getTypePriority() {
        if (this.typePriority == null) {
            this.typePriority = this.getAppProps().getEnum(EProperty.ENCRYPTION_TYPE_PRIORITY, EEncryptionTypePriority.class);
        }
        return this.typePriority;
    }

    private List<String> getEmails() {
        ArrayList<String> emails = new ArrayList<String>();
        String email = this.getMailServerEmail();
        if (email != null) {
            emails.add(email);
        }
        return emails;
    }

    private String getMailServerEmail() {
        if (this.mailServerEmail == null) {
            SMTPMailServer mailServer = ((MailServerManager)ComponentLocator.getComponent(MailServerManager.class)).getDefaultSMTPMailServer();
            if (mailServer != null) {
                this.mailServerEmail = mailServer.getDefaultFrom();
                log.debug("Mail addressed used by default mail server: <{}>", (Object)this.mailServerEmail);
            } else {
                log.debug("No outgoing mail server registered. Could not determine sending address.");
            }
        }
        return this.mailServerEmail;
    }

    @Override
    public <T> IValueHandler<T> getValueHandler(String id) {
        return this.valueContainer.getValueHandler(id);
    }

    public boolean isSmimeSelected() {
        if (this.lastSubmit == ECryptographyType.SMIME) {
            return true;
        }
        if (this.lastSubmit == ECryptographyType.PGP) {
            return false;
        }
        switch (this.getTypePriority()) {
            case SMIME_ONLY: 
            case SMIME_PREFERED: {
                return true;
            }
            case PGP_ONLY: 
            case PGP_PREFERED: {
                return false;
            }
        }
        log.error("Type priority not yet implemented: {}", (Object)this.getTypePriority());
        return false;
    }

    public boolean isPgpSelected() {
        if (this.lastSubmit == ECryptographyType.PGP) {
            return true;
        }
        if (this.lastSubmit == ECryptographyType.SMIME) {
            return false;
        }
        switch (this.getTypePriority()) {
            case SMIME_ONLY: 
            case SMIME_PREFERED: {
                return false;
            }
            case PGP_ONLY: 
            case PGP_PREFERED: {
                return true;
            }
        }
        log.error("Type priority not yet implemented: {}", (Object)this.getTypePriority());
        return false;
    }

    public boolean isShowExpireCacheInfo() {
        return this.expireKeys;
    }

    public boolean isShowLeavingPageWarning() {
        return this.verifyMessage != null;
    }

    @HtmlSafe
    public String getVerificationMessage() {
        return this.verifyMessage == null ? "" : this.verifyMessage;
    }
}

