/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.confluence.gui.action;

import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.status.service.SystemInformationService;
import com.atlassian.confluence.status.service.systeminfo.ConfluenceInfo;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.core.filters.ServletContextThreadLocal;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.user.User;
import com.atlassian.velocity.htmlsafe.HtmlSafe;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.function.Supplier;
import javax.servlet.http.HttpServletResponse;
import net.savignano.cryptography.Constants;
import net.savignano.snotify.atlassian.common.EProperty;
import net.savignano.snotify.atlassian.common.properties.ASnotifyAppProperties;
import net.savignano.snotify.atlassian.gui.SupportBuilder;
import net.savignano.snotify.atlassian.gui.keysource.verification.VerificationStatusBuilder;
import net.savignano.snotify.confluence.gui.action.SnotifyAdminSettingsAction;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class TweakSnotifyAction
extends SnotifyAdminSettingsAction {
    private static final long serialVersionUID = -5724732786574664952L;
    private static final Logger log = LoggerFactory.getLogger(TweakSnotifyAction.class);
    private static final String KEY_PARAM = "key";
    private static final String VALUE_PARAM = "value";
    private String errorMessage;
    private InputStream supportStream;
    @Autowired
    @ComponentImport
    private PluginLicenseManager licenseManager;

    public String doInput() {
        if (!this.hasAdminRights()) {
            ConfluenceUser user = this.getAuthenticatedUser();
            log.warn("Unauthorized access to view S/Notify tweak values from user: {}", (Object)(user != null ? user.getFullName() : "<Unknown User>"));
            return "error";
        }
        return "input";
    }

    public String doAdd() {
        if (!"POST".equals(this.getCurrentRequest().getMethod())) {
            log.debug("Access to submit method redirected to input method, as request method wasn't 'POST'. Used method: " + this.getCurrentRequest().getMethod());
            return this.doInput();
        }
        if (!this.hasAdminRights()) {
            ConfluenceUser user = this.getAuthenticatedUser();
            log.warn("Unauthorized access to view S/Notify tweak values from user: {}", (Object)(user != null ? user.getFullName() : "<Unknown User>"));
            return "error";
        }
        String key = this.getCurrentRequest().getParameter(KEY_PARAM);
        String value = this.getCurrentRequest().getParameter(VALUE_PARAM);
        log.debug("Adding key/value pair to tweak: {} = {}", (Object)key, (Object)value);
        if (StringUtils.isBlank((CharSequence)key) || StringUtils.isBlank((CharSequence)value)) {
            log.debug("Key or Value is considered empty. Tweak will not be added.");
            return "input";
        }
        this.setProperty(key, value);
        return "input";
    }

    public String doUpdate() {
        if (!"POST".equals(this.getCurrentRequest().getMethod())) {
            log.debug("Access to submit method redirected to input method, as request method wasn't 'POST'. Used method: " + this.getCurrentRequest().getMethod());
            return this.doInput();
        }
        if (!this.hasAdminRights()) {
            ConfluenceUser user = this.getAuthenticatedUser();
            log.warn("Unauthorized access to view S/Notify tweak values from user: {}", (Object)(user != null ? user.getFullName() : "<Unknown User>"));
            return "error";
        }
        String key = this.getCurrentRequest().getParameter(KEY_PARAM);
        String value = this.getCurrentRequest().getParameter(VALUE_PARAM);
        log.debug("Updating key/value pair to tweak: {} = {}", (Object)key, (Object)value);
        if (StringUtils.isBlank((CharSequence)key) || StringUtils.isBlank((CharSequence)value)) {
            log.debug("Key or Value is considered empty. Tweak will not be updated.");
            return "input";
        }
        this.setProperty(key, value);
        return "input";
    }

    private void setProperty(String key, String value) {
        Optional<EProperty> prop = EProperty.getProperty("tweak." + key);
        if (!prop.isPresent()) {
            log.debug("Key {} does not represent a tweak.", (Object)key);
            VerificationStatusBuilder builder = new VerificationStatusBuilder(this.getSnotifyI18n());
            builder.error();
            builder.title("snotify-tweak-webwork.input.error.notAPropertyTitle", new Object[0]);
            builder.message("snotify-tweak-webwork.input.error.notAPropertyMessage", key);
            this.errorMessage = builder.build().getHtmlStatus();
            return;
        }
        ((ASnotifyAppProperties)this.getAppProps()).setAsString(prop.get(), value);
        Map<String, String> tweaks = this.getUsedTweaks();
        tweaks.put(key, value);
        this.setUsedTweaks(tweaks);
        this.setShowUpdated(true);
    }

    public String doDelete() {
        if (!((PermissionManager)ComponentLocator.getComponent(PermissionManager.class)).isSystemAdministrator((User)this.getAuthenticatedUser())) {
            ConfluenceUser user = this.getAuthenticatedUser();
            log.warn("Unauthorized access to view S/Notify tweak values from user: {}", (Object)(user != null ? user.getFullName() : "<Unknown User>"));
            return "error";
        }
        String key = this.getCurrentRequest().getParameter(KEY_PARAM);
        log.debug("Removing key from tweaks: {}", (Object)key);
        if (StringUtils.isBlank((CharSequence)key)) {
            log.debug("Key is considered empty. Tweak will not be removed.");
            return "input";
        }
        Optional<EProperty> prop = EProperty.getProperty("tweak." + key);
        if (prop.isPresent()) {
            ((ASnotifyAppProperties)this.getAppProps()).setAsString(prop.get(), null);
        } else {
            log.debug("Key {} does not represent a tweak.", (Object)key);
        }
        Map<String, String> tweaks = this.getUsedTweaks();
        tweaks.remove(key);
        this.setUsedTweaks(tweaks);
        this.setShowUpdated(true);
        return "input";
    }

    public String doSupport() {
        if (!((PermissionManager)ComponentLocator.getComponent(PermissionManager.class)).isSystemAdministrator((User)this.getAuthenticatedUser())) {
            ConfluenceUser user = this.getAuthenticatedUser();
            log.warn("Unauthorized access to view S/Notify tweak values from user: {}", (Object)(user != null ? user.getFullName() : "<Unknown User>"));
            return "error";
        }
        String data = this.createSupportData();
        byte[] contents = data.getBytes(Constants.UTF8_CHARSET);
        this.supportStream = new ByteArrayInputStream(contents);
        HttpServletResponse response = ServletContextThreadLocal.getResponse();
        response.setHeader("Content-Length", String.valueOf(contents.length));
        response.setHeader("Cache-Control", "no-cache");
        response.setHeader("Pragma", "no-cache");
        response.setHeader("Expires", "-1");
        response.setHeader("Content-Disposition", "attachment; filename=\"snotify-support.txt\"");
        return "download";
    }

    private String createSupportData() {
        Supplier<String> platform = () -> {
            SystemInformationService service = (SystemInformationService)ComponentLocator.getComponent(SystemInformationService.class);
            ConfluenceInfo info = service.getConfluenceInfo();
            return "Confluence " + info.getVersion();
        };
        return SupportBuilder.create().includeLicenseId(this.licenseManager).includePlatform(platform).includeProperties(this.getAppProps()).build();
    }

    public Collection<Map.Entry<String, String>> getTweakEntries() {
        return this.getUsedTweaks().entrySet();
    }

    @HtmlSafe
    public String getErrorMessage() {
        return this.errorMessage == null ? "" : this.errorMessage;
    }

    private Map<String, String> getUsedTweaks() {
        TreeMap<String, String> tweaks = new TreeMap<String, String>();
        String tweakString = this.getAppProps().getUnlimitedString(EProperty.TWEAK_OVERVIEW);
        if (tweakString != null) {
            for (String tweak : tweakString.split("\\;")) {
                Optional<EProperty> prop = EProperty.getProperty("tweak." + tweak);
                if (prop.isPresent()) {
                    tweaks.put(tweak, ((ASnotifyAppProperties)this.getAppProps()).getAsString(prop.get()));
                    continue;
                }
                log.info("Key {} is not considered a tweak. It will be skipped.");
            }
        }
        return tweaks;
    }

    private void setUsedTweaks(Map<String, String> tweaks) {
        if (tweaks == null || tweaks.isEmpty()) {
            this.getAppProps().setUnlimitedString(EProperty.TWEAK_OVERVIEW, null);
        } else {
            StringBuilder builder = new StringBuilder();
            for (Map.Entry<String, String> entry : tweaks.entrySet()) {
                builder.append(entry.getKey());
                builder.append(';');
            }
            builder.deleteCharAt(builder.length() - 1);
            this.getAppProps().setUnlimitedString(EProperty.TWEAK_OVERVIEW, builder.toString());
        }
    }

    public InputStream getSupport() {
        return this.supportStream;
    }
}

