/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.cert.cmp;

import java.io.IOException;
import java.io.OutputStream;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1EncodableVector;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import net.savignano.thirdparty.org.bouncycastle.asn1.DERSequence;
import net.savignano.thirdparty.org.bouncycastle.asn1.cmp.CMPCertificate;
import net.savignano.thirdparty.org.bouncycastle.asn1.cmp.CMPObjectIdentifiers;
import net.savignano.thirdparty.org.bouncycastle.asn1.cmp.PKIBody;
import net.savignano.thirdparty.org.bouncycastle.asn1.cmp.PKIHeader;
import net.savignano.thirdparty.org.bouncycastle.asn1.cmp.PKIMessage;
import net.savignano.thirdparty.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import net.savignano.thirdparty.org.bouncycastle.cert.X509CertificateHolder;
import net.savignano.thirdparty.org.bouncycastle.cert.cmp.CMPException;
import net.savignano.thirdparty.org.bouncycastle.cert.cmp.GeneralPKIMessage;
import net.savignano.thirdparty.org.bouncycastle.operator.ContentVerifier;
import net.savignano.thirdparty.org.bouncycastle.operator.ContentVerifierProvider;
import net.savignano.thirdparty.org.bouncycastle.operator.MacCalculator;
import net.savignano.thirdparty.org.bouncycastle.operator.PBEMacCalculatorProvider;
import net.savignano.thirdparty.org.bouncycastle.util.Arrays;

public class ProtectedPKIMessage {
    private PKIMessage pkiMessage;

    public ProtectedPKIMessage(GeneralPKIMessage pkiMessage) {
        if (!pkiMessage.hasProtection()) {
            throw new IllegalArgumentException("PKIMessage not protected");
        }
        this.pkiMessage = pkiMessage.toASN1Structure();
    }

    ProtectedPKIMessage(PKIMessage pkiMessage) {
        if (pkiMessage.getHeader().getProtectionAlg() == null) {
            throw new IllegalArgumentException("PKIMessage not protected");
        }
        this.pkiMessage = pkiMessage;
    }

    public PKIHeader getHeader() {
        return this.pkiMessage.getHeader();
    }

    public PKIBody getBody() {
        return this.pkiMessage.getBody();
    }

    public PKIMessage toASN1Structure() {
        return this.pkiMessage;
    }

    public boolean hasPasswordBasedMacProtection() {
        ASN1ObjectIdentifier procAlg = this.pkiMessage.getHeader().getProtectionAlg().getAlgorithm();
        return procAlg.equals(CMPObjectIdentifiers.passwordBasedMac);
    }

    public AlgorithmIdentifier getProtectionAlgorithm() {
        return this.pkiMessage.getHeader().getProtectionAlg();
    }

    public X509CertificateHolder[] getCertificates() {
        CMPCertificate[] certs = this.pkiMessage.getExtraCerts();
        if (certs == null) {
            return new X509CertificateHolder[0];
        }
        X509CertificateHolder[] res = new X509CertificateHolder[certs.length];
        for (int i = 0; i != certs.length; ++i) {
            res[i] = new X509CertificateHolder(certs[i].getX509v3PKCert());
        }
        return res;
    }

    public boolean verify(ContentVerifierProvider verifierProvider) throws CMPException {
        try {
            ContentVerifier verifier = verifierProvider.get(this.pkiMessage.getHeader().getProtectionAlg());
            return this.verifySignature(this.pkiMessage.getProtection().getBytes(), verifier);
        }
        catch (Exception e) {
            throw new CMPException("unable to verify signature: " + e.getMessage(), e);
        }
    }

    public boolean verify(PBEMacCalculatorProvider pbeMacCalculatorProvider, char[] password) throws CMPException {
        try {
            MacCalculator calculator = pbeMacCalculatorProvider.get(this.pkiMessage.getHeader().getProtectionAlg(), password);
            OutputStream macOut = calculator.getOutputStream();
            ASN1EncodableVector v = new ASN1EncodableVector();
            v.add(this.pkiMessage.getHeader());
            v.add(this.pkiMessage.getBody());
            macOut.write(new DERSequence(v).getEncoded("DER"));
            macOut.close();
            return Arrays.constantTimeAreEqual(calculator.getMac(), this.pkiMessage.getProtection().getBytes());
        }
        catch (Exception e) {
            throw new CMPException("unable to verify MAC: " + e.getMessage(), e);
        }
    }

    private boolean verifySignature(byte[] signature, ContentVerifier verifier) throws IOException {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(this.pkiMessage.getHeader());
        v.add(this.pkiMessage.getBody());
        OutputStream sOut = verifier.getOutputStream();
        sOut.write(new DERSequence(v).getEncoded("DER"));
        sOut.close();
        return verifier.verify(signature);
    }
}

