/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.openpgp;

import java.io.EOFException;
import java.io.InputStream;
import net.savignano.thirdparty.org.bouncycastle.bcpg.AEADEncDataPacket;
import net.savignano.thirdparty.org.bouncycastle.bcpg.BCPGInputStream;
import net.savignano.thirdparty.org.bouncycastle.bcpg.InputStreamPacket;
import net.savignano.thirdparty.org.bouncycastle.bcpg.SymmetricEncIntegrityPacket;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPDataValidationException;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPEncryptedData;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPException;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPSessionKey;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.PGPDataDecryptor;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.PGPDataDecryptorFactory;
import net.savignano.thirdparty.org.bouncycastle.util.io.TeeInputStream;

public class PGPSymmetricKeyEncryptedData
extends PGPEncryptedData {
    protected PGPSymmetricKeyEncryptedData(InputStreamPacket encData) {
        super(encData);
    }

    protected InputStream createDecryptionStream(PGPDataDecryptorFactory dataDecryptorFactory, PGPSessionKey sessionKey) throws PGPException {
        if (this.encData instanceof AEADEncDataPacket) {
            AEADEncDataPacket aeadData = (AEADEncDataPacket)this.encData;
            if (aeadData.getAlgorithm() != sessionKey.getAlgorithm()) {
                throw new PGPException("session key and AEAD algorithm mismatch");
            }
            PGPDataDecryptor dataDecryptor = dataDecryptorFactory.createDataDecryptor(aeadData.getAEADAlgorithm(), aeadData.getIV(), aeadData.getChunkSize(), sessionKey.getAlgorithm(), sessionKey.getKey());
            BCPGInputStream encIn = this.encData.getInputStream();
            return new BCPGInputStream(dataDecryptor.getInputStream(encIn));
        }
        boolean withIntegrityPacket = this.encData instanceof SymmetricEncIntegrityPacket;
        PGPDataDecryptor dataDecryptor = dataDecryptorFactory.createDataDecryptor(withIntegrityPacket, sessionKey.getAlgorithm(), sessionKey.getKey());
        return this.getDataStream(withIntegrityPacket, dataDecryptor);
    }

    private InputStream getDataStream(boolean withIntegrityPacket, PGPDataDecryptor dataDecryptor) throws PGPException {
        try {
            boolean zeroesCheckPassed;
            BCPGInputStream encIn = this.encData.getInputStream();
            encIn.mark(dataDecryptor.getBlockSize() + 2);
            this.encStream = new BCPGInputStream(dataDecryptor.getInputStream(encIn));
            if (withIntegrityPacket) {
                this.truncStream = new PGPEncryptedData.TruncatedStream(this.encStream);
                this.integrityCalculator = dataDecryptor.getIntegrityCalculator();
                this.encStream = new TeeInputStream(this.truncStream, this.integrityCalculator.getOutputStream());
            }
            byte[] iv = new byte[dataDecryptor.getBlockSize()];
            for (int i = 0; i != iv.length; ++i) {
                int ch = this.encStream.read();
                if (ch < 0) {
                    throw new EOFException("unexpected end of stream.");
                }
                iv[i] = (byte)ch;
            }
            int v1 = this.encStream.read();
            int v2 = this.encStream.read();
            if (v1 < 0 || v2 < 0) {
                throw new EOFException("unexpected end of stream.");
            }
            boolean repeatCheckPassed = iv[iv.length - 2] == (byte)v1 && iv[iv.length - 1] == (byte)v2;
            boolean bl = zeroesCheckPassed = v1 == 0 && v2 == 0;
            if (!repeatCheckPassed && !zeroesCheckPassed) {
                encIn.reset();
                throw new PGPDataValidationException("data check failed.");
            }
            return this.encStream;
        }
        catch (PGPException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PGPException("Exception creating cipher", e);
        }
    }
}

