/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.pqc.crypto.cmce;

import java.security.SecureRandom;
import net.savignano.thirdparty.org.bouncycastle.crypto.digests.SHAKEDigest;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.cmce.BENES;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.cmce.BENES12;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.cmce.BENES13;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.cmce.GF;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.cmce.GF12;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.cmce.GF13;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.cmce.Utils;
import net.savignano.thirdparty.org.bouncycastle.util.Arrays;

class CMCEEngine {
    private int SYS_N;
    private int SYS_T;
    private int GFBITS;
    private int IRR_BYTES;
    private int COND_BYTES;
    private int PK_NROWS;
    private int PK_NCOLS;
    private int PK_ROW_BYTES;
    private int SYND_BYTES;
    private int GFMASK;
    private int[] poly;
    private final int defaultKeySize;
    private GF gf;
    private BENES benes;
    private boolean usePadding;
    private boolean countErrorIndices;
    private boolean usePivots;

    public int getIrrBytes() {
        return this.IRR_BYTES;
    }

    public int getCondBytes() {
        return this.COND_BYTES;
    }

    public int getPrivateKeySize() {
        return this.COND_BYTES + this.IRR_BYTES + this.SYS_N / 8 + 40;
    }

    public int getPublicKeySize() {
        if (this.usePadding) {
            return this.PK_NROWS * (this.SYS_N / 8 - (this.PK_NROWS - 1) / 8);
        }
        return this.PK_NROWS * this.PK_NCOLS / 8;
    }

    public int getCipherTextSize() {
        return this.SYND_BYTES;
    }

    public CMCEEngine(int m, int n, int t, int[] p, boolean usePivots, int defaultKeySize) {
        this.usePivots = usePivots;
        this.SYS_N = n;
        this.SYS_T = t;
        this.GFBITS = m;
        this.poly = p;
        this.defaultKeySize = defaultKeySize;
        this.IRR_BYTES = this.SYS_T * 2;
        this.COND_BYTES = (1 << this.GFBITS - 4) * (2 * this.GFBITS - 1);
        this.PK_NROWS = this.SYS_T * this.GFBITS;
        this.PK_NCOLS = this.SYS_N - this.PK_NROWS;
        this.PK_ROW_BYTES = (this.PK_NCOLS + 7) / 8;
        this.SYND_BYTES = (this.PK_NROWS + 7) / 8;
        this.GFMASK = (1 << this.GFBITS) - 1;
        if (this.GFBITS == 12) {
            this.gf = new GF12();
            this.benes = new BENES12(this.SYS_N, this.SYS_T, this.GFBITS);
        } else {
            this.gf = new GF13();
            this.benes = new BENES13(this.SYS_N, this.SYS_T, this.GFBITS);
        }
        this.usePadding = this.SYS_T % 8 != 0;
        this.countErrorIndices = 1 << this.GFBITS > this.SYS_N;
    }

    public byte[] generate_public_key_from_private_key(byte[] sk) {
        byte[] pk = new byte[this.getPublicKeySize()];
        short[] pi = new short[1 << this.GFBITS];
        long[] pivots = new long[]{0L};
        int[] perm = new int[1 << this.GFBITS];
        byte[] hash = new byte[this.SYS_N / 8 + (1 << this.GFBITS) * 4];
        int hash_idx = hash.length - 32 - this.IRR_BYTES - (1 << this.GFBITS) * 4;
        SHAKEDigest digest = new SHAKEDigest(256);
        digest.update((byte)64);
        digest.update(sk, 0, 32);
        digest.doFinal(hash, 0, hash.length);
        for (int i = 0; i < 1 << this.GFBITS; ++i) {
            perm[i] = Utils.load4(hash, hash_idx + i * 4);
        }
        this.pk_gen(pk, sk, perm, pi, pivots);
        return pk;
    }

    public byte[] decompress_private_key(byte[] sk) {
        int i;
        byte[] reg_sk = new byte[this.getPrivateKeySize()];
        System.arraycopy(sk, 0, reg_sk, 0, sk.length);
        byte[] hash = new byte[this.SYS_N / 8 + (1 << this.GFBITS) * 4 + this.IRR_BYTES + 32];
        int hash_idx = 0;
        SHAKEDigest digest = new SHAKEDigest(256);
        digest.update((byte)64);
        digest.update(sk, 0, 32);
        digest.doFinal(hash, 0, hash.length);
        if (sk.length <= 40) {
            short[] field = new short[this.SYS_T];
            byte[] reg_g = new byte[this.IRR_BYTES];
            hash_idx = hash.length - 32 - this.IRR_BYTES;
            for (i = 0; i < this.SYS_T; ++i) {
                field[i] = Utils.load_gf(hash, hash_idx + i * 2, this.GFMASK);
            }
            this.generate_irr_poly(field);
            for (i = 0; i < this.SYS_T; ++i) {
                Utils.store_gf(reg_g, i * 2, field[i]);
            }
            System.arraycopy(reg_g, 0, reg_sk, 40, this.IRR_BYTES);
        }
        if (sk.length <= 40 + this.IRR_BYTES) {
            int[] perm = new int[1 << this.GFBITS];
            short[] pi = new short[1 << this.GFBITS];
            hash_idx = hash.length - 32 - this.IRR_BYTES - (1 << this.GFBITS) * 4;
            for (i = 0; i < 1 << this.GFBITS; ++i) {
                perm[i] = Utils.load4(hash, hash_idx + i * 4);
            }
            if (this.usePivots) {
                long[] pivots = new long[]{0L};
                this.pk_gen(null, reg_sk, perm, pi, pivots);
            } else {
                long[] buf = new long[1 << this.GFBITS];
                int i2 = 0;
                while (i2 < 1 << this.GFBITS) {
                    buf[i2] = perm[i2];
                    int n = i2;
                    buf[n] = buf[n] << 31;
                    int n2 = i2;
                    buf[n2] = buf[n2] | (long)i2;
                    int n3 = i2++;
                    buf[n3] = buf[n3] & Long.MAX_VALUE;
                }
                CMCEEngine.sort64(buf, 0, buf.length);
                for (i2 = 0; i2 < 1 << this.GFBITS; ++i2) {
                    pi[i2] = (short)(buf[i2] & (long)this.GFMASK);
                }
            }
            byte[] out = new byte[this.COND_BYTES];
            CMCEEngine.controlbitsfrompermutation(out, pi, this.GFBITS, 1 << this.GFBITS);
            System.arraycopy(out, 0, reg_sk, this.IRR_BYTES + 40, out.length);
        }
        System.arraycopy(hash, 0, reg_sk, this.getPrivateKeySize() - this.SYS_N / 8, this.SYS_N / 8);
        return reg_sk;
    }

    public void kem_keypair(byte[] pk, byte[] sk, SecureRandom random) {
        short[] pi;
        byte[] seed_a = new byte[1];
        byte[] seed_b = new byte[32];
        seed_a[0] = 64;
        random.nextBytes(seed_b);
        byte[] E = new byte[this.SYS_N / 8 + (1 << this.GFBITS) * 4 + this.SYS_T * 2 + 32];
        int skIndex = 0;
        byte[] prev_sk = seed_b;
        long[] pivots = new long[]{0L};
        SHAKEDigest digest = new SHAKEDigest(256);
        while (true) {
            int i;
            int sigma1_t;
            digest.update(seed_a, 0, seed_a.length);
            digest.update(seed_b, 0, seed_b.length);
            digest.doFinal(E, 0, E.length);
            int seedIndex = E.length - 32;
            seed_b = Arrays.copyOfRange(E, seedIndex, seedIndex + 32);
            System.arraycopy(prev_sk, 0, sk, 0, 32);
            prev_sk = Arrays.copyOfRange(seed_b, 0, 32);
            short[] field = new short[this.SYS_T];
            seedIndex = sigma1_t = E.length - 32 - 2 * this.SYS_T;
            for (i = 0; i < this.SYS_T; ++i) {
                field[i] = Utils.load_gf(E, sigma1_t + i * 2, this.GFMASK);
            }
            if (this.generate_irr_poly(field) == -1) continue;
            skIndex = 40;
            for (i = 0; i < this.SYS_T; ++i) {
                Utils.store_gf(sk, skIndex + i * 2, field[i]);
            }
            int[] perm = new int[1 << this.GFBITS];
            seedIndex -= (1 << this.GFBITS) * 4;
            for (int i2 = 0; i2 < 1 << this.GFBITS; ++i2) {
                perm[i2] = Utils.load4(E, seedIndex + i2 * 4);
            }
            pi = new short[1 << this.GFBITS];
            if (this.pk_gen(pk, sk, perm, pi, pivots) != -1) break;
        }
        byte[] out = new byte[this.COND_BYTES];
        CMCEEngine.controlbitsfrompermutation(out, pi, this.GFBITS, 1 << this.GFBITS);
        System.arraycopy(out, 0, sk, this.IRR_BYTES + 40, out.length);
        System.arraycopy(E, seedIndex -= this.SYS_N / 8, sk, sk.length - this.SYS_N / 8, this.SYS_N / 8);
        if (!this.usePivots) {
            Utils.store8(sk, 32, 0xFFFFFFFFL);
        } else {
            Utils.store8(sk, 32, pivots[0]);
        }
    }

    private void syndrome(byte[] cipher_text, byte[] pk, byte[] error_vector) {
        int i;
        short[] row = new short[this.SYS_N / 8];
        int pk_ptr = 0;
        int tail = this.PK_NROWS % 8;
        for (i = 0; i < this.SYND_BYTES; ++i) {
            cipher_text[i] = 0;
        }
        for (i = 0; i < this.PK_NROWS; ++i) {
            int j;
            for (j = 0; j < this.SYS_N / 8; ++j) {
                row[j] = 0;
            }
            for (j = 0; j < this.PK_ROW_BYTES; ++j) {
                row[this.SYS_N / 8 - this.PK_ROW_BYTES + j] = pk[pk_ptr + j];
            }
            if (this.usePadding) {
                for (j = this.SYS_N / 8 - 1; j >= this.SYS_N / 8 - this.PK_ROW_BYTES; --j) {
                    row[j] = (short)(((row[j] & 0xFF) << tail | (row[j - 1] & 0xFF) >>> 8 - tail) & 0xFF);
                }
            }
            int n = i / 8;
            row[n] = (short)(row[n] | 1 << i % 8);
            int b = 0;
            for (j = 0; j < this.SYS_N / 8; ++j) {
                b = (byte)(b ^ row[j] & error_vector[j]);
            }
            b = (byte)(b ^ b >>> 4);
            b = (byte)(b ^ b >>> 2);
            b = (byte)(b ^ b >>> 1);
            b = (byte)(b & 1);
            int n2 = i / 8;
            cipher_text[n2] = (byte)(cipher_text[n2] | b << i % 8);
            pk_ptr += this.PK_ROW_BYTES;
        }
    }

    private void generate_error_vector(byte[] error_vector, SecureRandom random) {
        short i;
        short[] buf_nums = new short[this.SYS_T * 2];
        short[] ind = new short[this.SYS_T];
        byte[] val = new byte[this.SYS_T];
        while (true) {
            int i2;
            byte[] buf_bytes;
            if (this.countErrorIndices) {
                buf_bytes = new byte[this.SYS_T * 4];
                random.nextBytes(buf_bytes);
                for (i = 0; i < this.SYS_T * 2; ++i) {
                    buf_nums[i] = Utils.load_gf(buf_bytes, i * 2, this.GFMASK);
                }
                int count = 0;
                for (i2 = 0; i2 < this.SYS_T * 2 && count < this.SYS_T; ++i2) {
                    if (buf_nums[i2] >= this.SYS_N) continue;
                    ind[count++] = buf_nums[i2];
                }
                if (count < this.SYS_T) {
                    continue;
                }
            } else {
                buf_bytes = new byte[this.SYS_T * 2];
                random.nextBytes(buf_bytes);
                for (i = 0; i < this.SYS_T; ++i) {
                    ind[i] = Utils.load_gf(buf_bytes, i * 2, this.GFMASK);
                }
            }
            boolean eq = false;
            block4: for (i2 = 1; i2 < this.SYS_T && !eq; ++i2) {
                for (int j = 0; j < i2; ++j) {
                    if (ind[i2] != ind[j]) continue;
                    eq = true;
                    continue block4;
                }
            }
            if (!eq) break;
        }
        for (i = 0; i < this.SYS_T; ++i) {
            val[i] = (byte)(1 << (ind[i] & 7));
        }
        for (i = 0; i < this.SYS_N / 8; i = (short)((short)(i + 1))) {
            error_vector[i] = 0;
            for (int j = 0; j < this.SYS_T; ++j) {
                short mask = CMCEEngine.same_mask32(i, (short)(ind[j] >> 3));
                mask = (short)(mask & 0xFF);
                short s = i;
                error_vector[s] = (byte)(error_vector[s] | val[j] & mask);
            }
        }
    }

    private void encrypt(byte[] cipher_text, byte[] pk, byte[] error_vector, SecureRandom random) {
        this.generate_error_vector(error_vector, random);
        this.syndrome(cipher_text, pk, error_vector);
    }

    public int kem_enc(byte[] cipher_text, byte[] key, byte[] pk, SecureRandom random) {
        byte[] error_vector = new byte[this.SYS_N / 8];
        int padding_ok = 0;
        if (this.usePadding) {
            padding_ok = this.check_pk_padding(pk);
        }
        this.encrypt(cipher_text, pk, error_vector, random);
        SHAKEDigest digest = new SHAKEDigest(256);
        digest.update((byte)1);
        digest.update(error_vector, 0, error_vector.length);
        digest.update(cipher_text, 0, cipher_text.length);
        digest.doFinal(key, 0, key.length);
        if (this.usePadding) {
            byte mask = (byte)padding_ok;
            mask = (byte)(mask ^ 0xFF);
            int i = 0;
            while (i < this.SYND_BYTES) {
                int n = i++;
                cipher_text[n] = (byte)(cipher_text[n] & mask);
            }
            i = 0;
            while (i < 32) {
                int n = i++;
                key[n] = (byte)(key[n] & mask);
            }
            return padding_ok;
        }
        return 0;
    }

    public int kem_dec(byte[] key, byte[] cipher_text, byte[] sk) {
        int i;
        byte[] error_vector = new byte[this.SYS_N / 8];
        byte[] preimage = new byte[1 + this.SYS_N / 8 + this.SYND_BYTES];
        int padding_ok = 0;
        if (this.usePadding) {
            padding_ok = this.check_c_padding(cipher_text);
        }
        byte ret_decrypt = (byte)this.decrypt(error_vector, sk, cipher_text);
        short m = ret_decrypt;
        m = (short)(m - 1);
        m = (short)(m >> 8);
        m = (short)(m & 0xFF);
        preimage[0] = (byte)(m & 1);
        for (i = 0; i < this.SYS_N / 8; ++i) {
            preimage[1 + i] = (byte)(~m & sk[i + 40 + this.IRR_BYTES + this.COND_BYTES] | m & error_vector[i]);
        }
        for (i = 0; i < this.SYND_BYTES; ++i) {
            preimage[1 + this.SYS_N / 8 + i] = cipher_text[i];
        }
        SHAKEDigest digest = new SHAKEDigest(256);
        digest.update(preimage, 0, preimage.length);
        digest.doFinal(key, 0, key.length);
        if (this.usePadding) {
            byte mask = (byte)padding_ok;
            i = 0;
            while (i < key.length) {
                int n = i++;
                key[n] = (byte)(key[n] | mask);
            }
            return padding_ok;
        }
        return 0;
    }

    private int decrypt(byte[] error_vector, byte[] sk, byte[] cipher_text) {
        int i;
        short[] g = new short[this.SYS_T + 1];
        short[] L = new short[this.SYS_N];
        short[] s = new short[this.SYS_T * 2];
        short[] s_cmp = new short[this.SYS_T * 2];
        short[] locator = new short[this.SYS_T + 1];
        short[] images = new short[this.SYS_N];
        byte[] r = new byte[this.SYS_N / 8];
        for (i = 0; i < this.SYND_BYTES; ++i) {
            r[i] = cipher_text[i];
        }
        for (i = this.SYND_BYTES; i < this.SYS_N / 8; ++i) {
            r[i] = 0;
        }
        for (i = 0; i < this.SYS_T; ++i) {
            g[i] = Utils.load_gf(sk, 40 + i * 2, this.GFMASK);
        }
        g[this.SYS_T] = 1;
        this.benes.support_gen(L, sk);
        this.synd(s, g, L, r);
        this.bm(locator, s);
        this.root(images, locator, L);
        for (i = 0; i < this.SYS_N / 8; ++i) {
            error_vector[i] = 0;
        }
        int w = 0;
        for (int i2 = 0; i2 < this.SYS_N; ++i2) {
            short t = (short)(this.gf.gf_iszero(images[i2]) & 1);
            int n = i2 / 8;
            error_vector[n] = (byte)(error_vector[n] | t << i2 % 8);
            w += t;
        }
        this.synd(s_cmp, g, L, error_vector);
        int check = w;
        check ^= this.SYS_T;
        for (int i3 = 0; i3 < this.SYS_T * 2; ++i3) {
            check |= s[i3] ^ s_cmp[i3];
        }
        --check;
        check >>= 15;
        if (((check &= 1) ^ 1) != 0) {
            // empty if block
        }
        return check ^ 1;
    }

    private static int min(short a, int b) {
        if (a < b) {
            return a;
        }
        return b;
    }

    private void bm(short[] out, short[] s) {
        int i;
        short N = 0;
        int L = 0;
        short[] T = new short[this.SYS_T + 1];
        short[] C = new short[this.SYS_T + 1];
        short[] B = new short[this.SYS_T + 1];
        short b = 1;
        for (i = 0; i < this.SYS_T + 1; ++i) {
            B[i] = 0;
            C[i] = 0;
        }
        C[0] = 1;
        B[1] = 1;
        for (N = 0; N < 2 * this.SYS_T; N = (short)(N + 1)) {
            short d;
            int i2;
            int d_ext = 0;
            for (i2 = 0; i2 <= CMCEEngine.min(N, this.SYS_T); ++i2) {
                d_ext ^= this.gf.gf_mul_ext(C[i2], s[N - i2]);
            }
            short mne = d = this.gf.gf_reduce(d_ext);
            mne = (short)(mne - 1);
            mne = (short)(mne >> 15);
            mne = (short)(mne & 1);
            mne = (short)(mne - 1);
            short mle = N;
            mle = (short)(mle - 2 * L);
            mle = (short)(mle >> 15);
            mle = (short)(mle & 1);
            mle = (short)(mle - 1);
            mle = (short)(mle & mne);
            for (i2 = 0; i2 <= this.SYS_T; ++i2) {
                T[i2] = C[i2];
            }
            short f = this.gf.gf_frac(b, d);
            for (i2 = 0; i2 <= this.SYS_T; ++i2) {
                int n = i2;
                C[n] = (short)(C[n] ^ this.gf.gf_mul(f, B[i2]) & mne);
            }
            L = (short)(L & ~mle | N + 1 - L & mle);
            for (i2 = this.SYS_T - 1; i2 >= 0; --i2) {
                B[i2 + 1] = (short)(B[i2] & ~mle | T[i2] & mle);
            }
            B[0] = 0;
            b = (short)(b & ~mle | d & mle);
        }
        for (i = 0; i <= this.SYS_T; ++i) {
            out[i] = C[this.SYS_T - i];
        }
    }

    private void synd(short[] out, short[] f, short[] L, byte[] r) {
        short c_div_e;
        short c = (short)(r[0] & 1);
        short L_i = L[0];
        short e = this.eval(f, L_i);
        short e_inv = this.gf.gf_inv(this.gf.gf_sq(e));
        out[0] = c_div_e = (short)(e_inv & -c);
        for (int j = 1; j < 2 * this.SYS_T; ++j) {
            out[j] = c_div_e = this.gf.gf_mul(c_div_e, L_i);
        }
        for (int i = 1; i < this.SYS_N; ++i) {
            short c2 = (short)(r[i / 8] >> i % 8 & 1);
            short L_i2 = L[i];
            short e2 = this.eval(f, L_i2);
            short e_inv2 = this.gf.gf_inv(this.gf.gf_sq(e2));
            short c_div_e2 = this.gf.gf_mul(e_inv2, c2);
            out[0] = (short)(out[0] ^ c_div_e2);
            int j = 1;
            while (j < 2 * this.SYS_T) {
                c_div_e2 = this.gf.gf_mul(c_div_e2, L_i2);
                int n = j++;
                out[n] = (short)(out[n] ^ c_div_e2);
            }
        }
    }

    private int mov_columns(byte[][] mat, short[] pi, long[] pivots) {
        long d;
        int k;
        long t;
        int j;
        int i;
        long[] buf = new long[64];
        long[] ctz_list = new long[32];
        long one = 1L;
        byte[] tmp = new byte[9];
        int row = this.PK_NROWS - 32;
        int block_idx = row / 8;
        int tail = row % 8;
        if (this.usePadding) {
            for (i = 0; i < 32; ++i) {
                for (j = 0; j < 9; ++j) {
                    tmp[j] = mat[row + i][block_idx + j];
                }
                for (j = 0; j < 8; ++j) {
                    tmp[j] = (byte)((tmp[j] & 0xFF) >> tail | tmp[j + 1] << 8 - tail);
                }
                buf[i] = Utils.load8(tmp, 0);
            }
        } else {
            for (i = 0; i < 32; ++i) {
                buf[i] = Utils.load8(mat[row + i], block_idx);
            }
        }
        pivots[0] = 0L;
        for (i = 0; i < 32; ++i) {
            long mask;
            t = buf[i];
            for (j = i + 1; j < 32; ++j) {
                t |= buf[j];
            }
            if (t == 0L) {
                return -1;
            }
            int s = CMCEEngine.ctz(t);
            ctz_list[i] = s;
            pivots[0] = pivots[0] | one << (int)ctz_list[i];
            for (j = i + 1; j < 32; ++j) {
                mask = buf[i] >> s & 1L;
                int n = i;
                buf[n] = buf[n] ^ buf[j] & --mask;
            }
            j = i + 1;
            while (j < 32) {
                mask = buf[j] >> s & 1L;
                mask = -mask;
                int n = j++;
                buf[n] = buf[n] ^ buf[i] & mask;
            }
        }
        for (j = 0; j < 32; ++j) {
            for (k = j + 1; k < 64; ++k) {
                d = pi[row + j] ^ pi[row + k];
                int n = row + j;
                pi[n] = (short)((long)pi[n] ^ (d &= CMCEEngine.same_mask64((short)k, (short)ctz_list[j])));
                int n2 = row + k;
                pi[n2] = (short)((long)pi[n2] ^ d);
            }
        }
        for (i = 0; i < this.PK_NROWS; ++i) {
            if (this.usePadding) {
                for (k = 0; k < 9; ++k) {
                    tmp[k] = mat[i][block_idx + k];
                }
                for (k = 0; k < 8; ++k) {
                    tmp[k] = (byte)((tmp[k] & 0xFF) >> tail | tmp[k + 1] << 8 - tail);
                }
                t = Utils.load8(tmp, 0);
            } else {
                t = Utils.load8(mat[i], block_idx);
            }
            for (j = 0; j < 32; ++j) {
                d = t >> j;
                d ^= t >> (int)ctz_list[j];
                t ^= (d &= 1L) << (int)ctz_list[j];
                t ^= d << j;
            }
            if (this.usePadding) {
                Utils.store8(tmp, 0, t);
                mat[i][block_idx + 8] = (byte)((mat[i][block_idx + 8] & 0xFF) >>> tail << tail | (tmp[7] & 0xFF) >>> 8 - tail);
                mat[i][block_idx + 0] = (byte)((tmp[0] & 0xFF) << tail | (mat[i][block_idx] & 0xFF) << 8 - tail >>> 8 - tail);
                for (k = 7; k >= 1; --k) {
                    mat[i][block_idx + k] = (byte)((tmp[k] & 0xFF) << tail | (tmp[k - 1] & 0xFF) >>> 8 - tail);
                }
                continue;
            }
            Utils.store8(mat[i], block_idx, t);
        }
        return 0;
    }

    private static int ctz(long in) {
        long m1 = 0x101010101010101L;
        long r8 = 0L;
        long x = in ^ 0xFFFFFFFFFFFFFFFFL;
        for (int i = 0; i < 8; ++i) {
            r8 += (m1 &= x >>> i);
        }
        long m8 = r8 & 0x808080808080808L;
        m8 |= m8 >>> 1;
        m8 |= m8 >>> 2;
        long r = r8;
        r += (r8 >>>= 8) & m8;
        for (int i = 2; i < 8; ++i) {
            m8 &= m8 >>> 8;
            r += (r8 >>>= 8) & m8;
        }
        return (int)r & 0xFF;
    }

    private static long same_mask64(short x, short y) {
        long mask = x ^ y;
        --mask;
        mask >>>= 63;
        mask = -mask;
        return mask;
    }

    private static byte same_mask32(short x, short y) {
        int mask = x ^ y;
        --mask;
        mask >>>= 31;
        mask = -mask;
        return (byte)(mask & 0xFF);
    }

    private static void layer(short[] p, byte[] out, int ptrIndex, int s, int n) {
        int stride = 1 << s;
        int index = 0;
        for (int i = 0; i < n; i += stride * 2) {
            for (int j = 0; j < stride; ++j) {
                int d = p[i + j] ^ p[i + j + stride];
                int m = out[ptrIndex + (index >> 3)] >> (index & 7) & 1;
                m = -m;
                int n2 = i + j;
                p[n2] = (short)(p[n2] ^ (d &= m));
                int n3 = i + j + stride;
                p[n3] = (short)(p[n3] ^ d);
                ++index;
            }
        }
    }

    private static void controlbitsfrompermutation(byte[] out, short[] pi, long w, long n) {
        int diff;
        int[] temp = new int[(int)(2L * n)];
        short[] pi_test = new short[(int)n];
        do {
            int i = 0;
            while ((long)i < ((2L * w - 1L) * n / 2L + 7L) / 8L) {
                out[i] = 0;
                ++i;
            }
            CMCEEngine.cbrecursion(out, 0L, 1L, pi, 0, w, n, temp);
            i = 0;
            while ((long)i < n) {
                pi_test[i] = (short)i;
                ++i;
            }
            int ptrIndex = 0;
            i = 0;
            while ((long)i < w) {
                CMCEEngine.layer(pi_test, out, ptrIndex, i, (int)n);
                ptrIndex = (int)((long)ptrIndex + (n >> 4));
                ++i;
            }
            for (i = (int)(w - 2L); i >= 0; --i) {
                CMCEEngine.layer(pi_test, out, ptrIndex, i, (int)n);
                ptrIndex = (int)((long)ptrIndex + (n >> 4));
            }
            diff = 0;
            i = 0;
            while ((long)i < n) {
                diff = (short)(diff | pi[i] ^ pi_test[i]);
                ++i;
            }
        } while (diff != 0);
    }

    static short get_q_short(int[] temp, int q_index) {
        int temp_index = q_index / 2;
        if (q_index % 2 == 0) {
            return (short)temp[temp_index];
        }
        return (short)((temp[temp_index] & 0xFFFF0000) >> 16);
    }

    static void cbrecursion(byte[] out, long pos, long step, short[] pi, int qIndex, long w, long n, int[] temp) {
        long j;
        long i;
        long x;
        if (w == 1L) {
            int n2 = (int)(pos >> 3);
            out[n2] = (byte)(out[n2] ^ CMCEEngine.get_q_short(temp, qIndex) << (int)(pos & 7L));
            return;
        }
        if (pi != null) {
            for (x = 0L; x < n; ++x) {
                temp[(int)x] = (pi[(int)x] ^ 1) << 16 | pi[(int)(x ^ 1L)];
            }
        } else {
            for (x = 0L; x < n; ++x) {
                temp[(int)x] = (CMCEEngine.get_q_short(temp, (int)((long)qIndex + x)) ^ 1) << 16 | CMCEEngine.get_q_short(temp, (int)((long)qIndex + (x ^ 1L)));
            }
        }
        CMCEEngine.sort32(temp, 0, (int)n);
        for (x = 0L; x < n; ++x) {
            int Ax = temp[(int)x];
            int px = Ax & 0xFFFF;
            int cx = px;
            if (x < (long)cx) {
                cx = (int)x;
            }
            temp[(int)(n + x)] = px << 16 | cx;
        }
        for (x = 0L; x < n; ++x) {
            temp[(int)x] = (int)((long)(temp[(int)x] << 16) | x);
        }
        CMCEEngine.sort32(temp, 0, (int)n);
        for (x = 0L; x < n; ++x) {
            temp[(int)x] = (temp[(int)x] << 16) + (temp[(int)(n + x)] >> 16);
        }
        CMCEEngine.sort32(temp, 0, (int)n);
        if (w <= 10L) {
            for (x = 0L; x < n; ++x) {
                temp[(int)(n + x)] = (temp[(int)x] & 0xFFFF) << 10 | temp[(int)(n + x)] & 0x3FF;
            }
            for (i = 1L; i < w - 1L; ++i) {
                for (x = 0L; x < n; ++x) {
                    temp[(int)x] = (int)((long)((temp[(int)(n + x)] & 0xFFFFFC00) << 6) | x);
                }
                CMCEEngine.sort32(temp, 0, (int)n);
                for (x = 0L; x < n; ++x) {
                    temp[(int)x] = temp[(int)x] << 20 | temp[(int)(n + x)];
                }
                CMCEEngine.sort32(temp, 0, (int)n);
                for (x = 0L; x < n; ++x) {
                    int ppcpx = temp[(int)x] & 0xFFFFF;
                    int ppcx = temp[(int)x] & 0xFFC00 | temp[(int)(n + x)] & 0x3FF;
                    if (ppcpx < ppcx) {
                        ppcx = ppcpx;
                    }
                    temp[(int)(n + x)] = ppcx;
                }
            }
            for (x = 0L; x < n; ++x) {
                int n3 = (int)(n + x);
                temp[n3] = temp[n3] & 0x3FF;
            }
        } else {
            for (x = 0L; x < n; ++x) {
                temp[(int)(n + x)] = temp[(int)x] << 16 | temp[(int)(n + x)] & 0xFFFF;
            }
            for (i = 1L; i < w - 1L; ++i) {
                for (x = 0L; x < n; ++x) {
                    temp[(int)x] = (int)((long)(temp[(int)(n + x)] & 0xFFFF0000) | x);
                }
                CMCEEngine.sort32(temp, 0, (int)n);
                for (x = 0L; x < n; ++x) {
                    temp[(int)x] = temp[(int)x] << 16 | temp[(int)(n + x)] & 0xFFFF;
                }
                if (i < w - 2L) {
                    for (x = 0L; x < n; ++x) {
                        temp[(int)(n + x)] = temp[(int)x] & 0xFFFF0000 | temp[(int)(n + x)] >> 16;
                    }
                    CMCEEngine.sort32(temp, (int)n, (int)(n * 2L));
                    for (x = 0L; x < n; ++x) {
                        temp[(int)(n + x)] = temp[(int)(n + x)] << 16 | temp[(int)x] & 0xFFFF;
                    }
                }
                CMCEEngine.sort32(temp, 0, (int)n);
                for (x = 0L; x < n; ++x) {
                    int cpx = temp[(int)(n + x)] & 0xFFFF0000 | temp[(int)x] & 0xFFFF;
                    if (cpx >= temp[(int)(n + x)]) continue;
                    temp[(int)(n + x)] = cpx;
                }
            }
            for (x = 0L; x < n; ++x) {
                int n4 = (int)(n + x);
                temp[n4] = temp[n4] & 0xFFFF;
            }
        }
        if (pi != null) {
            for (x = 0L; x < n; ++x) {
                temp[(int)x] = (int)((long)(pi[(int)x] << 16) + x);
            }
        } else {
            for (x = 0L; x < n; ++x) {
                temp[(int)x] = (int)((long)(CMCEEngine.get_q_short(temp, (int)((long)qIndex + x)) << 16) + x);
            }
        }
        CMCEEngine.sort32(temp, 0, (int)n);
        for (j = 0L; j < n / 2L; ++j) {
            long _x = 2L * j;
            int fj = temp[(int)(n + _x)] & 1;
            int Fx = (int)(_x + (long)fj);
            int Fx1 = Fx ^ 1;
            int n5 = (int)(pos >> 3);
            out[n5] = (byte)(out[n5] ^ fj << (int)(pos & 7L));
            pos += step;
            temp[(int)(n + _x)] = temp[(int)_x] << 16 | Fx;
            temp[(int)(n + _x + 1L)] = temp[(int)(_x + 1L)] << 16 | Fx1;
        }
        CMCEEngine.sort32(temp, (int)n, (int)(n * 2L));
        pos += (2L * w - 3L) * step * (n / 2L);
        for (long k = 0L; k < n / 2L; ++k) {
            long y = 2L * k;
            int lk = temp[(int)(n + y)] & 1;
            int Ly = (int)(y + (long)lk);
            int Ly1 = Ly ^ 1;
            int n6 = (int)(pos >> 3);
            out[n6] = (byte)(out[n6] ^ lk << (int)(pos & 7L));
            pos += step;
            temp[(int)y] = Ly << 16 | temp[(int)(n + y)] & 0xFFFF;
            temp[(int)(y + 1L)] = Ly1 << 16 | temp[(int)(n + y + 1L)] & 0xFFFF;
        }
        CMCEEngine.sort32(temp, 0, (int)n);
        pos -= (2L * w - 2L) * step * (n / 2L);
        short[] q = new short[(int)n * 4];
        for (i = 0L; i < n * 2L; ++i) {
            q[(int)(i * 2L + 0L)] = (short)temp[(int)i];
            q[(int)(i * 2L + 1L)] = (short)((temp[(int)i] & 0xFFFF0000) >> 16);
        }
        for (j = 0L; j < n / 2L; ++j) {
            q[(int)j] = (short)((temp[(int)(2L * j)] & 0xFFFF) >>> 1);
            q[(int)(j + n / 2L)] = (short)((temp[(int)(2L * j + 1L)] & 0xFFFF) >>> 1);
        }
        for (i = 0L; i < n / 2L; ++i) {
            temp[(int)(n + n / 4L + i)] = q[(int)(i * 2L + 1L)] << 16 | q[(int)(i * 2L)];
        }
        CMCEEngine.cbrecursion(out, pos, step * 2L, null, (int)(n + n / 4L) * 2, w - 1L, n / 2L, temp);
        CMCEEngine.cbrecursion(out, pos + step, step * 2L, null, (int)((n + n / 4L) * 2L + n / 2L), w - 1L, n / 2L, temp);
    }

    private int pk_gen(byte[] pk, byte[] sk, int[] perm, short[] pi, long[] pivots) {
        block24: {
            int k;
            int j;
            int i;
            short[] g = new short[this.SYS_T + 1];
            g[this.SYS_T] = 1;
            for (i = 0; i < this.SYS_T; ++i) {
                g[i] = Utils.load_gf(sk, 40 + i * 2, this.GFMASK);
            }
            long[] buf = new long[1 << this.GFBITS];
            i = 0;
            while (i < 1 << this.GFBITS) {
                buf[i] = perm[i];
                int n = i;
                buf[n] = buf[n] << 31;
                int n2 = i;
                buf[n2] = buf[n2] | (long)i;
                int n3 = i++;
                buf[n3] = buf[n3] & Long.MAX_VALUE;
            }
            CMCEEngine.sort64(buf, 0, buf.length);
            for (i = 1; i < 1 << this.GFBITS; ++i) {
                if (buf[i - 1] >> 31 != buf[i] >> 31) continue;
                return -1;
            }
            short[] L = new short[this.SYS_N];
            for (i = 0; i < 1 << this.GFBITS; ++i) {
                pi[i] = (short)(buf[i] & (long)this.GFMASK);
            }
            for (i = 0; i < this.SYS_N; ++i) {
                L[i] = Utils.bitrev(pi[i], this.GFBITS);
            }
            short[] inv = new short[this.SYS_N];
            this.root(inv, g, L);
            for (i = 0; i < this.SYS_N; ++i) {
                inv[i] = this.gf.gf_inv(inv[i]);
            }
            byte[][] mat = new byte[this.PK_NROWS][this.SYS_N / 8];
            for (i = 0; i < this.PK_NROWS; ++i) {
                for (j = 0; j < this.SYS_N / 8; ++j) {
                    mat[i][j] = 0;
                }
            }
            for (i = 0; i < this.SYS_T; ++i) {
                for (j = 0; j < this.SYS_N; j += 8) {
                    for (k = 0; k < this.GFBITS; ++k) {
                        byte b = (byte)(inv[j + 7] >>> k & 1);
                        b = (byte)(b << 1);
                        b = (byte)(b | inv[j + 6] >>> k & 1);
                        b = (byte)(b << 1);
                        b = (byte)(b | inv[j + 5] >>> k & 1);
                        b = (byte)(b << 1);
                        b = (byte)(b | inv[j + 4] >>> k & 1);
                        b = (byte)(b << 1);
                        b = (byte)(b | inv[j + 3] >>> k & 1);
                        b = (byte)(b << 1);
                        b = (byte)(b | inv[j + 2] >>> k & 1);
                        b = (byte)(b << 1);
                        b = (byte)(b | inv[j + 1] >>> k & 1);
                        b = (byte)(b << 1);
                        mat[i * this.GFBITS + k][j / 8] = b = (byte)(b | inv[j + 0] >>> k & 1);
                    }
                }
                for (j = 0; j < this.SYS_N; ++j) {
                    inv[j] = this.gf.gf_mul(inv[j], L[j]);
                }
            }
            for (int row = 0; row < this.PK_NROWS; ++row) {
                int c;
                byte mask;
                i = row >>> 3;
                j = row & 7;
                if (this.usePivots && row == this.PK_NROWS - 32 && this.mov_columns(mat, pi, pivots) != 0) {
                    return -1;
                }
                for (k = row + 1; k < this.PK_NROWS; ++k) {
                    mask = (byte)(mat[row][i] ^ mat[k][i]);
                    mask = (byte)(mask >> j);
                    mask = (byte)(mask & 1);
                    mask = -mask;
                    for (c = 0; c < this.SYS_N / 8; ++c) {
                        byte[] byArray = mat[row];
                        int n = c;
                        byArray[n] = (byte)(byArray[n] ^ mat[k][c] & mask);
                    }
                }
                if ((mat[row][i] >> j & 1) == 0) {
                    return -1;
                }
                for (k = 0; k < this.PK_NROWS; ++k) {
                    if (k == row) continue;
                    mask = (byte)(mat[k][i] >> j);
                    mask = (byte)(mask & 1);
                    mask = -mask;
                    for (c = 0; c < this.SYS_N / 8; ++c) {
                        byte[] byArray = mat[k];
                        int n = c;
                        byArray[n] = (byte)(byArray[n] ^ mat[row][c] & mask);
                    }
                }
            }
            if (pk == null) break block24;
            if (this.usePadding) {
                int pk_index = 0;
                int tail = this.PK_NROWS % 8;
                for (i = 0; i < this.PK_NROWS; ++i) {
                    for (j = (this.PK_NROWS - 1) / 8; j < this.SYS_N / 8 - 1; ++j) {
                        pk[pk_index++] = (byte)((mat[i][j] & 0xFF) >>> tail | mat[i][j + 1] << 8 - tail);
                    }
                    pk[pk_index++] = (byte)((mat[i][j] & 0xFF) >>> tail);
                }
            } else {
                int count = (this.SYS_N - this.PK_NROWS + 7) / 8;
                for (i = 0; i < this.PK_NROWS; ++i) {
                    System.arraycopy(mat[i], this.PK_NROWS / 8, pk, count * i, count);
                }
            }
        }
        return 0;
    }

    private short eval(short[] f, short a) {
        short r = f[this.SYS_T];
        for (int i = this.SYS_T - 1; i >= 0; --i) {
            r = (short)(this.gf.gf_mul(r, a) ^ f[i]);
        }
        return r;
    }

    private void root(short[] out, short[] f, short[] L) {
        for (int i = 0; i < this.SYS_N; ++i) {
            out[i] = this.eval(f, L[i]);
        }
    }

    private int generate_irr_poly(short[] field) {
        int j;
        short[][] m = new short[this.SYS_T + 1][this.SYS_T];
        m[0][0] = 1;
        System.arraycopy(field, 0, m[1], 0, this.SYS_T);
        int[] temp = new int[this.SYS_T * 2 - 1];
        for (j = 2; j < this.SYS_T; j += 2) {
            this.gf.gf_sqr_poly(this.SYS_T, this.poly, m[j], m[j >>> 1], temp);
            this.gf.gf_mul_poly(this.SYS_T, this.poly, m[j + 1], m[j], field, temp);
        }
        if (j == this.SYS_T) {
            this.gf.gf_sqr_poly(this.SYS_T, this.poly, m[j], m[j >>> 1], temp);
        }
        for (int j2 = 0; j2 < this.SYS_T; ++j2) {
            for (int k = j2 + 1; k < this.SYS_T; ++k) {
                short mask = this.gf.gf_iszero(m[j2][j2]);
                for (int c = j2; c < this.SYS_T + 1; ++c) {
                    short[] sArray = m[c];
                    int n = j2;
                    sArray[n] = (short)(sArray[n] ^ (short)(m[c][k] & mask));
                }
            }
            if (m[j2][j2] == 0) {
                return -1;
            }
            short inv = this.gf.gf_inv(m[j2][j2]);
            for (int c = j2; c < this.SYS_T + 1; ++c) {
                m[c][j2] = this.gf.gf_mul(m[c][j2], inv);
            }
            for (int k = 0; k < this.SYS_T; ++k) {
                if (k == j2) continue;
                short t = m[j2][k];
                for (int c = j2; c <= this.SYS_T; ++c) {
                    short[] sArray = m[c];
                    int n = k;
                    sArray[n] = (short)(sArray[n] ^ this.gf.gf_mul(m[c][j2], t));
                }
            }
        }
        System.arraycopy(m[this.SYS_T], 0, field, 0, this.SYS_T);
        return 0;
    }

    int check_pk_padding(byte[] pk) {
        int b = 0;
        for (int i = 0; i < this.PK_NROWS; ++i) {
            b = (byte)(b | pk[i * this.PK_ROW_BYTES + this.PK_ROW_BYTES - 1]);
        }
        b = (byte)((b & 0xFF) >>> this.PK_NCOLS % 8);
        b = (byte)(b - 1);
        int ret = b = (int)((byte)((b & 0xFF) >>> 7));
        return ret - 1;
    }

    int check_c_padding(byte[] c) {
        byte b = (byte)((c[this.SYND_BYTES - 1] & 0xFF) >>> this.PK_NROWS % 8);
        b = (byte)(b - 1);
        byte ret = b = (byte)((b & 0xFF) >>> 7);
        return ret - 1;
    }

    public int getDefaultSessionKeySize() {
        return this.defaultKeySize;
    }

    private static void sort32(int[] temp, int from, int to) {
        int n = to - from;
        if (n < 2) {
            return;
        }
        for (int top = 1; top < n - top; top += top) {
        }
        for (int p = top; p > 0; p >>>= 1) {
            int i;
            for (i = 0; i < n - p; ++i) {
                if ((i & p) != 0) continue;
                int ab = temp[from + i + p] ^ temp[from + i];
                int c = temp[from + i + p] - temp[from + i];
                c ^= ab & (c ^ temp[from + i + p]);
                c >>= 31;
                int n2 = from + i;
                temp[n2] = temp[n2] ^ (c &= ab);
                int n3 = from + i + p;
                temp[n3] = temp[n3] ^ c;
            }
            i = 0;
            for (int q = top; q > p; q >>>= 1) {
                while (i < n - q) {
                    if ((i & p) == 0) {
                        int a = temp[from + i + p];
                        for (int r = q; r > p; r >>>= 1) {
                            int ab = temp[from + i + r] ^ a;
                            int c = temp[from + i + r] - a;
                            c ^= ab & (c ^ temp[from + i + r]);
                            c >>= 31;
                            a ^= (c &= ab);
                            int n4 = from + i + r;
                            temp[n4] = temp[n4] ^ c;
                        }
                        temp[from + i + p] = a;
                    }
                    ++i;
                }
            }
        }
    }

    private static void sort64(long[] temp, int from, int to) {
        int n = to - from;
        if (n < 2) {
            return;
        }
        for (int top = 1; top < n - top; top += top) {
        }
        for (int p = top; p > 0; p >>>= 1) {
            int i;
            for (i = 0; i < n - p; ++i) {
                if ((i & p) != 0) continue;
                long c = temp[from + i + p] - temp[from + i];
                c >>>= 63;
                c = -c;
                int n2 = from + i;
                temp[n2] = temp[n2] ^ (c &= temp[from + i] ^ temp[from + i + p]);
                int n3 = from + i + p;
                temp[n3] = temp[n3] ^ c;
            }
            i = 0;
            for (int q = top; q > p; q >>>= 1) {
                while (i < n - q) {
                    if ((i & p) == 0) {
                        long a = temp[from + i + p];
                        for (int r = q; r > p; r >>>= 1) {
                            long c = temp[from + i + r] - a;
                            c >>>= 63;
                            c = -c;
                            a ^= (c &= a ^ temp[from + i + r]);
                            int n4 = from + i + r;
                            temp[n4] = temp[n4] ^ c;
                        }
                        temp[from + i + p] = a;
                    }
                    ++i;
                }
            }
        }
    }
}

