/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.pqc.crypto.crystals.kyber;

import net.savignano.thirdparty.org.bouncycastle.crypto.EncapsulatedSecretExtractor;
import net.savignano.thirdparty.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.crystals.kyber.KyberEngine;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.crystals.kyber.KyberPrivateKeyParameters;

public class KyberKEMExtractor
implements EncapsulatedSecretExtractor {
    private KyberEngine engine;
    private KyberPrivateKeyParameters key;

    public KyberKEMExtractor(KyberPrivateKeyParameters privParams) {
        this.key = privParams;
        this.initCipher(privParams);
    }

    private void initCipher(AsymmetricKeyParameter recipientKey) {
        KyberPrivateKeyParameters key = (KyberPrivateKeyParameters)recipientKey;
        this.engine = key.getParameters().getEngine();
    }

    public byte[] extractSecret(byte[] encapsulation) {
        byte[] sharedSecret = this.engine.kemDecrypt(encapsulation, this.key.getPrivateKey());
        return sharedSecret;
    }

    public int getEncapsulationLength() {
        return this.engine.getCryptoCipherTextBytes();
    }
}

