/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.pqc.crypto.util;

import java.io.IOException;
import java.security.SecureRandom;
import net.savignano.thirdparty.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import net.savignano.thirdparty.org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import net.savignano.thirdparty.org.bouncycastle.crypto.EncapsulatedSecretExtractor;
import net.savignano.thirdparty.org.bouncycastle.crypto.EncapsulatedSecretGenerator;
import net.savignano.thirdparty.org.bouncycastle.crypto.SecretWithEncapsulation;
import net.savignano.thirdparty.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import net.savignano.thirdparty.org.bouncycastle.crypto.util.DEROtherInfo;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.KEMParameters;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.crystals.kyber.KyberKEMExtractor;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.crystals.kyber.KyberKEMGenerator;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.crystals.kyber.KyberKeyGenerationParameters;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.crystals.kyber.KyberKeyPairGenerator;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.crystals.kyber.KyberParameters;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.crystals.kyber.KyberPrivateKeyParameters;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.newhope.NHAgreement;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.ntru.NTRUKEMExtractor;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.ntru.NTRUKEMGenerator;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.ntru.NTRUKeyGenerationParameters;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.ntru.NTRUKeyPairGenerator;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.ntru.NTRUParameters;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.ntru.NTRUPrivateKeyParameters;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.util.PublicKeyFactory;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.util.SubjectPublicKeyInfoFactory;

public class PQCOtherInfoGenerator {
    protected final DEROtherInfo.Builder otherInfoBuilder;
    protected final SecureRandom random;
    protected boolean used = false;

    public PQCOtherInfoGenerator(AlgorithmIdentifier algorithmID, byte[] partyUInfo, byte[] partyVInfo, SecureRandom random) {
        this.otherInfoBuilder = new DEROtherInfo.Builder(algorithmID, partyUInfo, partyVInfo);
        this.random = random;
    }

    private static byte[] getEncoded(AsymmetricKeyParameter pubKey) {
        try {
            return SubjectPublicKeyInfoFactory.createSubjectPublicKeyInfo(pubKey).getEncoded();
        }
        catch (IOException e) {
            return null;
        }
    }

    private static AsymmetricKeyParameter getPublicKey(byte[] enc) throws IOException {
        return PublicKeyFactory.createKey(enc);
    }

    public static class PartyV
    extends PQCOtherInfoGenerator {
        private EncapsulatedSecretGenerator encSG;

        public PartyV(KEMParameters kemParams, AlgorithmIdentifier algorithmID, byte[] partyUInfo, byte[] partyVInfo, SecureRandom random) {
            super(algorithmID, partyUInfo, partyVInfo, random);
            if (kemParams instanceof KyberParameters) {
                this.encSG = new KyberKEMGenerator(random);
            } else if (kemParams instanceof NTRUParameters) {
                this.encSG = new NTRUKEMGenerator(random);
            } else {
                throw new IllegalArgumentException("unknown KEMParameters");
            }
        }

        public PQCOtherInfoGenerator withSuppPubInfo(byte[] suppPubInfo) {
            this.otherInfoBuilder.withSuppPubInfo(suppPubInfo);
            return this;
        }

        public byte[] getSuppPrivInfoPartB(byte[] suppPrivInfoPartA) {
            this.used = false;
            try {
                SecretWithEncapsulation bEp = this.encSG.generateEncapsulated(PQCOtherInfoGenerator.getPublicKey(suppPrivInfoPartA));
                this.otherInfoBuilder.withSuppPrivInfo(bEp.getSecret());
                return bEp.getEncapsulation();
            }
            catch (IOException e) {
                throw new IllegalArgumentException("cannot decode public key");
            }
        }

        public DEROtherInfo generate() {
            if (this.used) {
                throw new IllegalStateException("builder already used");
            }
            this.used = true;
            return this.otherInfoBuilder.build();
        }
    }

    public static class PartyU
    extends PQCOtherInfoGenerator {
        private AsymmetricCipherKeyPair aKp;
        private EncapsulatedSecretExtractor encSE;
        private NHAgreement agreement = new NHAgreement();

        public PartyU(KEMParameters kemParams, AlgorithmIdentifier algorithmID, byte[] partyUInfo, byte[] partyVInfo, SecureRandom random) {
            super(algorithmID, partyUInfo, partyVInfo, random);
            if (kemParams instanceof KyberParameters) {
                KyberKeyPairGenerator kPg = new KyberKeyPairGenerator();
                kPg.init(new KyberKeyGenerationParameters(random, (KyberParameters)kemParams));
                this.aKp = kPg.generateKeyPair();
                this.encSE = new KyberKEMExtractor((KyberPrivateKeyParameters)this.aKp.getPrivate());
            } else if (kemParams instanceof NTRUParameters) {
                NTRUKeyPairGenerator kPg = new NTRUKeyPairGenerator();
                kPg.init(new NTRUKeyGenerationParameters(random, (NTRUParameters)kemParams));
                this.aKp = kPg.generateKeyPair();
                this.encSE = new NTRUKEMExtractor((NTRUPrivateKeyParameters)this.aKp.getPrivate());
            } else {
                throw new IllegalArgumentException("unknown KEMParameters");
            }
        }

        public PQCOtherInfoGenerator withSuppPubInfo(byte[] suppPubInfo) {
            this.otherInfoBuilder.withSuppPubInfo(suppPubInfo);
            return this;
        }

        public byte[] getSuppPrivInfoPartA() {
            return PQCOtherInfoGenerator.getEncoded(this.aKp.getPublic());
        }

        public DEROtherInfo generate(byte[] suppPrivInfoPartB) {
            this.otherInfoBuilder.withSuppPrivInfo(this.encSE.extractSecret(suppPrivInfoPartB));
            return this.otherInfoBuilder.build();
        }
    }
}

