/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.cryptography.key.loader.smime;

import java.security.KeyStore;
import net.savignano.cryptography.enums.ECryptographyType;
import net.savignano.cryptography.enums.EKeySource;
import net.savignano.cryptography.enums.EKeyValidity;
import net.savignano.cryptography.info.InfoData;
import net.savignano.cryptography.key.loader.AKeyLoader;
import net.savignano.cryptography.key.loader.smime.SmimeCertificateKeyStoreLoader;
import net.savignano.cryptography.key.smime.SmimePublicKey;
import net.savignano.cryptography.util.SmimeUtil;
import net.savignano.thirdparty.org.bouncycastle.cert.X509CertificateHolder;
import net.savignano.thirdparty.org.bouncycastle.util.Store;

public class SmimeCertificateP7bLoader
extends AKeyLoader<SmimePublicKey, String> {
    public static final int INFO_NO_KEY_STORE = 200;
    public static final int INFO_NO_EMAIL = 201;
    public static final int INFO_EMAIL_FOUND = 202;
    public static final int INFO_EMAIL_NOT_FOUND = 203;
    private final Store<X509CertificateHolder> keyStore;

    public SmimeCertificateP7bLoader(Store<X509CertificateHolder> keyStore) {
        this.keyStore = keyStore;
    }

    @Override
    protected SmimePublicKey loadInternalKey(String email) throws Exception {
        this.getLog().info("Looking up S/MIME certificate for email <{}> in P7B store.", (Object)email);
        KeyStore convertedKeyStore = this.getKeyStore() == null ? null : SmimeUtil.convertToKeyStore(this.getKeyStore(), "BKS", null);
        SmimeCertificateKeyStoreLoader loader = new SmimeCertificateKeyStoreLoader(convertedKeyStore);
        loader.getInfoDataManager().register(d -> {
            if (d.infoType != 100) {
                this.getInfoDataManager().send((InfoData)d);
            }
        });
        return (SmimePublicKey)loader.loadKey(email);
    }

    @Override
    public EKeySource getKeySource() {
        return EKeySource.KEYSTORE;
    }

    @Override
    public ECryptographyType getCryptography() {
        return ECryptographyType.SMIME;
    }

    @Override
    protected SmimePublicKey getValidityKey(EKeyValidity validity) {
        return new SmimePublicKey(validity, this.getKeySource());
    }

    public Store<X509CertificateHolder> getKeyStore() {
        return this.keyStore;
    }
}

