/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.crypto.digests;

import net.savignano.thirdparty.org.bouncycastle.crypto.CryptoServiceProperties;
import net.savignano.thirdparty.org.bouncycastle.crypto.CryptoServicePurpose;
import net.savignano.thirdparty.org.bouncycastle.crypto.Xof;
import net.savignano.thirdparty.org.bouncycastle.crypto.digests.KeccakDigest;
import net.savignano.thirdparty.org.bouncycastle.crypto.digests.Utils;

public class SHAKEDigest
extends KeccakDigest
implements Xof {
    private static int checkBitLength(int bitStrength) {
        switch (bitStrength) {
            case 128: 
            case 256: {
                return bitStrength;
            }
        }
        throw new IllegalArgumentException("'bitStrength' " + bitStrength + " not supported for SHAKE");
    }

    public SHAKEDigest() {
        this(128);
    }

    public SHAKEDigest(CryptoServicePurpose purpose) {
        this(128, purpose);
    }

    public SHAKEDigest(int bitStrength) {
        super(SHAKEDigest.checkBitLength(bitStrength), CryptoServicePurpose.ANY);
    }

    public SHAKEDigest(int bitStrength, CryptoServicePurpose purpose) {
        super(SHAKEDigest.checkBitLength(bitStrength), purpose);
    }

    public SHAKEDigest(SHAKEDigest source) {
        super(source);
    }

    public String getAlgorithmName() {
        return "SHAKE" + this.fixedOutputLength;
    }

    public int getDigestSize() {
        return this.fixedOutputLength / 4;
    }

    public int doFinal(byte[] out, int outOff) {
        return this.doFinal(out, outOff, this.getDigestSize());
    }

    public int doFinal(byte[] out, int outOff, int outLen) {
        int length = this.doOutput(out, outOff, outLen);
        this.reset();
        return length;
    }

    public int doOutput(byte[] out, int outOff, int outLen) {
        if (!this.squeezing) {
            this.absorbBits(15, 4);
        }
        this.squeeze(out, outOff, (long)outLen * 8L);
        return outLen;
    }

    protected int doFinal(byte[] out, int outOff, byte partialByte, int partialBits) {
        return this.doFinal(out, outOff, this.getDigestSize(), partialByte, partialBits);
    }

    protected int doFinal(byte[] out, int outOff, int outLen, byte partialByte, int partialBits) {
        if (partialBits < 0 || partialBits > 7) {
            throw new IllegalArgumentException("'partialBits' must be in the range [0,7]");
        }
        int finalInput = partialByte & (1 << partialBits) - 1 | 15 << partialBits;
        int finalBits = partialBits + 4;
        if (finalBits >= 8) {
            this.absorb((byte)finalInput);
            finalBits -= 8;
            finalInput >>>= 8;
        }
        if (finalBits > 0) {
            this.absorbBits(finalInput, finalBits);
        }
        this.squeeze(out, outOff, (long)outLen * 8L);
        this.reset();
        return outLen;
    }

    protected CryptoServiceProperties cryptoServiceProperties() {
        return Utils.getDefaultProperties(this, this.purpose);
    }
}

