/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.openpgp;

import java.io.InputStream;
import net.savignano.thirdparty.org.bouncycastle.bcpg.InputStreamPacket;
import net.savignano.thirdparty.org.bouncycastle.bcpg.SymmetricKeyEncSessionPacket;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPException;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPSessionKey;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPSymmetricKeyEncryptedData;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.PBEDataDecryptorFactory;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.SessionKeyDataDecryptorFactory;
import net.savignano.thirdparty.org.bouncycastle.util.Arrays;

public class PGPPBEEncryptedData
extends PGPSymmetricKeyEncryptedData {
    SymmetricKeyEncSessionPacket keyData;

    PGPPBEEncryptedData(SymmetricKeyEncSessionPacket keyData, InputStreamPacket encData) {
        super(encData);
        this.keyData = keyData;
    }

    public int getVersion() {
        return this.keyData.getVersion();
    }

    public int getAlgorithm() {
        return this.keyData.getEncAlgorithm();
    }

    public int getSymmetricAlgorithm(PBEDataDecryptorFactory dataDecryptorFactory) throws PGPException {
        byte[] key = dataDecryptorFactory.makeKeyFromPassPhrase(this.keyData.getEncAlgorithm(), this.keyData.getS2K());
        byte[] sessionData = dataDecryptorFactory.recoverSessionData(this.keyData.getEncAlgorithm(), key, this.keyData.getSecKeyData());
        return sessionData[0];
    }

    public PGPSessionKey getSessionKey(PBEDataDecryptorFactory dataDecryptorFactory) throws PGPException {
        byte[] key = dataDecryptorFactory.makeKeyFromPassPhrase(this.keyData.getEncAlgorithm(), this.keyData.getS2K());
        byte[] sessionData = dataDecryptorFactory.recoverSessionData(this.keyData.getEncAlgorithm(), key, this.keyData.getSecKeyData());
        return new PGPSessionKey(sessionData[0] & 0xFF, Arrays.copyOfRange(sessionData, 1, sessionData.length));
    }

    public InputStream getDataStream(PBEDataDecryptorFactory dataDecryptorFactory) throws PGPException {
        try {
            PGPSessionKey sessionKey = this.getSessionKey(dataDecryptorFactory);
            this.encStream = this.createDecryptionStream(dataDecryptorFactory, sessionKey);
            return this.encStream;
        }
        catch (PGPException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PGPException("Exception creating cipher", e);
        }
    }

    public InputStream getDataStream(SessionKeyDataDecryptorFactory dataDecryptorFactory) throws PGPException {
        try {
            PGPSessionKey sessionKey = dataDecryptorFactory.getSessionKey();
            this.encStream = this.createDecryptionStream(dataDecryptorFactory, sessionKey);
            return this.encStream;
        }
        catch (PGPException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PGPException("Exception creating cipher", e);
        }
    }
}

