/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.pqc.crypto.rainbow;

import java.security.SecureRandom;
import net.savignano.thirdparty.org.bouncycastle.crypto.CipherParameters;
import net.savignano.thirdparty.org.bouncycastle.crypto.CryptoServicesRegistrar;
import net.savignano.thirdparty.org.bouncycastle.crypto.Digest;
import net.savignano.thirdparty.org.bouncycastle.crypto.params.ParametersWithRandom;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.MessageSigner;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.rainbow.ComputeInField;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.rainbow.GF2Field;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.rainbow.RainbowDRBG;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.rainbow.RainbowKeyParameters;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.rainbow.RainbowPrivateKeyParameters;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.rainbow.RainbowPublicKeyParameters;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.rainbow.RainbowPublicMap;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.rainbow.RainbowUtil;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.rainbow.Version;
import net.savignano.thirdparty.org.bouncycastle.util.Arrays;

public class RainbowSigner
implements MessageSigner {
    private static final int MAXITS = 65536;
    private SecureRandom random;
    int signableDocumentLength;
    private ComputeInField cf = new ComputeInField();
    private RainbowKeyParameters key;
    private Digest hashAlgo;
    private Version version;

    public void init(boolean forSigning, CipherParameters param) {
        if (forSigning) {
            RainbowKeyParameters tmpParam;
            if (param instanceof ParametersWithRandom) {
                ParametersWithRandom rParam = (ParametersWithRandom)param;
                this.random = rParam.getRandom();
                tmpParam = (RainbowKeyParameters)rParam.getParameters();
            } else {
                tmpParam = (RainbowKeyParameters)param;
                SecureRandom sr = CryptoServicesRegistrar.getSecureRandom();
                byte[] seed = new byte[tmpParam.getParameters().getLen_skseed()];
                sr.nextBytes(seed);
                this.random = new RainbowDRBG(seed, tmpParam.getParameters().getHash_algo());
            }
            this.version = tmpParam.getParameters().getVersion();
            this.key = tmpParam;
        } else {
            this.key = (RainbowKeyParameters)param;
            this.version = this.key.getParameters().getVersion();
        }
        this.signableDocumentLength = this.key.getDocLength();
        this.hashAlgo = this.key.getParameters().getHash_algo();
    }

    private byte[] genSignature(byte[] message) {
        short[] tmp_vec;
        short temp;
        int j;
        int k;
        int i;
        int counter;
        byte[] msgHash = new byte[this.hashAlgo.getDigestSize()];
        this.hashAlgo.update(message, 0, message.length);
        this.hashAlgo.doFinal(msgHash, 0);
        int v1 = this.key.getParameters().getV1();
        int o1 = this.key.getParameters().getO1();
        int o2 = this.key.getParameters().getO2();
        int m = this.key.getParameters().getM();
        int n = this.key.getParameters().getN();
        RainbowPrivateKeyParameters sk = (RainbowPrivateKeyParameters)this.key;
        byte[] seed = RainbowUtil.hash(this.hashAlgo, sk.sk_seed, msgHash, new byte[this.hashAlgo.getDigestSize()]);
        this.random = new RainbowDRBG(seed, sk.getParameters().getHash_algo());
        short[] vinegar = new short[v1];
        short[][] L1 = null;
        short[] r_l1_F1 = new short[o1];
        short[] r_l2_F1 = new short[o2];
        short[] r_l2_F5 = new short[o2];
        short[][] L2_F2 = new short[o2][o1];
        short[][] L2_F3 = new short[o2][o2];
        byte[] salt = new byte[sk.getParameters().getLen_salt()];
        short[] x = new short[m];
        short[] y_o1 = new short[o1];
        short[] y_o2 = null;
        for (counter = 0; L1 == null && counter < 65536; ++counter) {
            byte[] tmpRandom = new byte[v1];
            this.random.nextBytes(tmpRandom);
            for (i = 0; i < v1; ++i) {
                vinegar[i] = (short)(tmpRandom[i] & 0xFF);
            }
            L1 = new short[o1][o1];
            for (i = 0; i < v1; ++i) {
                for (k = 0; k < o1; ++k) {
                    for (j = 0; j < o1; ++j) {
                        temp = GF2Field.multElem(sk.l1_F2[k][i][j], vinegar[i]);
                        L1[k][j] = GF2Field.addElem(L1[k][j], temp);
                    }
                }
            }
            L1 = this.cf.inverse(L1);
        }
        for (int k2 = 0; k2 < o1; ++k2) {
            r_l1_F1[k2] = this.cf.multiplyMatrix_quad(sk.l1_F1[k2], vinegar);
        }
        for (i = 0; i < v1; ++i) {
            for (k = 0; k < o2; ++k) {
                r_l2_F1[k] = this.cf.multiplyMatrix_quad(sk.l2_F1[k], vinegar);
                for (j = 0; j < o1; ++j) {
                    temp = GF2Field.multElem(sk.l2_F2[k][i][j], vinegar[i]);
                    L2_F2[k][j] = GF2Field.addElem(L2_F2[k][j], temp);
                }
                for (j = 0; j < o2; ++j) {
                    temp = GF2Field.multElem(sk.l2_F3[k][i][j], vinegar[i]);
                    L2_F3[k][j] = GF2Field.addElem(L2_F3[k][j], temp);
                }
            }
        }
        byte[] mHash = new byte[m];
        while (y_o2 == null && counter < 65536) {
            short[][] L2 = new short[o2][o2];
            this.random.nextBytes(salt);
            byte[] hash = RainbowUtil.hash(this.hashAlgo, msgHash, salt, mHash);
            short[] h = this.makeMessageRepresentative(hash);
            tmp_vec = this.cf.multiplyMatrix(sk.s1, Arrays.copyOfRange(h, o1, m));
            tmp_vec = this.cf.addVect(Arrays.copyOf(h, o1), tmp_vec);
            System.arraycopy(tmp_vec, 0, x, 0, o1);
            System.arraycopy(h, o1, x, o1, o2);
            tmp_vec = this.cf.addVect(r_l1_F1, Arrays.copyOf(x, o1));
            y_o1 = this.cf.multiplyMatrix(L1, tmp_vec);
            tmp_vec = this.cf.multiplyMatrix(L2_F2, y_o1);
            for (k = 0; k < o2; ++k) {
                r_l2_F5[k] = this.cf.multiplyMatrix_quad(sk.l2_F5[k], y_o1);
            }
            tmp_vec = this.cf.addVect(tmp_vec, r_l2_F5);
            tmp_vec = this.cf.addVect(tmp_vec, r_l2_F1);
            tmp_vec = this.cf.addVect(tmp_vec, Arrays.copyOfRange(x, o1, m));
            for (int i2 = 0; i2 < o1; ++i2) {
                for (int k3 = 0; k3 < o2; ++k3) {
                    for (int j2 = 0; j2 < o2; ++j2) {
                        temp = GF2Field.multElem(sk.l2_F6[k3][i2][j2], y_o1[i2]);
                        L2[k3][j2] = GF2Field.addElem(L2[k3][j2], temp);
                    }
                }
            }
            L2 = this.cf.addMatrix(L2, L2_F3);
            y_o2 = this.cf.solveEquation(L2, tmp_vec);
            ++counter;
        }
        y_o2 = y_o2 == null ? new short[o2] : y_o2;
        tmp_vec = this.cf.multiplyMatrix(sk.t1, y_o1);
        short[] z = this.cf.addVect(vinegar, tmp_vec);
        tmp_vec = this.cf.multiplyMatrix(sk.t4, y_o2);
        z = this.cf.addVect(z, tmp_vec);
        tmp_vec = this.cf.multiplyMatrix(sk.t3, y_o2);
        tmp_vec = this.cf.addVect(y_o1, tmp_vec);
        z = Arrays.copyOf(z, n);
        System.arraycopy(tmp_vec, 0, z, v1, o1);
        System.arraycopy(y_o2, 0, z, o1 + v1, o2);
        if (counter == 65536) {
            throw new IllegalStateException("unable to generate signature - LES not solvable");
        }
        byte[] signature = RainbowUtil.convertArray(z);
        return Arrays.concatenate(signature, salt);
    }

    public byte[] generateSignature(byte[] message) {
        return this.genSignature(message);
    }

    public boolean verifySignature(byte[] message, byte[] signature) {
        short[] verificationResult;
        byte[] msgHash = new byte[this.hashAlgo.getDigestSize()];
        this.hashAlgo.update(message, 0, message.length);
        this.hashAlgo.doFinal(msgHash, 0);
        int m = this.key.getParameters().getM();
        int n = this.key.getParameters().getN();
        RainbowPublicMap p_map = new RainbowPublicMap(this.key.getParameters());
        byte[] salt = Arrays.copyOfRange(signature, n, signature.length);
        byte[] hash = RainbowUtil.hash(this.hashAlgo, msgHash, salt, new byte[m]);
        short[] h = this.makeMessageRepresentative(hash);
        byte[] sig_msg = Arrays.copyOfRange(signature, 0, n);
        short[] sig = RainbowUtil.convertArray(sig_msg);
        switch (this.version) {
            case CLASSIC: {
                RainbowPublicKeyParameters pk = (RainbowPublicKeyParameters)this.key;
                verificationResult = p_map.publicMap(pk, sig);
                break;
            }
            case CIRCUMZENITHAL: 
            case COMPRESSED: {
                RainbowPublicKeyParameters cpk = (RainbowPublicKeyParameters)this.key;
                verificationResult = p_map.publicMap_cyclic(cpk, sig);
                break;
            }
            default: {
                throw new IllegalArgumentException("No valid version. Please choose one of the following: classic, circumzenithal, compressed");
            }
        }
        return RainbowUtil.equals(h, verificationResult);
    }

    private short[] makeMessageRepresentative(byte[] message) {
        short[] output = new short[this.signableDocumentLength];
        int h = 0;
        int i = 0;
        while (i < message.length) {
            output[i] = (short)(message[h] & 0xFF);
            ++h;
            if (++i < output.length) continue;
        }
        return output;
    }
}

