/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.pqc.jcajce.provider.bike;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.PrivateKey;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Set;
import net.savignano.thirdparty.org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.bike.BIKEPrivateKeyParameters;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.util.PrivateKeyFactory;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.util.PrivateKeyInfoFactory;
import net.savignano.thirdparty.org.bouncycastle.pqc.jcajce.interfaces.BIKEKey;
import net.savignano.thirdparty.org.bouncycastle.pqc.jcajce.spec.BIKEParameterSpec;
import net.savignano.thirdparty.org.bouncycastle.util.Arrays;

public class BCBIKEPrivateKey
implements PrivateKey,
BIKEKey {
    private static final long serialVersionUID = 1L;
    private transient BIKEPrivateKeyParameters params;
    private transient ASN1Set attributes;

    public BCBIKEPrivateKey(BIKEPrivateKeyParameters params) {
        this.params = params;
    }

    public BCBIKEPrivateKey(PrivateKeyInfo keyInfo) throws IOException {
        this.init(keyInfo);
    }

    private void init(PrivateKeyInfo keyInfo) throws IOException {
        this.attributes = keyInfo.getAttributes();
        this.params = (BIKEPrivateKeyParameters)PrivateKeyFactory.createKey(keyInfo);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof BCBIKEPrivateKey) {
            BCBIKEPrivateKey otherKey = (BCBIKEPrivateKey)o;
            return Arrays.areEqual(this.params.getEncoded(), otherKey.params.getEncoded());
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.params.getEncoded());
    }

    public final String getAlgorithm() {
        return "BIKE";
    }

    public byte[] getEncoded() {
        try {
            PrivateKeyInfo pki = PrivateKeyInfoFactory.createPrivateKeyInfo(this.params, this.attributes);
            return pki.getEncoded();
        }
        catch (IOException e) {
            return null;
        }
    }

    public BIKEParameterSpec getParameterSpec() {
        return BIKEParameterSpec.fromName(this.params.getParameters().getName());
    }

    public String getFormat() {
        return "PKCS#8";
    }

    BIKEPrivateKeyParameters getKeyParams() {
        return this.params;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        byte[] enc = (byte[])in.readObject();
        this.init(PrivateKeyInfo.getInstance(enc));
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeObject(this.getEncoded());
    }
}

