/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.pqc.jcajce.provider.cmce;

import java.security.InvalidAlgorithmParameterException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.KeyGeneratorSpi;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import javax.security.auth.DestroyFailedException;
import net.savignano.thirdparty.org.bouncycastle.crypto.SecretWithEncapsulation;
import net.savignano.thirdparty.org.bouncycastle.jcajce.SecretKeyWithEncapsulation;
import net.savignano.thirdparty.org.bouncycastle.jcajce.spec.KEMExtractSpec;
import net.savignano.thirdparty.org.bouncycastle.jcajce.spec.KEMGenerateSpec;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.cmce.CMCEKEMExtractor;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.cmce.CMCEKEMGenerator;
import net.savignano.thirdparty.org.bouncycastle.pqc.jcajce.provider.cmce.BCCMCEPrivateKey;
import net.savignano.thirdparty.org.bouncycastle.pqc.jcajce.provider.cmce.BCCMCEPublicKey;
import net.savignano.thirdparty.org.bouncycastle.util.Arrays;

public class CMCEKeyGeneratorSpi
extends KeyGeneratorSpi {
    private KEMGenerateSpec genSpec;
    private SecureRandom random;
    private KEMExtractSpec extSpec;

    protected void engineInit(SecureRandom secureRandom) {
        throw new UnsupportedOperationException("Operation not supported");
    }

    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        this.random = secureRandom;
        if (algorithmParameterSpec instanceof KEMGenerateSpec) {
            this.genSpec = (KEMGenerateSpec)algorithmParameterSpec;
            this.extSpec = null;
        } else if (algorithmParameterSpec instanceof KEMExtractSpec) {
            this.genSpec = null;
            this.extSpec = (KEMExtractSpec)algorithmParameterSpec;
        } else {
            throw new InvalidAlgorithmParameterException("unknown spec");
        }
    }

    protected void engineInit(int i, SecureRandom secureRandom) {
        throw new UnsupportedOperationException("Operation not supported");
    }

    protected SecretKey engineGenerateKey() {
        if (this.genSpec != null) {
            BCCMCEPublicKey pubKey = (BCCMCEPublicKey)this.genSpec.getPublicKey();
            CMCEKEMGenerator kemGen = new CMCEKEMGenerator(this.random);
            SecretWithEncapsulation secEnc = kemGen.generateEncapsulated(pubKey.getKeyParams());
            SecretKeyWithEncapsulation rv = new SecretKeyWithEncapsulation(new SecretKeySpec(secEnc.getSecret(), this.genSpec.getKeyAlgorithmName()), secEnc.getEncapsulation());
            try {
                secEnc.destroy();
            }
            catch (DestroyFailedException e) {
                throw new IllegalStateException("key cleanup failed");
            }
            return rv;
        }
        BCCMCEPrivateKey privKey = (BCCMCEPrivateKey)this.extSpec.getPrivateKey();
        CMCEKEMExtractor kemExt = new CMCEKEMExtractor(privKey.getKeyParams());
        byte[] encapsulation = this.extSpec.getEncapsulation();
        byte[] secret = kemExt.extractSecret(encapsulation);
        SecretKeyWithEncapsulation rv = new SecretKeyWithEncapsulation(new SecretKeySpec(secret, this.extSpec.getKeyAlgorithmName()), encapsulation);
        Arrays.clear(secret);
        return rv;
    }
}

