/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.pqc.jcajce.provider.ntru;

import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.HashMap;
import java.util.Map;
import net.savignano.thirdparty.org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import net.savignano.thirdparty.org.bouncycastle.crypto.CryptoServicesRegistrar;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.ntru.NTRUKeyGenerationParameters;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.ntru.NTRUKeyPairGenerator;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.ntru.NTRUParameters;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.ntru.NTRUPrivateKeyParameters;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.ntru.NTRUPublicKeyParameters;
import net.savignano.thirdparty.org.bouncycastle.pqc.jcajce.provider.ntru.BCNTRUPrivateKey;
import net.savignano.thirdparty.org.bouncycastle.pqc.jcajce.provider.ntru.BCNTRUPublicKey;
import net.savignano.thirdparty.org.bouncycastle.pqc.jcajce.provider.util.SpecUtil;
import net.savignano.thirdparty.org.bouncycastle.pqc.jcajce.spec.NTRUParameterSpec;
import net.savignano.thirdparty.org.bouncycastle.util.Strings;

public class NTRUKeyPairGeneratorSpi
extends KeyPairGenerator {
    private static Map parameters = new HashMap();
    NTRUKeyGenerationParameters param;
    NTRUKeyPairGenerator engine = new NTRUKeyPairGenerator();
    SecureRandom random = CryptoServicesRegistrar.getSecureRandom();
    boolean initialised = false;

    public NTRUKeyPairGeneratorSpi() {
        super("NTRU");
    }

    public void initialize(int strength, SecureRandom random) {
        throw new IllegalArgumentException("use AlgorithmParameterSpec");
    }

    public void initialize(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        String name = NTRUKeyPairGeneratorSpi.getNameFromParams(params);
        if (name == null) {
            throw new InvalidAlgorithmParameterException("invalid ParameterSpec: " + params);
        }
        this.param = new NTRUKeyGenerationParameters(random, (NTRUParameters)parameters.get(name));
        this.engine.init(this.param);
        this.initialised = true;
    }

    private static String getNameFromParams(AlgorithmParameterSpec paramSpec) {
        if (paramSpec instanceof NTRUParameterSpec) {
            NTRUParameterSpec frodoParams = (NTRUParameterSpec)paramSpec;
            return frodoParams.getName();
        }
        return Strings.toLowerCase(SpecUtil.getNameFrom(paramSpec));
    }

    public KeyPair generateKeyPair() {
        if (!this.initialised) {
            this.param = new NTRUKeyGenerationParameters(this.random, NTRUParameters.ntruhps2048509);
            this.engine.init(this.param);
            this.initialised = true;
        }
        AsymmetricCipherKeyPair pair = this.engine.generateKeyPair();
        NTRUPublicKeyParameters pub = (NTRUPublicKeyParameters)pair.getPublic();
        NTRUPrivateKeyParameters priv = (NTRUPrivateKeyParameters)pair.getPrivate();
        return new KeyPair(new BCNTRUPublicKey(pub), new BCNTRUPrivateKey(priv));
    }

    static {
        parameters.put(NTRUParameterSpec.ntruhps2048509.getName(), NTRUParameters.ntruhps2048509);
        parameters.put(NTRUParameterSpec.ntruhps2048677.getName(), NTRUParameters.ntruhps2048677);
        parameters.put(NTRUParameterSpec.ntruhps4096821.getName(), NTRUParameters.ntruhps4096821);
        parameters.put(NTRUParameterSpec.ntruhrss701.getName(), NTRUParameters.ntruhrss701);
    }
}

