/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.confluence.common;

import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.user.EntityException;
import com.atlassian.user.User;
import com.atlassian.user.search.query.EmailTermQuery;
import com.atlassian.user.search.query.Query;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.mail.Address;
import net.savignano.cryptography.util.MessageUtil;
import net.savignano.snotify.atlassian.common.user.IUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfluenceUser
implements IUser<User> {
    private static final Logger log = LoggerFactory.getLogger(ConfluenceUser.class);
    private final User user;

    public static final ConfluenceUser lookupUser(Address address) {
        return ConfluenceUser.lookupUser(MessageUtil.getEmail(address));
    }

    public static final ConfluenceUser lookupUser(String email) {
        List<ConfluenceUser> users = ConfluenceUser.lookupUsers(email);
        switch (users.size()) {
            case 0: {
                log.info("No user found for email: {}", (Object)email);
                return null;
            }
            case 1: {
                return users.get(0);
            }
        }
        log.warn("Multiple users found for email {}. First user found is used, but this can be unpredictable: {}", (Object)email, users);
        return users.get(0);
    }

    public static final List<ConfluenceUser> lookupUsers(Address address) {
        return ConfluenceUser.lookupUsers(MessageUtil.getEmail(address));
    }

    public static final List<ConfluenceUser> lookupUsers(String email) {
        List users;
        if (email == null) {
            return Collections.emptyList();
        }
        UserAccessor userAccessor = (UserAccessor)ComponentLocator.getComponent(UserAccessor.class);
        try {
            users = userAccessor.findUsersAsList((Query)new EmailTermQuery(email));
        }
        catch (EntityException e) {
            log.error("Could not get users for email \"" + email + "\". Error message: " + e.getMessage(), (Throwable)e);
            return Collections.emptyList();
        }
        ArrayList<ConfluenceUser> list = new ArrayList<ConfluenceUser>();
        for (User user : users) {
            if (userAccessor.isDeactivated(user)) {
                log.info("User {} is inactive. It will not be considered for email encryption.", (Object)user);
                continue;
            }
            list.add(new ConfluenceUser(user));
        }
        log.debug("Found users for email \"{}\": {}", (Object)email, list);
        return list;
    }

    public ConfluenceUser(User user) {
        if (user == null) {
            throw new IllegalArgumentException("User must not be null.");
        }
        this.user = user;
    }

    @Override
    public String getDisplayName() {
        return this.user.getFullName();
    }

    @Override
    public String getEmail() {
        return this.user.getEmail();
    }

    @Override
    public User getActualUser() {
        return this.user;
    }

    public String toString() {
        return this.user.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.user == null ? 0 : this.user.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConfluenceUser other = (ConfluenceUser)obj;
        return !(this.user == null ? other.user != null : !this.user.equals(other.user));
    }
}

