/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.bcpg;

import java.io.IOException;
import java.math.BigInteger;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Primitive;
import net.savignano.thirdparty.org.bouncycastle.bcpg.BCPGInputStream;
import net.savignano.thirdparty.org.bouncycastle.bcpg.BCPGKey;
import net.savignano.thirdparty.org.bouncycastle.bcpg.BCPGObject;
import net.savignano.thirdparty.org.bouncycastle.bcpg.BCPGOutputStream;
import net.savignano.thirdparty.org.bouncycastle.bcpg.MPInteger;
import net.savignano.thirdparty.org.bouncycastle.math.ec.ECPoint;

public abstract class ECPublicBCPGKey
extends BCPGObject
implements BCPGKey {
    ASN1ObjectIdentifier oid;
    BigInteger point;

    protected ECPublicBCPGKey(BCPGInputStream in) throws IOException {
        this.oid = ASN1ObjectIdentifier.getInstance(ASN1Primitive.fromByteArray(ECPublicBCPGKey.readBytesOfEncodedLength(in)));
        this.point = new MPInteger(in).getValue();
    }

    protected ECPublicBCPGKey(ASN1ObjectIdentifier oid, ECPoint point) {
        this.point = new BigInteger(1, point.getEncoded(false));
        this.oid = oid;
    }

    protected ECPublicBCPGKey(ASN1ObjectIdentifier oid, BigInteger encodedPoint) {
        this.point = encodedPoint;
        this.oid = oid;
    }

    public String getFormat() {
        return "PGP";
    }

    public byte[] getEncoded() {
        try {
            return super.getEncoded();
        }
        catch (IOException e) {
            return null;
        }
    }

    public void encode(BCPGOutputStream out) throws IOException {
        byte[] oid = this.oid.getEncoded();
        out.write(oid, 1, oid.length - 1);
        MPInteger point = new MPInteger(this.point);
        out.writeObject(point);
    }

    public BigInteger getEncodedPoint() {
        return this.point;
    }

    public ASN1ObjectIdentifier getCurveOID() {
        return this.oid;
    }

    protected static byte[] readBytesOfEncodedLength(BCPGInputStream in) throws IOException {
        int length = in.read();
        if (length < 0) {
            throw new IOException("unexpected end-of-stream");
        }
        if (length == 0 || length == 255) {
            throw new IOException("future extensions not yet implemented");
        }
        if (length > 127) {
            throw new IOException("unsupported OID");
        }
        byte[] buffer = new byte[length + 2];
        in.readFully(buffer, 2, buffer.length - 2);
        buffer[0] = 6;
        buffer[1] = (byte)length;
        return buffer;
    }
}

