/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.crypto.kems;

import java.math.BigInteger;
import net.savignano.thirdparty.org.bouncycastle.crypto.CryptoServicePurpose;
import net.savignano.thirdparty.org.bouncycastle.crypto.CryptoServicesRegistrar;
import net.savignano.thirdparty.org.bouncycastle.crypto.DerivationFunction;
import net.savignano.thirdparty.org.bouncycastle.crypto.EncapsulatedSecretExtractor;
import net.savignano.thirdparty.org.bouncycastle.crypto.constraints.ConstraintUtils;
import net.savignano.thirdparty.org.bouncycastle.crypto.constraints.DefaultServiceProperties;
import net.savignano.thirdparty.org.bouncycastle.crypto.kems.ECIESKEMGenerator;
import net.savignano.thirdparty.org.bouncycastle.crypto.params.ECDomainParameters;
import net.savignano.thirdparty.org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import net.savignano.thirdparty.org.bouncycastle.math.ec.ECCurve;
import net.savignano.thirdparty.org.bouncycastle.math.ec.ECPoint;

public class ECIESKEMExtractor
implements EncapsulatedSecretExtractor {
    private final ECPrivateKeyParameters decKey;
    private int keyLen;
    private DerivationFunction kdf;
    private boolean CofactorMode;
    private boolean OldCofactorMode;
    private boolean SingleHashMode;

    public ECIESKEMExtractor(ECPrivateKeyParameters decKey, int keyLen, DerivationFunction kdf) {
        this.decKey = decKey;
        this.keyLen = keyLen;
        this.kdf = kdf;
        this.CofactorMode = false;
        this.OldCofactorMode = false;
        this.SingleHashMode = false;
    }

    public ECIESKEMExtractor(ECPrivateKeyParameters decKey, int keyLen, DerivationFunction kdf, boolean cofactorMode, boolean oldCofactorMode, boolean singleHashMode) {
        this.decKey = decKey;
        this.keyLen = keyLen;
        this.kdf = kdf;
        this.CofactorMode = cofactorMode;
        this.OldCofactorMode = cofactorMode ? false : oldCofactorMode;
        this.SingleHashMode = singleHashMode;
        CryptoServicesRegistrar.checkConstraints(new DefaultServiceProperties("ECIESKem", ConstraintUtils.bitsOfSecurityFor(this.decKey.getParameters().getCurve()), decKey, CryptoServicePurpose.DECRYPTION));
    }

    public byte[] extractSecret(byte[] encapsulation) {
        ECPrivateKeyParameters ecPrivKey = this.decKey;
        ECDomainParameters ecParams = ecPrivKey.getParameters();
        ECCurve curve = ecParams.getCurve();
        BigInteger n = ecParams.getN();
        BigInteger h = ecParams.getH();
        ECPoint gHat = curve.decodePoint(encapsulation);
        if (this.CofactorMode || this.OldCofactorMode) {
            gHat = gHat.multiply(h);
        }
        BigInteger xHat = ecPrivKey.getD();
        if (this.CofactorMode) {
            xHat = xHat.multiply(ecParams.getHInv()).mod(n);
        }
        ECPoint hTilde = gHat.multiply(xHat).normalize();
        byte[] PEH = hTilde.getAffineXCoord().getEncoded();
        return ECIESKEMGenerator.deriveKey(this.SingleHashMode, this.kdf, this.keyLen, encapsulation, PEH);
    }

    public int getEncapsulationLength() {
        return this.decKey.getParameters().getCurve().getFieldSize() / 8 * 2 + 1;
    }
}

