/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.its.bc;

import java.io.IOException;
import java.io.OutputStream;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import net.savignano.thirdparty.org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import net.savignano.thirdparty.org.bouncycastle.asn1.sec.SECObjectIdentifiers;
import net.savignano.thirdparty.org.bouncycastle.asn1.teletrust.TeleTrusTObjectIdentifiers;
import net.savignano.thirdparty.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import net.savignano.thirdparty.org.bouncycastle.crypto.Digest;
import net.savignano.thirdparty.org.bouncycastle.crypto.io.DigestOutputStream;
import net.savignano.thirdparty.org.bouncycastle.crypto.params.ECNamedDomainParameters;
import net.savignano.thirdparty.org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import net.savignano.thirdparty.org.bouncycastle.crypto.signers.DSADigestSigner;
import net.savignano.thirdparty.org.bouncycastle.crypto.signers.ECDSASigner;
import net.savignano.thirdparty.org.bouncycastle.its.ITSCertificate;
import net.savignano.thirdparty.org.bouncycastle.its.operator.ITSContentSigner;
import net.savignano.thirdparty.org.bouncycastle.operator.OperatorCreationException;
import net.savignano.thirdparty.org.bouncycastle.operator.bc.BcDefaultDigestProvider;
import net.savignano.thirdparty.org.bouncycastle.util.Arrays;

public class BcITSContentSigner
implements ITSContentSigner {
    private final ECPrivateKeyParameters privKey;
    private final ITSCertificate signerCert;
    private final AlgorithmIdentifier digestAlgo;
    private final Digest digest;
    private final byte[] parentData;
    private final ASN1ObjectIdentifier curveID;
    private final byte[] parentDigest;

    public BcITSContentSigner(ECPrivateKeyParameters privKey) {
        this(privKey, null);
    }

    public BcITSContentSigner(ECPrivateKeyParameters privKey, ITSCertificate signerCert) {
        this.privKey = privKey;
        this.curveID = ((ECNamedDomainParameters)privKey.getParameters()).getName();
        this.signerCert = signerCert;
        if (this.curveID.equals(SECObjectIdentifiers.secp256r1)) {
            this.digestAlgo = new AlgorithmIdentifier(NISTObjectIdentifiers.id_sha256);
        } else if (this.curveID.equals(TeleTrusTObjectIdentifiers.brainpoolP256r1)) {
            this.digestAlgo = new AlgorithmIdentifier(NISTObjectIdentifiers.id_sha256);
        } else if (this.curveID.equals(TeleTrusTObjectIdentifiers.brainpoolP384r1)) {
            this.digestAlgo = new AlgorithmIdentifier(NISTObjectIdentifiers.id_sha384);
        } else {
            throw new IllegalArgumentException("unknown key type");
        }
        try {
            this.digest = BcDefaultDigestProvider.INSTANCE.get(this.digestAlgo);
        }
        catch (OperatorCreationException e) {
            throw new IllegalStateException("cannot recognise digest type: " + this.digestAlgo.getAlgorithm());
        }
        if (signerCert != null) {
            try {
                this.parentData = signerCert.getEncoded();
                this.parentDigest = new byte[this.digest.getDigestSize()];
                this.digest.update(this.parentData, 0, this.parentData.length);
                this.digest.doFinal(this.parentDigest, 0);
            }
            catch (IOException e) {
                throw new IllegalStateException("signer certificate encoding failed: " + e.getMessage());
            }
        } else {
            this.parentData = null;
            this.parentDigest = new byte[this.digest.getDigestSize()];
            this.digest.doFinal(this.parentDigest, 0);
        }
    }

    public ITSCertificate getAssociatedCertificate() {
        return this.signerCert;
    }

    public byte[] getAssociatedCertificateDigest() {
        return Arrays.clone(this.parentDigest);
    }

    public AlgorithmIdentifier getDigestAlgorithm() {
        return this.digestAlgo;
    }

    public OutputStream getOutputStream() {
        return new DigestOutputStream(this.digest);
    }

    public boolean isForSelfSigning() {
        return this.parentData == null;
    }

    public ASN1ObjectIdentifier getCurveID() {
        return this.curveID;
    }

    public byte[] getSignature() {
        byte[] clientCertDigest = new byte[this.digest.getDigestSize()];
        this.digest.doFinal(clientCertDigest, 0);
        DSADigestSigner signer = new DSADigestSigner(new ECDSASigner(), this.digest);
        signer.init(true, this.privKey);
        signer.update(clientCertDigest, 0, clientCertDigest.length);
        signer.update(this.parentDigest, 0, this.parentDigest.length);
        return signer.generateSignature();
    }
}

