/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.oer.its.etsi102941;

import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Choice;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Encodable;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Object;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Primitive;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1TaggedObject;
import net.savignano.thirdparty.org.bouncycastle.asn1.DERTaggedObject;
import net.savignano.thirdparty.org.bouncycastle.oer.its.etsi102941.AaEntry;
import net.savignano.thirdparty.org.bouncycastle.oer.its.etsi102941.DcEntry;
import net.savignano.thirdparty.org.bouncycastle.oer.its.etsi102941.EaEntry;
import net.savignano.thirdparty.org.bouncycastle.oer.its.etsi102941.RootCaEntry;
import net.savignano.thirdparty.org.bouncycastle.oer.its.etsi102941.TlmEntry;

public class CtlEntry
extends ASN1Object
implements ASN1Choice {
    public static final int rca = 0;
    public static final int ea = 1;
    public static final int aa = 2;
    public static final int dc = 3;
    public static final int tlm = 4;
    private final int choice;
    private final ASN1Encodable ctlEntry;

    public CtlEntry(int choice, ASN1Encodable ctlEntry) {
        this.choice = choice;
        this.ctlEntry = ctlEntry;
    }

    private CtlEntry(ASN1TaggedObject ato) {
        this.choice = ato.getTagNo();
        switch (this.choice) {
            case 0: {
                this.ctlEntry = RootCaEntry.getInstance(ato.getObject());
                return;
            }
            case 1: {
                this.ctlEntry = EaEntry.getInstance(ato.getObject());
                return;
            }
            case 2: {
                this.ctlEntry = AaEntry.getInstance(ato.getObject());
                return;
            }
            case 3: {
                this.ctlEntry = DcEntry.getInstance(ato.getObject());
                return;
            }
            case 4: {
                this.ctlEntry = TlmEntry.getInstance(ato.getObject());
                return;
            }
        }
        throw new IllegalArgumentException("invalid choice value " + this.choice);
    }

    public static CtlEntry getInstance(Object o) {
        if (o instanceof CtlEntry) {
            return (CtlEntry)o;
        }
        if (o != null) {
            return new CtlEntry(ASN1TaggedObject.getInstance(o));
        }
        return null;
    }

    public static CtlEntry rca(RootCaEntry rca) {
        return new CtlEntry(0, rca);
    }

    public static CtlEntry ea(EaEntry ea) {
        return new CtlEntry(1, ea);
    }

    public static CtlEntry aa(AaEntry aa) {
        return new CtlEntry(2, aa);
    }

    public static CtlEntry dc(DcEntry dc) {
        return new CtlEntry(3, dc);
    }

    public static CtlEntry tlm(TlmEntry tlm) {
        return new CtlEntry(4, tlm);
    }

    public int getChoice() {
        return this.choice;
    }

    public ASN1Encodable getCtlEntry() {
        return this.ctlEntry;
    }

    public ASN1Primitive toASN1Primitive() {
        return new DERTaggedObject(this.choice, this.ctlEntry);
    }
}

