/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.oer.its.ieee1609dot2.basetypes;

import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Object;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1OctetString;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Primitive;
import net.savignano.thirdparty.org.bouncycastle.asn1.DEROctetString;
import net.savignano.thirdparty.org.bouncycastle.util.Arrays;

public class LinkageSeed
extends ASN1Object {
    private final byte[] linkageSeed;

    public LinkageSeed(byte[] linkageSeed) {
        if (linkageSeed.length != 16) {
            throw new IllegalArgumentException("linkage seed not 16 bytes");
        }
        this.linkageSeed = Arrays.clone(linkageSeed);
    }

    private LinkageSeed(ASN1OctetString value) {
        this(value.getOctets());
    }

    public static LinkageSeed getInstance(Object o) {
        if (o instanceof LinkageSeed) {
            return (LinkageSeed)o;
        }
        if (o != null) {
            return new LinkageSeed(DEROctetString.getInstance(o));
        }
        return null;
    }

    public byte[] getLinkageSeed() {
        return this.linkageSeed;
    }

    public ASN1Primitive toASN1Primitive() {
        return new DEROctetString(this.linkageSeed);
    }
}

