/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.openpgp;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.savignano.thirdparty.org.bouncycastle.bcpg.BCPGInputStream;
import net.savignano.thirdparty.org.bouncycastle.bcpg.InputStreamPacket;
import net.savignano.thirdparty.org.bouncycastle.bcpg.Packet;
import net.savignano.thirdparty.org.bouncycastle.bcpg.PublicKeyEncSessionPacket;
import net.savignano.thirdparty.org.bouncycastle.bcpg.SymmetricEncIntegrityPacket;
import net.savignano.thirdparty.org.bouncycastle.bcpg.SymmetricKeyEncSessionPacket;
import net.savignano.thirdparty.org.bouncycastle.bcpg.UnsupportedPacketVersionException;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPEncryptedData;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPPBEEncryptedData;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPPublicKeyEncryptedData;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPSessionKeyEncryptedData;
import net.savignano.thirdparty.org.bouncycastle.openpgp.Util;
import net.savignano.thirdparty.org.bouncycastle.util.Iterable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PGPEncryptedDataList
implements Iterable<PGPEncryptedData> {
    private static final Logger LOG = Logger.getLogger(PGPEncryptedDataList.class.getName());
    List<PGPEncryptedData> methods = new ArrayList<PGPEncryptedData>();
    InputStreamPacket data;

    public PGPEncryptedDataList(byte[] encData) throws IOException {
        this(Util.createBCPGInputStream(new ByteArrayInputStream(encData), 1, 3));
    }

    public PGPEncryptedDataList(InputStream inStream) throws IOException {
        this(Util.createBCPGInputStream(inStream, 1, 3));
    }

    public PGPEncryptedDataList(BCPGInputStream pIn) throws IOException {
        ArrayList<Packet> list = new ArrayList<Packet>();
        while (pIn.nextPacketTag() == 1 || pIn.nextPacketTag() == 3) {
            try {
                list.add(pIn.readPacket());
            }
            catch (UnsupportedPacketVersionException e) {
                if (!LOG.isLoggable(Level.FINE)) continue;
                LOG.fine("skipping unknown session packet: " + e.getMessage());
            }
        }
        Packet packet = pIn.readPacket();
        if (!(packet instanceof InputStreamPacket)) {
            throw new IOException("unexpected packet in stream: " + packet);
        }
        this.data = (InputStreamPacket)packet;
        for (int i = 0; i != list.size(); ++i) {
            if (list.get(i) instanceof SymmetricKeyEncSessionPacket) {
                this.methods.add(new PGPPBEEncryptedData((SymmetricKeyEncSessionPacket)list.get(i), this.data));
                continue;
            }
            this.methods.add(new PGPPublicKeyEncryptedData((PublicKeyEncSessionPacket)list.get(i), this.data));
        }
    }

    public boolean isIntegrityProtected() {
        return this.data instanceof SymmetricEncIntegrityPacket;
    }

    public PGPEncryptedData get(int index) {
        return this.methods.get(index);
    }

    public int size() {
        return this.methods.size();
    }

    public boolean isEmpty() {
        return this.methods.isEmpty();
    }

    public Iterator<PGPEncryptedData> getEncryptedDataObjects() {
        return this.methods.iterator();
    }

    @Override
    public Iterator<PGPEncryptedData> iterator() {
        return this.getEncryptedDataObjects();
    }

    public PGPSessionKeyEncryptedData extractSessionKeyEncryptedData() {
        return new PGPSessionKeyEncryptedData(this.data);
    }
}

