/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.pqc.crypto.cmce;

import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.cmce.BENES;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.cmce.Utils;

class BENES13
extends BENES {
    public BENES13(int n, int t, int m) {
        super(n, t, m);
    }

    static void layer_in(long[] data, long[] bits, int lgs) {
        int bit_ptr = 0;
        int s = 1 << lgs;
        for (int i = 0; i < 64; i += s * 2) {
            for (int j = i; j < i + s; ++j) {
                long d = data[j + 0] ^ data[j + s];
                int n = bit_ptr++;
                int n2 = j + 0;
                data[n2] = data[n2] ^ (d &= bits[n]);
                int n3 = j + s;
                data[n3] = data[n3] ^ d;
                d = data[64 + j + 0] ^ data[64 + j + s];
                int n4 = bit_ptr++;
                int n5 = 64 + j + 0;
                data[n5] = data[n5] ^ (d &= bits[n4]);
                int n6 = 64 + j + s;
                data[n6] = data[n6] ^ d;
            }
        }
    }

    static void layer_ex(long[] data, long[] bits, int lgs) {
        int bit_ptr = 0;
        int s = 1 << lgs;
        for (int i = 0; i < 128; i += s * 2) {
            for (int j = i; j < i + s; ++j) {
                long d = data[j + 0] ^ data[j + s];
                int n = bit_ptr++;
                int n2 = j + 0;
                data[n2] = data[n2] ^ (d &= bits[n]);
                int n3 = j + s;
                data[n3] = data[n3] ^ d;
            }
        }
    }

    void apply_benes(byte[] r, byte[] bits, int rev) {
        int iter;
        int i;
        int inc;
        int r_ptr = 0;
        int bits_ptr = 0;
        long[] r_int_v = new long[128];
        long[] r_int_h = new long[128];
        long[] b_int_v = new long[64];
        long[] b_int_h = new long[64];
        if (rev == 0) {
            bits_ptr = this.SYS_T * 2 + 40;
            inc = 0;
        } else {
            bits_ptr = this.SYS_T * 2 + 40 + 12288;
            inc = -1024;
        }
        for (i = 0; i < 64; ++i) {
            r_int_v[i + 0] = Utils.load8(r, r_ptr + i * 16 + 0);
            r_int_v[i + 64] = Utils.load8(r, r_ptr + i * 16 + 8);
        }
        BENES13.transpose_64x64(r_int_h, r_int_v, 0);
        BENES13.transpose_64x64(r_int_h, r_int_v, 64);
        for (iter = 0; iter <= 6; ++iter) {
            for (i = 0; i < 64; ++i) {
                b_int_v[i] = Utils.load8(bits, bits_ptr);
                bits_ptr += 8;
            }
            bits_ptr += inc;
            BENES13.transpose_64x64(b_int_h, b_int_v);
            BENES13.layer_ex(r_int_h, b_int_h, iter);
        }
        BENES13.transpose_64x64(r_int_v, r_int_h, 0);
        BENES13.transpose_64x64(r_int_v, r_int_h, 64);
        for (iter = 0; iter <= 5; ++iter) {
            for (i = 0; i < 64; ++i) {
                b_int_v[i] = Utils.load8(bits, bits_ptr);
                bits_ptr += 8;
            }
            bits_ptr += inc;
            BENES13.layer_in(r_int_v, b_int_v, iter);
        }
        for (iter = 4; iter >= 0; --iter) {
            for (i = 0; i < 64; ++i) {
                b_int_v[i] = Utils.load8(bits, bits_ptr);
                bits_ptr += 8;
            }
            bits_ptr += inc;
            BENES13.layer_in(r_int_v, b_int_v, iter);
        }
        BENES13.transpose_64x64(r_int_h, r_int_v, 0);
        BENES13.transpose_64x64(r_int_h, r_int_v, 64);
        for (iter = 6; iter >= 0; --iter) {
            for (i = 0; i < 64; ++i) {
                b_int_v[i] = Utils.load8(bits, bits_ptr);
                bits_ptr += 8;
            }
            bits_ptr += inc;
            BENES13.transpose_64x64(b_int_h, b_int_v);
            BENES13.layer_ex(r_int_h, b_int_h, iter);
        }
        BENES13.transpose_64x64(r_int_v, r_int_h, 0);
        BENES13.transpose_64x64(r_int_v, r_int_h, 64);
        for (i = 0; i < 64; ++i) {
            Utils.store8(r, r_ptr + i * 16 + 0, r_int_v[0 + i]);
            Utils.store8(r, r_ptr + i * 16 + 8, r_int_v[64 + i]);
        }
    }

    public void support_gen(short[] s, byte[] c) {
        int j;
        int i;
        byte[][] L = new byte[this.GFBITS][(1 << this.GFBITS) / 8];
        for (i = 0; i < this.GFBITS; ++i) {
            for (j = 0; j < (1 << this.GFBITS) / 8; ++j) {
                L[i][j] = 0;
            }
        }
        for (i = 0; i < 1 << this.GFBITS; ++i) {
            short a = Utils.bitrev((short)i, this.GFBITS);
            for (j = 0; j < this.GFBITS; ++j) {
                byte[] byArray = L[j];
                int n = i / 8;
                byArray[n] = (byte)(byArray[n] | (a >> j & 1) << i % 8);
            }
        }
        for (j = 0; j < this.GFBITS; ++j) {
            this.apply_benes(L[j], c, 0);
        }
        for (i = 0; i < this.SYS_N; ++i) {
            s[i] = 0;
            for (j = this.GFBITS - 1; j >= 0; --j) {
                int n = i;
                s[n] = (short)(s[n] << 1);
                int n2 = i;
                s[n2] = (short)(s[n2] | L[j][i / 8] >> i % 8 & 1);
            }
        }
    }
}

