/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.compat.struts2.servletactioncontext;

import aQute.bnd.annotation.component.Component;
import com.atlassian.confluence.api.service.exceptions.ServiceException;
import com.atlassian.confluence.compat.struts2.servletactioncontext.ServletActionContextCompat;
import com.atlassian.confluence.compat.struts2.servletactioncontext.ServletActionContextStruts2;
import com.atlassian.confluence.compat.struts2.servletactioncontext.ServletActionContextStruts6;
import com.atlassian.confluence.compat.struts2.servletactioncontext.ServletActionContextWW;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
public class ServletActionContextCompatManager
implements ServletActionContextCompat {
    private static final Logger log = LoggerFactory.getLogger(ServletActionContextCompatManager.class);
    public static final String WW_SERVLET_ACTION_CONTEXT = "com.opensymphony.webwork.ServletActionContext";
    public static final String STRUTS_SERVLET_ACTION_CONTEXT = "org.apache.struts2.ServletActionContext";
    private final java.util.function.Supplier<ServletActionContextCompat> delegate = () -> ((Supplier)Suppliers.memoize(() -> this.initialiseServletActionContextCompat(classLoader))).get();

    public ServletActionContextCompatManager() {
        this(ServletActionContextCompatManager.class.getClassLoader());
    }

    public ServletActionContextCompatManager(ClassLoader classLoader) {
    }

    private ServletActionContextCompat initialiseServletActionContextCompat(ClassLoader classLoader) {
        try {
            Class<?> strutsActionContext = Class.forName("com.opensymphony.xwork2.ActionContext", false, classLoader);
            try {
                strutsActionContext.getMethod("of", new Class[0]);
            }
            catch (NoSuchMethodException e) {
                try {
                    return new ServletActionContextStruts2(classLoader);
                }
                catch (ReflectiveOperationException ex) {
                    throw new ServiceException("Struts2 ServletActionContext couldn't be initialized.", (Throwable)ex);
                }
            }
            try {
                return new ServletActionContextStruts6(classLoader);
            }
            catch (ReflectiveOperationException ex) {
                throw new ServiceException("Struts6 ServletActionContext couldn't be initialized.", (Throwable)ex);
            }
        }
        catch (ClassNotFoundException e) {
            try {
                return new ServletActionContextWW(classLoader);
            }
            catch (ReflectiveOperationException ex) {
                throw new ServiceException("WebWork ServletActionContext couldn't be initialized.", (Throwable)ex);
            }
        }
    }

    @VisibleForTesting
    String getDelegateClassName() {
        return this.delegate.get().getClass().getName();
    }

    @Override
    public void setRequest(HttpServletRequest request) {
        try {
            this.delegate.get().setRequest(request);
        }
        catch (NullPointerException ex) {
            log.error("Couldn't set the request");
        }
    }

    @Override
    public HttpServletRequest getRequest() {
        try {
            return this.delegate.get().getRequest();
        }
        catch (NullPointerException ex) {
            log.error("Couldn't get the request");
            return null;
        }
    }

    @Override
    public void setResponse(HttpServletResponse response) {
        try {
            this.delegate.get().setResponse(response);
        }
        catch (NullPointerException ex) {
            log.error("Couldn't set the response");
        }
    }

    @Override
    public HttpServletResponse getResponse() {
        try {
            return this.delegate.get().getResponse();
        }
        catch (NullPointerException ex) {
            log.error("Couldn't get the response");
            return null;
        }
    }

    @Override
    public void setServletConfig(ServletConfig config) {
        try {
            this.delegate.get().setServletConfig(config);
        }
        catch (NullPointerException ex) {
            log.error("Couldn't set the ServletConfig");
        }
    }

    @Override
    public ServletContext getServletContext() {
        try {
            return this.delegate.get().getServletContext();
        }
        catch (NullPointerException ex) {
            log.error("Couldn't get the ServletContext");
            return null;
        }
    }
}

