/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.compat.struts2.servletactioncontext;

import com.atlassian.confluence.api.service.exceptions.ServiceException;
import com.atlassian.confluence.compat.struts2.servletactioncontext.ServletActionContextCompat;
import java.lang.reflect.Method;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

class ServletActionContextWW
implements ServletActionContextCompat {
    private final Class<?> servletActionContextClass;
    private final Method setRequest;
    private final Method getRequest;
    private final Method setResponse;
    private final Method getResponse;
    private final Method getServletConfig;
    private final Method setServletConfig;

    ServletActionContextWW(ClassLoader classLoader) throws ReflectiveOperationException {
        this.servletActionContextClass = Class.forName("com.opensymphony.webwork.ServletActionContext", false, classLoader);
        this.setRequest = this.getSACMethod("setRequest", HttpServletRequest.class);
        this.getRequest = this.getSACMethod("getRequest", new Class[0]);
        this.setResponse = this.getSACMethod("setResponse", HttpServletResponse.class);
        this.getResponse = this.getSACMethod("getResponse", new Class[0]);
        this.getServletConfig = this.getSACMethod("getServletConfig", new Class[0]);
        this.setServletConfig = this.getSACMethod("setServletConfig", ServletConfig.class);
    }

    @Override
    public void setRequest(HttpServletRequest request) {
        try {
            this.setRequest.invoke(null, request);
        }
        catch (ReflectiveOperationException e) {
            throw new ServiceException("Couldn't set ServletActionContext request", (Throwable)e);
        }
    }

    @Override
    public HttpServletRequest getRequest() {
        try {
            return (HttpServletRequest)this.getRequest.invoke(null, new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new ServiceException("Couldn't get ServletActionContext request", (Throwable)e);
        }
    }

    @Override
    public void setResponse(HttpServletResponse response) {
        try {
            this.setResponse.invoke(null, response);
        }
        catch (ReflectiveOperationException e) {
            throw new ServiceException("Couldn't set ServletActionContext response", (Throwable)e);
        }
    }

    @Override
    public HttpServletResponse getResponse() {
        try {
            return (HttpServletResponse)this.getResponse.invoke(null, new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new ServiceException("Couldn't get ServletActionContext response", (Throwable)e);
        }
    }

    @Override
    public void setServletConfig(ServletConfig config) {
        try {
            this.setServletConfig.invoke(null, config);
        }
        catch (ReflectiveOperationException e) {
            throw new ServiceException("Couldn't set ServletConfig", (Throwable)e);
        }
    }

    @Override
    public ServletContext getServletContext() {
        try {
            ServletConfig config = (ServletConfig)this.getServletConfig.invoke(null, new Object[0]);
            return config != null ? config.getServletContext() : null;
        }
        catch (ReflectiveOperationException e) {
            throw new ServiceException("Couldn't get ServletContext", (Throwable)e);
        }
    }

    private Method getSACMethod(String methodName, Class<?> ... parameterTypes) throws ReflectiveOperationException {
        return this.servletActionContextClass.getMethod(methodName, parameterTypes);
    }
}

