/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.cryptography.key.loader.pgp;

import net.savignano.cryptography.enums.ECryptographyType;
import net.savignano.cryptography.enums.EKeyValidity;
import net.savignano.cryptography.key.loader.AKeyBoxLoader;
import net.savignano.cryptography.key.pgp.PgpEncryptionKey;
import net.savignano.cryptography.util.PgpUtil;
import net.savignano.thirdparty.org.bouncycastle.gpg.keybox.BlobType;
import net.savignano.thirdparty.org.bouncycastle.gpg.keybox.KeyBox;
import net.savignano.thirdparty.org.bouncycastle.gpg.keybox.PublicKeyRingBlob;

public class PgpKeyBoxLoader
extends AKeyBoxLoader<PgpEncryptionKey, PublicKeyRingBlob> {
    public PgpKeyBoxLoader(KeyBox keyBox) {
        super(keyBox, BlobType.OPEN_PGP_BLOB);
    }

    @Override
    public ECryptographyType getCryptography() {
        return ECryptographyType.PGP;
    }

    @Override
    protected PgpEncryptionKey loadKeyFromBlob(PublicKeyRingBlob blob) throws Exception {
        PgpEncryptionKey key = new PgpEncryptionKey(blob.getPGPPublicKeyRing());
        key.setKeySource(this.getKeySource());
        return key;
    }

    @Override
    protected boolean isKeyForEmail(PgpEncryptionKey key, String email) {
        return PgpUtil.isKeyForEmail(key.getMasterKey(), email);
    }

    @Override
    protected PgpEncryptionKey getValidityKey(EKeyValidity validity) {
        return new PgpEncryptionKey(validity, this.getKeySource());
    }

    @Override
    public int compare(PgpEncryptionKey o1, PgpEncryptionKey o2) {
        int compared = super.compare(o1, o2);
        if (compared != 0) {
            return compared;
        }
        return PgpUtil.getKeyRingComparator().compare(o1.getKeyRing(), o2.getKeyRing());
    }
}

