/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.cryptography.mail.sign;

import java.io.IOException;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import net.savignano.cryptography.enums.ECryptographyType;
import net.savignano.cryptography.key.ISecretCryptographyKey;
import net.savignano.cryptography.mail.BaseCryptographyResult;
import net.savignano.cryptography.mail.BaseMailCryptography;
import net.savignano.cryptography.mail.sign.IMailSigner;
import net.savignano.cryptography.util.MessageUtil;
import org.slf4j.Logger;

public abstract class AMailSigner<T extends ISecretCryptographyKey<?>, R extends BaseCryptographyResult>
extends BaseMailCryptography
implements IMailSigner<T, R> {
    private static final String MAIL_HEADER_SIGNED_PATTERN = "by {0} using {3} signature";
    private static final String MAIL_HEADER_SIGNED_DEBUG_PATTERN = "by {0} {1} at {2} using {3} signature with {4}";

    protected AMailSigner(Session session, ECryptographyType cryptography) {
        super(session, cryptography);
    }

    @Override
    public void signMessage(MimeMessage msg, T key) throws IOException, MessagingException {
        R result = this.sign(msg, key);
        if (((BaseCryptographyResult)result).getException() != null) {
            String errMsg = "Could not sign message with msg ID \"" + MessageUtil.getMessageId((Message)((BaseCryptographyResult)result).getMessage()) + "\". Error message: " + ((BaseCryptographyResult)result).getException().getMessage();
            throw new MessagingException(errMsg, ((BaseCryptographyResult)result).getException());
        }
    }

    @Override
    public R sign(MimeMessage msg, T key) {
        R result = this.createResult(msg);
        if (msg == null) {
            ((BaseCryptographyResult)result).setException(new IllegalArgumentException("Cannot sign message because no message was provided."));
            return result;
        }
        if (key == null) {
            ((BaseCryptographyResult)result).setException(new IllegalArgumentException("Cannot sign message because no key was provided."));
            return result;
        }
        if (!key.isValid()) {
            ((BaseCryptographyResult)result).setException(new IllegalArgumentException("Cannot sign message because of key having validity: " + (Object)((Object)key.getKeyValidity())));
            return result;
        }
        Logger log = this.getLog();
        String msgId = MessageUtil.getMessageId((Message)msg);
        log.info("Signing message with ID \"{}\" with {}.", (Object)msgId, (Object)this.getCryptography());
        this.traceMessage(msg, "Original email:\n{}");
        try {
            this.sign(key, result);
            msg.setHeader("Message-ID", msgId);
        }
        catch (Exception e) {
            ((BaseCryptographyResult)result).setException(e);
        }
        this.getLog().info("Signing result for message with ID \"{}\": {}", (Object)msgId, result);
        this.traceMessage(msg, "Final email:\n{}");
        return result;
    }

    protected abstract R createResult(MimeMessage var1);

    protected abstract void sign(T var1, R var2) throws Exception;

    protected void includeSignatureHeader(MimeMessage msg, String signatureAlgorithm) throws MessagingException {
        String headerPattern = this.isVerboseHeader() ? MAIL_HEADER_SIGNED_DEBUG_PATTERN : MAIL_HEADER_SIGNED_PATTERN;
        this.includeCryptographyHeader(msg, "X-Signed", headerPattern, new Object[]{this.getCryptography(), signatureAlgorithm});
    }

    protected boolean isVerboseHeader() {
        return this.getLog().isDebugEnabled();
    }
}

