/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.atlassian.common.properties;

import net.savignano.cryptography.Constants;
import net.savignano.snotify.atlassian.common.EProperty;
import net.savignano.snotify.atlassian.common.properties.ISnotifyProjectProperties;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ASnotifyProjectProperties
implements ISnotifyProjectProperties {
    private static final Logger log = LoggerFactory.getLogger(ASnotifyProjectProperties.class);
    private static final String SETTINGS_STRING_EXISTS = ".exists";
    private static final String SETTINGS_STRING_PAGES = ".pages";
    private static final String SETTINGS_STRING_PAGE = ".page.";

    @Override
    public boolean hasKey(EProperty prop, String projectKey) {
        if (prop == null) {
            log.error("Given property was null.", (Throwable)new NullPointerException());
            return false;
        }
        if (prop.getPropType() != EProperty.EPropertyType.PROJECT) {
            log.warn("Given property {} is of type {}, but {} is expected. Probably wrong property given.", new Object[]{prop.name(), prop.getPropType(), EProperty.EPropertyType.PROJECT});
        }
        if (this.getString(prop.getKey(), projectKey) != null) {
            return true;
        }
        Boolean exists = this.getBoolean(prop.getKey() + SETTINGS_STRING_EXISTS, projectKey);
        return exists != null && exists != false;
    }

    @Override
    public final String getString(EProperty prop, String projectKey) {
        if (this.checkType(String.class, prop)) {
            String value = this.getString(prop.getKey(), projectKey);
            return value != null ? value : (String)prop.getDefaultValue();
        }
        return null;
    }

    public final String getAsString(EProperty prop, String projectKey) {
        if (prop == null) {
            log.error("Given property was null.");
            return null;
        }
        return this.getString(prop.getKey(), projectKey);
    }

    protected abstract String getString(String var1, String var2);

    @Override
    public final String getUnlimitedString(EProperty prop, String projectKey) {
        if (this.checkType(String.class, prop)) {
            String value = this.getUnlimitedString(prop.getKey(), projectKey);
            return value != null ? value : (String)prop.getDefaultValue();
        }
        return null;
    }

    protected String getUnlimitedString(String key, String projectKey) {
        if (!this.getBoolean(key + SETTINGS_STRING_EXISTS, projectKey).booleanValue()) {
            return null;
        }
        Long pagesValue = this.getLong(key + SETTINGS_STRING_PAGES, projectKey);
        if (pagesValue == null) {
            return null;
        }
        int pages = pagesValue.intValue();
        StringBuilder builder = new StringBuilder(255 * pages);
        for (int i = 0; i < pages; ++i) {
            String page = this.getString(key + SETTINGS_STRING_PAGE + i, projectKey);
            builder.append(page);
        }
        String value = builder.toString();
        if (StringUtils.isBlank((CharSequence)value)) {
            return null;
        }
        return value;
    }

    @Override
    public final boolean getBoolean(EProperty prop, String projectKey) {
        if (this.checkType(Boolean.class, prop)) {
            Boolean value = this.getBoolean(prop.getKey(), projectKey);
            return value != null ? value : (Boolean)prop.getDefaultValue();
        }
        return false;
    }

    @Override
    public final boolean getBoolean(EProperty prop, boolean defaultValue, String projectKey) {
        if (this.checkType(Boolean.class, prop)) {
            Boolean value = this.getBoolean(prop.getKey(), projectKey);
            return value != null ? value : defaultValue;
        }
        return false;
    }

    protected Boolean getBoolean(String key, String projectKey) {
        String value = this.getString(key, projectKey);
        if (value == null) {
            return null;
        }
        return Boolean.valueOf(value);
    }

    @Override
    public final Long getLong(EProperty prop, String projectKey) {
        if (this.checkType(Long.class, prop)) {
            Long value = this.getLong(prop.getKey(), projectKey);
            return value != null ? value : (Long)prop.getDefaultValue();
        }
        return null;
    }

    protected Long getLong(String key, String projectKey) {
        String value = this.getString(key, projectKey);
        if (value != null) {
            try {
                return Long.valueOf(value);
            }
            catch (NumberFormatException e) {
                log.error("Value " + value + " stored in projectKey property " + key + " for projectKey " + projectKey + " is not a Long.", (Throwable)e);
            }
        }
        return null;
    }

    @Override
    public final <T extends Enum<T>> T getEnum(EProperty prop, Class<T> clazz, String projectKey) {
        if (this.checkType(clazz, prop)) {
            T value = this.getEnum(prop.getKey(), clazz, projectKey);
            return (T)(value != null ? value : (Enum)prop.getDefaultValue());
        }
        return null;
    }

    protected <T extends Enum<T>> T getEnum(String key, Class<T> clazz, String projectKey) {
        String value = this.getString(key, projectKey);
        if (value != null) {
            try {
                return Enum.valueOf(clazz, value);
            }
            catch (IllegalArgumentException e) {
                log.error("Value " + value + " stored in application property " + key + " for projectKey " + projectKey + " is not a valid value for enum " + clazz.getSimpleName() + ".", (Throwable)e);
            }
        }
        return null;
    }

    @Override
    public final byte[] getBytes(EProperty prop, String projectKey) {
        if (this.checkType(byte[].class, prop)) {
            byte[] value = this.getBytes(prop.getKey(), projectKey);
            return value != null ? value : (byte[])prop.getDefaultValue();
        }
        return null;
    }

    protected byte[] getBytes(String key, String projectKey) {
        String base64Value = this.getUnlimitedString(key, projectKey);
        if (base64Value != null) {
            return Base64.decodeBase64((byte[])base64Value.getBytes(Constants.UTF8_CHARSET));
        }
        return null;
    }

    @Override
    public final void setString(EProperty prop, String value, String projectKey) {
        if (this.checkType(String.class, prop)) {
            this.setString(prop.getKey(), value, projectKey);
        }
    }

    public final void setAsString(EProperty prop, String value, String projectKey) {
        if (prop == null) {
            log.error("Given property was null.", (Throwable)new NullPointerException());
            return;
        }
        this.setString(prop.getKey(), value, projectKey);
    }

    protected abstract void setString(String var1, String var2, String var3);

    @Override
    public final void setUnlimitedString(EProperty prop, String value, String projectKey) {
        if (this.checkType(String.class, prop)) {
            this.setUnlimitedString(prop.getKey(), value, projectKey);
        }
    }

    protected void setUnlimitedString(String key, String value, String projectKey) {
        this.removeUnlimitedString(key, projectKey);
        if (value != null) {
            int pages = value.length() / 255 + (value.length() % 255 == 0 ? 0 : 1);
            if (pages > 0) {
                for (int i = 0; i < pages - 1; ++i) {
                    this.setString(key + SETTINGS_STRING_PAGE + i, value.substring(i * 255, (i + 1) * 255), projectKey);
                }
                this.setString(key + SETTINGS_STRING_PAGE + (pages - 1), value.substring((pages - 1) * 255), projectKey);
            }
            this.setLong(key + SETTINGS_STRING_PAGES, Long.valueOf(pages), projectKey);
            this.setBoolean(key + SETTINGS_STRING_EXISTS, true, projectKey);
        }
    }

    private void removeUnlimitedString(String key, String projectKey) {
        Boolean exists = this.getBoolean(key + SETTINGS_STRING_EXISTS, projectKey);
        if (exists == null || !exists.booleanValue()) {
            return;
        }
        Long pagesValue = this.getLong(key + SETTINGS_STRING_PAGES, projectKey);
        if (pagesValue == null) {
            return;
        }
        this.setString(key + SETTINGS_STRING_EXISTS, null, projectKey);
        this.setLong(key + SETTINGS_STRING_PAGES, null, projectKey);
        int pages = pagesValue.intValue();
        for (int i = 0; i < pages; ++i) {
            this.setString(key + SETTINGS_STRING_PAGE + i, null, projectKey);
        }
    }

    @Override
    public final void setBoolean(EProperty prop, boolean value, String projectKey) {
        if (this.checkType(Boolean.class, prop)) {
            this.setBoolean(prop.getKey(), value, projectKey);
        }
    }

    protected void setBoolean(String key, boolean value, String projectKey) {
        this.setString(key, String.valueOf(value), projectKey);
    }

    @Override
    public final void setLong(EProperty prop, Long value, String projectKey) {
        if (this.checkType(Long.class, prop)) {
            this.setLong(prop.getKey(), value, projectKey);
        }
    }

    protected void setLong(String key, Long value, String projectKey) {
        this.setString(key, value == null ? null : value.toString(), projectKey);
    }

    @Override
    public final void setEnum(EProperty prop, Enum<?> value, String projectKey) {
        if (value == null) {
            if (prop == null) {
                log.error("Given property was null.", (Throwable)new NullPointerException());
            } else if (!prop.getType().isEnum()) {
                log.error("Property {} is not an enum.", (Object)prop.name());
            } else {
                this.setEnum(prop.getKey(), null, projectKey);
            }
        } else if (this.checkType(value.getClass(), prop)) {
            this.setEnum(prop.getKey(), value, projectKey);
        }
    }

    protected void setEnum(String key, Enum<?> value, String projectKey) {
        this.setString(key, value == null ? null : value.name(), projectKey);
    }

    @Override
    public final void setBytes(EProperty prop, byte[] value, String projectKey) {
        if (this.checkType(byte[].class, prop)) {
            this.setBytes(prop.getKey(), value, projectKey);
        }
    }

    protected void setBytes(String key, byte[] value, String projectKey) {
        String encoded = value == null ? null : new String(Base64.encodeBase64((byte[])value), Constants.UTF8_CHARSET);
        this.setUnlimitedString(key, encoded, projectKey);
    }

    private boolean checkType(Class<?> exptected, EProperty actual) {
        if (exptected == null) {
            log.error("Expected class was null.", (Throwable)new NullPointerException());
            return false;
        }
        if (actual == null) {
            log.error("Given property was null.", (Throwable)new NullPointerException());
            return false;
        }
        if (actual.getPropType() != EProperty.EPropertyType.PROJECT) {
            log.warn("Given property {} is of type {}, but {} is expected. Probably wrong property given.", new Object[]{actual.name(), actual.getPropType(), EProperty.EPropertyType.PROJECT});
        }
        if (exptected == actual.getType()) {
            return true;
        }
        log.error("Property {} is not of type: {}", (Object)actual.name(), (Object)exptected.getSimpleName());
        return false;
    }
}

