/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.atlassian.gui;

import com.atlassian.mail.Email;
import com.atlassian.mail.MailException;
import com.atlassian.mail.server.SMTPMailServer;
import java.util.Arrays;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import net.savignano.snotify.atlassian.common.properties.ISnotifyAppProperties;
import net.savignano.snotify.atlassian.gui.AMailerVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtlassianMailerVersion
extends AMailerVersion {
    private static final Logger log = LoggerFactory.getLogger(AtlassianMailerVersion.class);
    private final SMTPMailServer server;

    public AtlassianMailerVersion(SMTPMailServer server, ISnotifyAppProperties appProps) {
        super(appProps);
        this.server = server;
        if (server == null) {
            throw new IllegalArgumentException("Server must not be null.");
        }
    }

    @Override
    protected void sendInternalMail() {
        try {
            Email email = this.createEmail();
            log.debug("Sending internal email to check S/Notify mailer library version. Email: {}", (Object)email);
            this.server.send(email);
        }
        catch (MailException e) {
            log.error("Could not send internal email to check S/Notify mailer library version. Error message: " + e.getMessage(), (Throwable)e);
        }
    }

    private Email createEmail() throws MailException {
        String address = this.getAddress();
        Email email = new Email(address);
        email.setSubject("S/Notify test email");
        email.setFrom(address);
        email.setBody(this.createHtmlContent());
        email.setMimeType("text/html");
        email.addHeader("X-Do-Not-Send", Boolean.TRUE.toString());
        return email;
    }

    private String getAddress() throws MailException {
        Object[] addresses;
        String address = this.server.getDefaultFrom();
        if (address == null) {
            throw new MailException("No 'form' address configured for SMPT server.");
        }
        try {
            addresses = InternetAddress.parse((String)address);
        }
        catch (AddressException e) {
            throw new MailException("Could not parse email address \"" + address + ". Error message: " + e.getMessage(), (Throwable)e);
        }
        if (addresses == null || addresses.length == 0) {
            throw new MailException("Parsing failed for email address \"" + address + "\". No address available.");
        }
        if (addresses.length > 1) {
            log.warn("'From' address of configured SMTP server contains multiple addresses. Only first address will be used. Found addresses: {}", (Object)Arrays.toString(addresses));
        }
        return addresses[0].getAddress();
    }
}

