/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.atlassian.gui;

import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.atlassian.upm.api.util.Option;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.function.Supplier;
import net.savignano.snotify.atlassian.common.EProperty;
import net.savignano.snotify.atlassian.common.properties.ASnotifyAppProperties;
import net.savignano.snotify.atlassian.common.properties.ISnotifyAppProperties;
import org.apache.commons.io.output.StringBuilderWriter;
import org.apache.commons.lang3.StringUtils;

public class SupportBuilder {
    private final StringBuilder builder = new StringBuilder();
    private ISnotifyAppProperties appProps;
    private Supplier<String> platformSupplier;
    private PluginLicenseManager licenseManager;

    public static final SupportBuilder create() {
        return new SupportBuilder();
    }

    public SupportBuilder includeProperties(ISnotifyAppProperties appProps) {
        this.appProps = appProps;
        return this;
    }

    public SupportBuilder includePlatform(Supplier<String> platformSupplier) {
        this.platformSupplier = platformSupplier;
        return this;
    }

    public SupportBuilder includeLicenseId(PluginLicenseManager licenseManager) {
        this.licenseManager = licenseManager;
        return this;
    }

    public String build() {
        this.builder.setLength(0);
        this.exceptionSafe(this::doIncludePlatform);
        this.exceptionSafe(this::doIncludeLicenseId);
        this.exceptionSafe(this::doIncludeProperties);
        return this.builder.toString();
    }

    private void doIncludeProperties() {
        if (this.appProps == null) {
            return;
        }
        for (EProperty prop : EProperty.values()) {
            if (prop.getPropType() != EProperty.EPropertyType.GLOBAL) continue;
            this.addProperty(prop);
        }
    }

    private void addProperty(EProperty prop) {
        String value = ((ASnotifyAppProperties)this.appProps).getAsString(prop);
        this.builder.append(prop.name());
        this.builder.append(": ");
        if (value != null && this.isPasswordProperty(prop)) {
            this.builder.append("*****");
        } else {
            this.builder.append('\"');
            this.builder.append(value);
            this.builder.append('\"');
        }
        this.builder.append('\n');
    }

    private boolean isPasswordProperty(EProperty prop) {
        return StringUtils.containsIgnoreCase((CharSequence)prop.name(), (CharSequence)"password") && char[].class.equals(prop.getType());
    }

    private void doIncludePlatform() {
        if (this.platformSupplier == null) {
            return;
        }
        String value = this.platformSupplier.get();
        this.builder.append("Platform: ");
        this.builder.append(value);
        this.builder.append('\n');
    }

    private void doIncludeLicenseId() {
        if (this.licenseManager == null) {
            return;
        }
        this.addInstalledPlugin();
        this.addLicenseId();
    }

    private void addInstalledPlugin() {
        String value = this.licenseManager.getPluginKey();
        this.builder.append("Plugin Key: ");
        this.builder.append(value);
        this.builder.append('\n');
    }

    private void addLicenseId() {
        Option option = this.licenseManager.getLicense();
        this.builder.append("License ID: ");
        if (option.isDefined()) {
            PluginLicense license = (PluginLicense)option.get();
            String licenseStr = license.toString();
            String rawLicense = license.getRawLicense();
            if (rawLicense.length() > 16) {
                String shortenedLicense = rawLicense.substring(0, 8) + "[...]" + rawLicense.substring(rawLicense.length() - 8);
                licenseStr = licenseStr.replace(rawLicense, shortenedLicense);
            }
            this.builder.append(licenseStr);
        } else {
            this.builder.append("No License applied.");
        }
        this.builder.append('\n');
    }

    private void exceptionSafe(Runnable runnable) {
        try {
            runnable.run();
        }
        catch (Exception e) {
            try (PrintWriter writer = new PrintWriter((Writer)new StringBuilderWriter(this.builder));){
                e.printStackTrace(writer);
            }
        }
    }
}

