/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.atlassian.gui.keysource.verification.smime;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.UnrecoverableKeyException;
import java.security.cert.X509Certificate;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import net.savignano.cryptography.key.smime.SmimeEncryptionKey;
import net.savignano.cryptography.key.smime.SmimeSignKey;
import net.savignano.cryptography.util.KeyStoreContentFetcher;
import net.savignano.cryptography.util.SecurityUtil;
import net.savignano.cryptography.util.SmimeUtil;
import net.savignano.snotify.atlassian.common.ISnotifyI18n;
import net.savignano.snotify.atlassian.gui.keysource.verification.AKeySourceVerification;
import net.savignano.snotify.atlassian.gui.keysource.verification.EVerificationStatusType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmimeKeyStoreVerification
extends AKeySourceVerification {
    private static final Logger log = LoggerFactory.getLogger(SmimeKeyStoreVerification.class);
    private static final String CRYPTOGRAPHY_SUPPORT_ERROR = "JCE cannot authenticate the provider SAVIGNANO-BC";
    private final String keyStoreType;
    private final String location;
    private final Set<String> emails = new LinkedHashSet<String>();
    private char[] keyStorePassword;
    private char[] keyPassword;
    private boolean enablePrivateKeyCheck;

    public SmimeKeyStoreVerification(String location, String keyStoreType, ISnotifyI18n i18n) {
        super(i18n);
        if (location == null) {
            throw new IllegalArgumentException("Location must not be null.");
        }
        if (keyStoreType == null) {
            throw new IllegalArgumentException("Key Store Type must not be null.");
        }
        this.location = location;
        this.keyStoreType = keyStoreType;
    }

    @Override
    protected void doVerify() throws Exception {
        if (this.isEnablePrivateKeyCheck()) {
            this.getBuilder().title("net.savignano.snotify.key-management.verification.smime.private-keystore.title", new Object[0]);
        } else {
            this.getBuilder().title("net.savignano.snotify.key-management.verification.smime.public-keystore.title", new Object[0]);
        }
        this.canReadLocation();
    }

    private void canReadLocation() {
        SecurityException e = null;
        boolean canRead = false;
        try {
            canRead = new File(this.location).canRead();
            log.debug("Can access key store at location {}: {}", (Object)this.location, (Object)canRead);
        }
        catch (SecurityException e1) {
            e = e1;
            log.debug("Cannot access key store location: " + this.location, (Throwable)e);
        }
        if (canRead) {
            this.getBuilder().status(EVerificationStatusType.SUCCESS);
            this.getBuilder().subTitle("net.savignano.snotify.key-management.verification.smime.keystore.canRead.success.title", new Object[0]);
            this.getBuilder().message("net.savignano.snotify.key-management.verification.smime.keystore.canRead.success.message", this.location);
            this.build();
            this.loadKeyStore();
        } else if (e != null) {
            this.getBuilder().status(EVerificationStatusType.ERROR);
            this.getBuilder().subTitle("net.savignano.snotify.key-management.verification.smime.keystore.canRead.exception.title", new Object[0]);
            this.getBuilder().message("net.savignano.snotify.key-management.verification.smime.keystore.canRead.exception.message", this.location, e.getClass().getSimpleName(), e.getLocalizedMessage());
            this.build();
        } else {
            this.getBuilder().status(EVerificationStatusType.ERROR);
            this.getBuilder().subTitle("net.savignano.snotify.key-management.verification.smime.keystore.canRead.failure.title", new Object[0]);
            this.getBuilder().message("net.savignano.snotify.key-management.verification.smime.keystore.canRead.failure.message", this.location);
            this.build();
        }
    }

    private void loadKeyStore() {
        Provider provider = SecurityUtil.getProvider();
        boolean outdatedJava = false;
        Exception e = null;
        KeyStore ks = null;
        int ksSize = 0;
        try {
            ks = KeyStore.getInstance(this.keyStoreType, provider);
            try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(this.location));){
                ks.load(in, this.getKeyStorePassword());
                log.debug("Could load key store from location: {}", (Object)this.location);
            }
            ksSize = ks.size();
            log.debug("Found {} entries inside key store.", (Object)ksSize);
        }
        catch (Exception e1) {
            e = e1;
            log.debug("Could not load key store from location: " + this.location, (Throwable)e);
            outdatedJava = e.getMessage().contains(CRYPTOGRAPHY_SUPPORT_ERROR);
        }
        if (e == null) {
            if (ksSize == 0) {
                this.getBuilder().status(EVerificationStatusType.ERROR);
                this.getBuilder().subTitle("net.savignano.snotify.key-management.verification.smime.keystore.loadKeyStore.empty.title", new Object[0]);
                this.getBuilder().message("net.savignano.snotify.key-management.verification.smime.keystore.loadKeyStore.empty.message", new Object[0]);
                this.build();
            } else {
                this.getBuilder().status(EVerificationStatusType.SUCCESS);
                this.getBuilder().subTitle("net.savignano.snotify.key-management.verification.smime.keystore.loadKeyStore.success.title", new Object[0]);
                this.getBuilder().message("net.savignano.snotify.key-management.verification.smime.keystore.loadKeyStore.success.message", ksSize);
                this.build();
                this.checkEmails(ks);
            }
        } else if (outdatedJava) {
            this.getBuilder().status(EVerificationStatusType.ERROR);
            this.getBuilder().subTitle("net.savignano.snotify.key-management.verification.smime.keystore.loadKeyStore.cryptographySupport.title", new Object[0]);
            this.getBuilder().message("net.savignano.snotify.key-management.verification.smime.keystore.loadKeyStore.cryptographySupport.message", e.getClass().getSimpleName(), e.getLocalizedMessage());
            this.build();
        } else {
            this.getBuilder().status(EVerificationStatusType.ERROR);
            this.getBuilder().subTitle("net.savignano.snotify.key-management.verification.smime.keystore.loadKeyStore.exception.title", new Object[0]);
            this.getBuilder().message("net.savignano.snotify.key-management.verification.smime.keystore.loadKeyStore.exception.message", e.getClass().getSimpleName(), e.getLocalizedMessage());
            this.build();
        }
    }

    private void checkEmails(KeyStore keyStore) {
        if (keyStore == null) {
            return;
        }
        if (this.getEmails().isEmpty()) {
            log.debug("No email address was given, so can't check if a certificate was found for it.");
            this.getBuilder().status(EVerificationStatusType.INFO);
            if (this.isEnablePrivateKeyCheck()) {
                this.getBuilder().subTitle("net.savignano.snotify.key-management.verification.smime.keystore.checkEmail.noServer.title", new Object[0]);
                this.getBuilder().message("net.savignano.snotify.key-management.verification.smime.keystore.checkEmail.noServer.message", new Object[0]);
            } else {
                this.getBuilder().subTitle("net.savignano.snotify.key-management.verification.smime.keystore.checkEmail.noEmail.title", new Object[0]);
                this.getBuilder().message("net.savignano.snotify.key-management.verification.smime.keystore.checkEmail.noEmail.message", new Object[0]);
            }
            this.build();
            return;
        }
        for (String email : this.getEmails()) {
            Optional<X509Certificate> cert;
            try {
                KeyStoreContentFetcher fetcher = new KeyStoreContentFetcher(keyStore);
                cert = fetcher.getCertFor(SmimeUtil.createPredicateForEmail(email));
            }
            catch (Exception e) {
                log.debug("Could not look up email <" + email + "> in keystore \"" + keyStore + "\".", (Throwable)e);
                this.getBuilder().status(EVerificationStatusType.ERROR);
                this.getBuilder().subTitle("net.savignano.snotify.key-management.verification.smime.keystore.checkEmail.exception.title", new Object[0]);
                this.getBuilder().message("net.savignano.snotify.key-management.verification.smime.keystore.checkEmail.exception.message", email, e.getClass().getSimpleName(), e.getLocalizedMessage());
                this.build();
                return;
            }
            if (cert.isPresent()) {
                log.debug("Certificate for email <{}> was found in key store.", (Object)email);
                this.getBuilder().status(EVerificationStatusType.SUCCESS);
                this.getBuilder().subTitle("net.savignano.snotify.key-management.verification.smime.keystore.checkEmail.success.title", new Object[0]);
                this.getBuilder().message("net.savignano.snotify.key-management.verification.smime.keystore.checkEmail.success.message", email);
                this.build();
                if (this.isEnablePrivateKeyCheck()) {
                    this.checkPrivateKey(keyStore, cert.get());
                    continue;
                }
                this.verifyKey(new SmimeEncryptionKey(cert.get(), email));
                continue;
            }
            log.debug("No certificate for email <{}> was found in key store.", (Object)email);
            this.getBuilder().status(EVerificationStatusType.WARNING);
            this.getBuilder().subTitle("net.savignano.snotify.key-management.verification.smime.keystore.checkEmail.failure.title", new Object[0]);
            this.getBuilder().message("net.savignano.snotify.key-management.verification.smime.keystore.checkEmail.failure.message", email);
            this.build();
        }
    }

    private void checkPrivateKey(KeyStore keyStore, X509Certificate cert) {
        PrivateKey key;
        if (keyStore == null) {
            return;
        }
        if (this.getKeyPassword() == null) {
            log.debug("No key password was given, so can't check if it matches a private key.");
            this.getBuilder().status(EVerificationStatusType.INFO);
            this.getBuilder().subTitle("net.savignano.snotify.key-management.verification.smime.keystore.checkPrivateKey.noPassword.title", new Object[0]);
            this.getBuilder().message("net.savignano.snotify.key-management.verification.smime.keystore.checkPrivateKey.noPassword.message", new Object[0]);
            this.build();
            return;
        }
        String id = SmimeUtil.getSerialNumber(cert);
        try {
            key = SmimeUtil.getPrivateKeyForCert(keyStore, cert, this.getKeyPassword());
        }
        catch (UnrecoverableKeyException e) {
            log.debug("Password did not match private key matching certificate with ID \"" + id + "\" in key store \"" + keyStore + "\".", (Throwable)e);
            this.getBuilder().status(EVerificationStatusType.ERROR);
            this.getBuilder().subTitle("net.savignano.snotify.key-management.verification.smime.keystore.checkPrivateKey.passwordException.title", new Object[0]);
            this.getBuilder().message("net.savignano.snotify.key-management.verification.smime.keystore.checkPrivateKey.passwordException.message", id);
            this.build();
            return;
        }
        catch (Exception e) {
            log.debug("Could not look up private key matching certificate with ID \"" + id + "\" in key store \"" + keyStore + "\".", (Throwable)e);
            this.getBuilder().status(EVerificationStatusType.ERROR);
            this.getBuilder().subTitle("net.savignano.snotify.key-management.verification.smime.keystore.checkPrivateKey.exception.title", new Object[0]);
            this.getBuilder().message("net.savignano.snotify.key-management.verification.smime.keystore.checkPrivateKey.exception.message", id, e.getClass().getSimpleName(), e.getLocalizedMessage());
            this.build();
            return;
        }
        if (key != null) {
            log.debug("Found private key matching certificate with ID \"{}\" in key store.", (Object)id);
            this.getBuilder().status(EVerificationStatusType.SUCCESS);
            this.getBuilder().subTitle("net.savignano.snotify.key-management.verification.smime.keystore.checkPrivateKey.success.title", new Object[0]);
            this.getBuilder().message("net.savignano.snotify.key-management.verification.smime.keystore.checkPrivateKey.success.message", id);
            this.build();
            this.verifyKey(new SmimeSignKey(key, cert));
        } else {
            log.debug("No private key matching certificate with ID \"{}\" was found in key store.", (Object)id);
            this.getBuilder().status(EVerificationStatusType.WARNING);
            this.getBuilder().subTitle("net.savignano.snotify.key-management.verification.smime.keystore.checkPrivateKey.failure.title", new Object[0]);
            this.getBuilder().message("net.savignano.snotify.key-management.verification.smime.keystore.checkPrivateKey.failure.message", id);
            this.build();
        }
    }

    public Set<String> getEmails() {
        return this.emails;
    }

    public char[] getKeyStorePassword() {
        return this.keyStorePassword;
    }

    public void setKeyStorePassword(char[] keyStorePassword) {
        this.keyStorePassword = keyStorePassword;
    }

    public char[] getKeyPassword() {
        return this.keyPassword;
    }

    public void setKeyPassword(char[] keyPassword) {
        this.keyPassword = keyPassword;
    }

    public boolean isEnablePrivateKeyCheck() {
        return this.enablePrivateKeyCheck;
    }

    public void setEnablePrivateKeyCheck(boolean enablePrivateKeyCheck) {
        this.enablePrivateKeyCheck = enablePrivateKeyCheck;
    }
}

