/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.atlassian.gui.keysource.verification.smime;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import net.savignano.cryptography.key.smime.SmimeEncryptionKey;
import net.savignano.cryptography.util.KeyStoreContentFetcher;
import net.savignano.cryptography.util.SmimeUtil;
import net.savignano.snotify.atlassian.common.ISnotifyI18n;
import net.savignano.snotify.atlassian.gui.keysource.verification.AKeySourceVerification;
import net.savignano.snotify.atlassian.gui.keysource.verification.EVerificationStatusType;
import net.savignano.thirdparty.org.bouncycastle.cert.X509CertificateHolder;
import net.savignano.thirdparty.org.bouncycastle.cms.CMSSignedData;
import net.savignano.thirdparty.org.bouncycastle.util.Store;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmimeP7bVerification
extends AKeySourceVerification {
    private static final Logger log = LoggerFactory.getLogger(SmimeP7bVerification.class);
    private final String location;
    private final Set<String> emails = new LinkedHashSet<String>();

    public SmimeP7bVerification(String location, ISnotifyI18n i18n) {
        super(i18n);
        if (location == null) {
            throw new IllegalArgumentException("Location must not be null.");
        }
        this.location = location;
        this.getBuilder().title("net.savignano.snotify.key-management.verification.smime.p7b.title", new Object[0]);
    }

    @Override
    protected void doVerify() throws Exception {
        this.canReadLocation();
    }

    private void canReadLocation() {
        SecurityException e = null;
        boolean canRead = false;
        try {
            canRead = new File(this.location).canRead();
            log.debug("Can access key store at location {}: {}", (Object)this.location, (Object)canRead);
        }
        catch (SecurityException e1) {
            e = e1;
            log.debug("Cannot access key store location: " + this.location, (Throwable)e);
        }
        if (canRead) {
            this.getBuilder().status(EVerificationStatusType.SUCCESS);
            this.getBuilder().subTitle("net.savignano.snotify.key-management.verification.smime.p7b.canRead.success.title", new Object[0]);
            this.getBuilder().message("net.savignano.snotify.key-management.verification.smime.p7b.canRead.success.message", this.location);
            this.build();
            this.loadKeyStore();
        } else if (e != null) {
            this.getBuilder().status(EVerificationStatusType.ERROR);
            this.getBuilder().subTitle("net.savignano.snotify.key-management.verification.smime.p7b.canRead.exception.title", new Object[0]);
            this.getBuilder().message("net.savignano.snotify.key-management.verification.smime.p7b.canRead.exception.message", this.location, e.getClass().getSimpleName(), e.getLocalizedMessage());
            this.build();
        } else {
            this.getBuilder().status(EVerificationStatusType.ERROR);
            this.getBuilder().subTitle("net.savignano.snotify.key-management.verification.smime.p7b.canRead.failure.title", new Object[0]);
            this.getBuilder().message("net.savignano.snotify.key-management.verification.smime.p7b.canRead.failure.message", this.location);
            this.build();
        }
    }

    private void loadKeyStore() {
        Exception e = null;
        KeyStore ks = null;
        int ksSize = 0;
        try {
            CMSSignedData signature;
            try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(this.location));){
                signature = new CMSSignedData(is);
            }
            Store<X509CertificateHolder> certStore = signature.getCertificates();
            log.debug("Loaded key store from location: {}", (Object)this.location);
            ks = SmimeUtil.convertToKeyStore(certStore, "BKS", null);
            ksSize = ks.size();
            log.debug("Found {} entries inside key store.", (Object)ksSize);
        }
        catch (Exception e1) {
            e = e1;
            log.debug("Could not load key store from location: " + this.location, (Throwable)e);
        }
        if (e == null) {
            if (ksSize == 0) {
                this.getBuilder().status(EVerificationStatusType.ERROR);
                this.getBuilder().subTitle("net.savignano.snotify.key-management.verification.smime.p7b.loadKeyStore.empty.title", new Object[0]);
                this.getBuilder().message("net.savignano.snotify.key-management.verification.smime.p7b.loadKeyStore.empty.message", new Object[0]);
            } else {
                this.getBuilder().status(EVerificationStatusType.SUCCESS);
                this.getBuilder().subTitle("net.savignano.snotify.key-management.verification.smime.p7b.loadKeyStore.success.title", new Object[0]);
                this.getBuilder().message("net.savignano.snotify.key-management.verification.smime.p7b.loadKeyStore.success.message", ksSize);
                this.build();
                this.checkEmails(ks);
            }
        } else {
            this.getBuilder().status(EVerificationStatusType.ERROR);
            this.getBuilder().subTitle("net.savignano.snotify.key-management.verification.smime.p7b.loadKeyStore.exception.title", new Object[0]);
            this.getBuilder().message("net.savignano.snotify.key-management.verification.smime.p7b.loadKeyStore.exception.message", e.getClass().getSimpleName(), e.getLocalizedMessage());
            this.build();
        }
    }

    private void checkEmails(KeyStore keyStore) {
        if (keyStore == null) {
            return;
        }
        if (this.getEmails().isEmpty()) {
            log.debug("No email address was given, so can't check if a certificate was found for it.");
            this.getBuilder().status(EVerificationStatusType.INFO);
            this.getBuilder().subTitle("net.savignano.snotify.key-management.verification.smime.p7b.checkEmail.noEmail.title", new Object[0]);
            this.getBuilder().message("net.savignano.snotify.key-management.verification.smime.p7b.checkEmail.noEmail.message", new Object[0]);
            this.build();
            return;
        }
        for (String email : this.getEmails()) {
            Optional<X509Certificate> cert;
            try {
                KeyStoreContentFetcher fetcher = new KeyStoreContentFetcher(keyStore);
                cert = fetcher.getCertFor(SmimeUtil.createPredicateForEmail(email));
            }
            catch (Exception e) {
                log.debug("Could not look up email <" + email + "> in keystore \"" + keyStore + "\".", (Throwable)e);
                this.getBuilder().status(EVerificationStatusType.ERROR);
                this.getBuilder().subTitle("net.savignano.snotify.key-management.verification.smime.p7b.checkEmail.exception.title", new Object[0]);
                this.getBuilder().message("net.savignano.snotify.key-management.verification.smime.p7b.checkEmail.exception.message", email, e.getClass().getSimpleName(), e.getLocalizedMessage());
                this.build();
                return;
            }
            if (cert.isPresent()) {
                log.debug("Certificate for email <{}> was found in key store.", (Object)email);
                this.getBuilder().status(EVerificationStatusType.SUCCESS);
                this.getBuilder().subTitle("net.savignano.snotify.key-management.verification.smime.p7b.checkEmail.success.title", new Object[0]);
                this.getBuilder().message("net.savignano.snotify.key-management.verification.smime.p7b.checkEmail.success.message", email);
                this.build();
                this.verifyKey(new SmimeEncryptionKey(cert.get(), email));
                continue;
            }
            log.debug("No certificate for email <{}> was found in key store.", (Object)email);
            this.getBuilder().status(EVerificationStatusType.WARNING);
            this.getBuilder().subTitle("net.savignano.snotify.key-management.verification.smime.p7b.checkEmail.failure.title", new Object[0]);
            this.getBuilder().message("net.savignano.snotify.key-management.verification.smime.p7b.checkEmail.failure.message", email);
            this.build();
        }
    }

    public Set<String> getEmails() {
        return this.emails;
    }
}

