/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.confluence.common;

import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.core.AtlassianCoreException;
import com.atlassian.core.user.preferences.UserPreferences;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.component.ComponentLocator;
import com.opensymphony.module.propertyset.PropertyException;
import javax.inject.Inject;
import net.savignano.snotify.atlassian.common.properties.ASnotifyUserProperties;
import net.savignano.snotify.atlassian.common.user.IUser;
import net.savignano.snotify.confluence.common.ConfluenceUser;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class SnotifyUserProperties
extends ASnotifyUserProperties {
    private static final Logger log = LoggerFactory.getLogger(SnotifyUserProperties.class);
    @Inject
    @ComponentImport
    private UserAccessor accessor;

    @Override
    protected String getString(String key, IUser<?> user) {
        String value;
        try {
            value = this.getPrefs(user).getString(key);
        }
        catch (PropertyException e) {
            log.error("Exception loading property " + key + " for " + user + ".", (Throwable)e);
            return null;
        }
        catch (ClassCastException e) {
            log.error("Exception loading property " + key + " for " + user + ".", (Throwable)e);
            try {
                this.getPrefs(user).remove(key);
            }
            catch (AtlassianCoreException e1) {
                log.error("Exception removing property " + key + " for " + user + ".", (Throwable)e);
            }
            return null;
        }
        if (StringUtils.isBlank((CharSequence)value)) {
            log.trace("User property \"{}\" for {} is considered null.", (Object)key, user);
            return null;
        }
        log.trace("User property \"{}\" for {} is: {}", new Object[]{key, user, value});
        return value;
    }

    @Override
    protected void setString(String key, String value, IUser<?> user) {
        boolean stringExists = false;
        try {
            UserPreferences prefs = this.getPrefs(user);
            try {
                stringExists = prefs.getString(key) != null;
            }
            catch (Exception e) {
                log.debug("Exception getting string property " + key + " for " + user + ".", (Throwable)e);
                prefs.remove(key);
            }
            if (value == null && stringExists) {
                log.trace("Removing user property \"{}\" for {}.", (Object)key, user);
                prefs.remove(key);
            }
            if (value != null) {
                log.trace("Setting user property \"{}\" for {}: {}", new Object[]{key, user, value});
                prefs.setString(key, value);
            }
            if (log.isTraceEnabled()) {
                String newValue = prefs.getString(key);
                if (value == null ? newValue != null : !value.equals(newValue)) {
                    log.error("Setting of user property \"{}\" for {} failed. Expected value: \"{}\". Actual value: \"{}\"", new Object[]{key, user, value, newValue});
                }
            }
        }
        catch (AtlassianCoreException | PropertyException e) {
            log.error("Exception setting property " + key + " for " + user + ".", e);
        }
    }

    private UserPreferences getPrefs(IUser<?> user) {
        if (user == null) {
            throw new PropertyException("Can't get user preferences for 'null' user.");
        }
        if (!(user instanceof ConfluenceUser)) {
            throw new PropertyException("User is not a ConfluenceUser. Found instead: " + user);
        }
        return this.getAccessor().getConfluenceUserPreferences(((ConfluenceUser)user).getActualUser()).getWrappedPreferences();
    }

    private UserAccessor getAccessor() {
        if (this.accessor == null) {
            log.trace("Injection of UserAccessor failed. Loading manually.");
            this.accessor = (UserAccessor)ComponentLocator.getComponent(UserAccessor.class);
        }
        return this.accessor;
    }
}

