/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.confluence.gui.action;

import com.atlassian.confluence.status.service.SystemInformationService;
import com.atlassian.confluence.status.service.systeminfo.ConfluenceInfo;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.core.filters.ServletContextThreadLocal;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.velocity.htmlsafe.HtmlSafe;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.function.Supplier;
import javax.servlet.http.HttpServletResponse;
import net.savignano.cryptography.Constants;
import net.savignano.snotify.atlassian.common.EProperty;
import net.savignano.snotify.atlassian.common.properties.ASnotifyAppProperties;
import net.savignano.snotify.atlassian.gui.SupportBuilder;
import net.savignano.snotify.atlassian.gui.keysource.verification.VerificationStatusBuilder;
import net.savignano.snotify.atlassian.gui.keysource.verification.VerificationStatusDisplay;
import net.savignano.snotify.confluence.gui.action.SnotifyAdminSettingsAction;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class TweakSnotifyAction
extends SnotifyAdminSettingsAction {
    private static final long serialVersionUID = 7632726919010810715L;
    private static final String KEY_PARAM = "key";
    private static final String VALUE_PARAM = "value";
    private String key;
    private String value;
    private String errorMessage;
    private boolean noXsrfViolation;
    private InputStream supportStream;
    @Autowired
    @ComponentImport
    private PluginLicenseManager licenseManager;

    public String doInput() {
        this.noXsrfViolation = true;
        if (!this.hasAdminRights()) {
            ConfluenceUser user = this.getAuthenticatedUser();
            this.getLog().warn("Unauthorized access to view S/Notify tweak values from user: {}", (Object)(user != null ? user.getFullName() : "<Unknown User>"));
            return "error";
        }
        return "input";
    }

    public String doAdd() {
        this.noXsrfViolation = true;
        if (!"POST".equals(this.getCurrentRequest().getMethod())) {
            this.getLog().debug("Access to add method redirected to input method, as request method wasn't 'POST'. Used method: " + this.getCurrentRequest().getMethod());
            return this.doInput();
        }
        if (!this.hasAdminRights()) {
            ConfluenceUser user = this.getAuthenticatedUser();
            this.getLog().warn("Unauthorized access to add S/Notify tweak values from user: {}", (Object)(user != null ? user.getFullName() : "<Unknown User>"));
            return "error";
        }
        String key = StringUtils.stripToNull((String)this.getCurrentRequest().getParameter(KEY_PARAM));
        String value = StringUtils.stripToNull((String)this.getCurrentRequest().getParameter(VALUE_PARAM));
        if (key == null || value == null) {
            this.getLog().debug("Key or Value is considered empty. Tweak will not be added.");
            VerificationStatusBuilder builder = new VerificationStatusBuilder(this.getSnotifyI18n());
            builder.error();
            builder.title("snotify-tweak-webwork.input.error.missingKeyValue.title", new Object[0]);
            builder.message("snotify-tweak-webwork.input.error.missingKeyValue.message", key);
            this.errorMessage = VerificationStatusDisplay.getHtml(builder.build());
            this.key = key;
            this.value = value;
            return "input";
        }
        this.getLog().debug("Adding key/value pair to tweak: {} = {}", (Object)key, (Object)value);
        this.setProperty(key, value);
        return "input";
    }

    public String doUpdate() {
        this.noXsrfViolation = true;
        if (!"POST".equals(this.getCurrentRequest().getMethod())) {
            this.getLog().debug("Access to update method redirected to input method, as request method wasn't 'POST'. Used method: " + this.getCurrentRequest().getMethod());
            return this.doInput();
        }
        if (!this.hasAdminRights()) {
            ConfluenceUser user = this.getAuthenticatedUser();
            this.getLog().warn("Unauthorized access to update S/Notify tweak values from user: {}", (Object)(user != null ? user.getFullName() : "<Unknown User>"));
            return "error";
        }
        String key = StringUtils.stripToNull((String)this.getCurrentRequest().getParameter(KEY_PARAM));
        String value = StringUtils.stripToNull((String)this.getCurrentRequest().getParameter(VALUE_PARAM));
        if (key == null || value == null) {
            this.getLog().debug("Key or Value is considered empty. Tweak will not be updated.");
            VerificationStatusBuilder builder = new VerificationStatusBuilder(this.getSnotifyI18n());
            builder.error();
            builder.title("snotify-tweak-webwork.input.error.missingKeyValue.title", new Object[0]);
            builder.message("snotify-tweak-webwork.input.error.missingKeyValue.message", key);
            this.errorMessage = VerificationStatusDisplay.getHtml(builder.build());
            return "input";
        }
        this.getLog().debug("Updating key/value pair to tweak: {} = {}", (Object)key, (Object)value);
        this.setProperty(key, value);
        return "input";
    }

    public String doDelete() {
        this.noXsrfViolation = true;
        if (!"POST".equals(this.getCurrentRequest().getMethod())) {
            this.getLog().debug("Access to delete method redirected to input method, as request method wasn't 'POST'. Used method: " + this.getCurrentRequest().getMethod());
            return this.doInput();
        }
        if (!this.hasAdminRights()) {
            ConfluenceUser user = this.getAuthenticatedUser();
            this.getLog().warn("Unauthorized access to delete S/Notify tweak values from user: {}", (Object)(user != null ? user.getFullName() : "<Unknown User>"));
            return "error";
        }
        String key = StringUtils.stripToNull((String)this.getCurrentRequest().getParameter(KEY_PARAM));
        if (key == null) {
            this.getLog().debug("Key is considered empty. Tweak will not be removed.");
            return "input";
        }
        this.getLog().debug("Removing key from tweaks: {}", (Object)key);
        Optional<EProperty> prop = EProperty.getProperty("tweak." + key);
        if (prop.isPresent()) {
            ((ASnotifyAppProperties)this.getAppProps()).setAsString(prop.get(), null);
        } else {
            this.getLog().debug("Key {} does not represent a tweak.", (Object)key);
        }
        Map<String, String> tweaks = this.getUsedTweaks();
        tweaks.remove(key);
        this.setUsedTweaks(tweaks);
        this.setShowUpdated(true);
        return "input";
    }

    public String doSupport() {
        this.noXsrfViolation = true;
        if (!this.hasAdminRights()) {
            ConfluenceUser user = this.getAuthenticatedUser();
            this.getLog().warn("Unauthorized access to view S/Notify tweak values from user: {}", (Object)(user != null ? user.getFullName() : "<Unknown User>"));
            return "error";
        }
        String data = this.createSupportData();
        byte[] contents = data.getBytes(Constants.UTF8_CHARSET);
        this.supportStream = new ByteArrayInputStream(contents);
        HttpServletResponse response = ServletContextThreadLocal.getResponse();
        response.setHeader("Content-Length", String.valueOf(contents.length));
        response.setHeader("Cache-Control", "no-cache");
        response.setHeader("Pragma", "no-cache");
        response.setHeader("Expires", "-1");
        response.setHeader("Content-Disposition", "attachment; filename=\"snotify-support.txt\"");
        return "download";
    }

    private String createSupportData() {
        Supplier<String> platform = () -> {
            SystemInformationService service = (SystemInformationService)ComponentLocator.getComponent(SystemInformationService.class);
            ConfluenceInfo info = service.getConfluenceInfo();
            return "Confluence " + info.getVersion();
        };
        return SupportBuilder.create().includeLicenseId(this.licenseManager).includePlatform(platform).includeProperties(this.getAppProps()).build();
    }

    private void setProperty(String key, String value) {
        Optional<EProperty> prop = EProperty.getProperty("tweak." + key);
        if (!prop.isPresent()) {
            this.getLog().debug("Key {} does not represent a tweak.", (Object)key);
            VerificationStatusBuilder builder = new VerificationStatusBuilder(this.getSnotifyI18n());
            builder.error();
            builder.title("snotify-tweak-webwork.input.error.notAProperty.title", new Object[0]);
            builder.message("snotify-tweak-webwork.input.error.notAProperty.message", key);
            this.errorMessage = VerificationStatusDisplay.getHtml(builder.build());
            this.key = key;
            this.value = value;
            return;
        }
        ((ASnotifyAppProperties)this.getAppProps()).setAsString(prop.get(), value);
        Map<String, String> tweaks = this.getUsedTweaks();
        tweaks.put(key, value);
        this.setUsedTweaks(tweaks);
        this.setShowUpdated(true);
    }

    private Map<String, String> getUsedTweaks() {
        TreeMap<String, String> tweaks = new TreeMap<String, String>();
        String tweakString = this.getAppProps().getUnlimitedString(EProperty.TWEAK_OVERVIEW);
        if (tweakString != null) {
            for (String tweak : tweakString.split("\\;")) {
                Optional<EProperty> prop = EProperty.getProperty("tweak." + tweak);
                if (prop.isPresent()) {
                    tweaks.put(tweak, ((ASnotifyAppProperties)this.getAppProps()).getAsString(prop.get()));
                    continue;
                }
                this.getLog().info("Key {} is not considered a tweak. It will be skipped.");
            }
        }
        return tweaks;
    }

    private void setUsedTweaks(Map<String, String> tweaks) {
        if (tweaks == null || tweaks.isEmpty()) {
            this.getAppProps().setUnlimitedString(EProperty.TWEAK_OVERVIEW, null);
        } else {
            StringBuilder builder = new StringBuilder();
            for (Map.Entry<String, String> entry : tweaks.entrySet()) {
                builder.append(entry.getKey());
                builder.append(';');
            }
            builder.deleteCharAt(builder.length() - 1);
            this.getAppProps().setUnlimitedString(EProperty.TWEAK_OVERVIEW, builder.toString());
        }
    }

    public Collection<Map.Entry<String, String>> getTweakEntries() {
        return this.getUsedTweaks().entrySet();
    }

    @HtmlSafe
    public String getErrorMessage() {
        return this.errorMessage == null ? "" : this.errorMessage;
    }

    public InputStream getSupport() {
        return this.supportStream;
    }

    public boolean isXsrfViolation() {
        return !this.noXsrfViolation;
    }

    public String getKey() {
        return this.key == null ? "" : this.key;
    }

    public String getValue() {
        return this.value == null ? "" : this.value;
    }
}

