/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.confluence.gui.key.info;

import net.savignano.snotify.atlassian.gui.key.info.IKeyValueStyle;
import org.apache.commons.text.StringEscapeUtils;

public class HtmlKeyValueStyle
implements IKeyValueStyle {
    @Override
    public String build(String label, Object value, String id) {
        StringBuilder builder = new StringBuilder(150);
        builder.append("<tr>");
        this.buildLabel(label, id, builder);
        this.buildValue(value, id, builder);
        builder.append("</tr>\n");
        return builder.toString();
    }

    private void buildLabel(String label, String id, StringBuilder builder) {
        if (id == null) {
            builder.append("<th align=\"right\">");
        } else {
            builder.append("<th align=\"right\" id=\"");
            builder.append(StringEscapeUtils.escapeHtml4((String)id));
            builder.append("-key\">");
        }
        builder.append(StringEscapeUtils.escapeHtml4((String)label));
        builder.append(":</th>");
    }

    private void buildValue(Object value, String id, StringBuilder builder) {
        if (id == null) {
            builder.append("<td>");
        } else {
            builder.append("<td id=\"");
            builder.append(StringEscapeUtils.escapeHtml4((String)id));
            builder.append("-value\">");
        }
        if (value == null) {
            builder.append("N/A");
        } else {
            builder.append(StringEscapeUtils.escapeHtml4((String)value.toString()));
        }
        builder.append("</td>");
    }
}

