/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.cert.crmf;

import java.io.IOException;
import java.io.OutputStream;
import net.savignano.thirdparty.org.bouncycastle.asn1.DERBitString;
import net.savignano.thirdparty.org.bouncycastle.asn1.crmf.PKMACValue;
import net.savignano.thirdparty.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import net.savignano.thirdparty.org.bouncycastle.cert.crmf.CRMFException;
import net.savignano.thirdparty.org.bouncycastle.cert.crmf.PKMACBuilder;
import net.savignano.thirdparty.org.bouncycastle.operator.MacCalculator;

abstract class PKMACValueGenerator {
    private PKMACValueGenerator() {
    }

    public static PKMACValue generate(PKMACBuilder builder, char[] password, SubjectPublicKeyInfo keyInfo) throws CRMFException {
        MacCalculator calculator = builder.build(password);
        OutputStream macOut = calculator.getOutputStream();
        try {
            macOut.write(keyInfo.getEncoded("DER"));
            macOut.close();
        }
        catch (IOException e) {
            throw new CRMFException("exception encoding mac input: " + e.getMessage(), e);
        }
        return new PKMACValue(calculator.getAlgorithmIdentifier(), new DERBitString(calculator.getMac()));
    }
}

