/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.crypto.kems;

import java.math.BigInteger;
import net.savignano.thirdparty.org.bouncycastle.crypto.CryptoServicePurpose;
import net.savignano.thirdparty.org.bouncycastle.crypto.CryptoServicesRegistrar;
import net.savignano.thirdparty.org.bouncycastle.crypto.DerivationFunction;
import net.savignano.thirdparty.org.bouncycastle.crypto.EncapsulatedSecretExtractor;
import net.savignano.thirdparty.org.bouncycastle.crypto.constraints.ConstraintUtils;
import net.savignano.thirdparty.org.bouncycastle.crypto.constraints.DefaultServiceProperties;
import net.savignano.thirdparty.org.bouncycastle.crypto.kems.RSAKEMGenerator;
import net.savignano.thirdparty.org.bouncycastle.crypto.params.RSAKeyParameters;

public class RSAKEMExtractor
implements EncapsulatedSecretExtractor {
    private final RSAKeyParameters privKey;
    private final int keyLen;
    private DerivationFunction kdf;

    public RSAKEMExtractor(RSAKeyParameters privKey, int keyLen, DerivationFunction kdf) {
        if (!privKey.isPrivate()) {
            throw new IllegalArgumentException("private key required for encryption");
        }
        this.privKey = privKey;
        this.keyLen = keyLen;
        this.kdf = kdf;
        CryptoServicesRegistrar.checkConstraints(new DefaultServiceProperties("RSAKem", ConstraintUtils.bitsOfSecurityFor(this.privKey.getModulus()), privKey, CryptoServicePurpose.DECRYPTION));
    }

    @Override
    public byte[] extractSecret(byte[] encapsulation) {
        BigInteger n = this.privKey.getModulus();
        BigInteger d = this.privKey.getExponent();
        BigInteger c = new BigInteger(1, encapsulation);
        BigInteger r = c.modPow(d, n);
        return RSAKEMGenerator.generateKey(this.kdf, n, r, this.keyLen);
    }

    @Override
    public int getEncapsulationLength() {
        return (this.privKey.getModulus().bitLength() + 7) / 8;
    }
}

