/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.openpgp.operator.jcajce;

import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import net.savignano.thirdparty.org.bouncycastle.bcpg.BCPGKey;
import net.savignano.thirdparty.org.bouncycastle.bcpg.MPInteger;
import net.savignano.thirdparty.org.bouncycastle.bcpg.PublicKeyPacket;
import net.savignano.thirdparty.org.bouncycastle.bcpg.RSAPublicBCPGKey;
import net.savignano.thirdparty.org.bouncycastle.bcpg.UnsupportedPacketVersionException;
import net.savignano.thirdparty.org.bouncycastle.jcajce.util.DefaultJcaJceHelper;
import net.savignano.thirdparty.org.bouncycastle.jcajce.util.JcaJceHelper;
import net.savignano.thirdparty.org.bouncycastle.jcajce.util.NamedJcaJceHelper;
import net.savignano.thirdparty.org.bouncycastle.jcajce.util.ProviderJcaJceHelper;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPException;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;

public class JcaKeyFingerprintCalculator
implements KeyFingerPrintCalculator {
    private final JcaJceHelper helper;

    public JcaKeyFingerprintCalculator() {
        this(new DefaultJcaJceHelper());
    }

    private JcaKeyFingerprintCalculator(JcaJceHelper helper) {
        this.helper = helper;
    }

    public JcaKeyFingerprintCalculator setProvider(Provider provider) {
        return new JcaKeyFingerprintCalculator(new ProviderJcaJceHelper(provider));
    }

    public JcaKeyFingerprintCalculator setProvider(String providerName) {
        return new JcaKeyFingerprintCalculator(new NamedJcaJceHelper(providerName));
    }

    @Override
    public byte[] calculateFingerprint(PublicKeyPacket publicPk) throws PGPException {
        BCPGKey key = publicPk.getKey();
        if (publicPk.getVersion() <= 3) {
            RSAPublicBCPGKey rK = (RSAPublicBCPGKey)key;
            try {
                MessageDigest digest = this.helper.createMessageDigest("MD5");
                byte[] bytes = new MPInteger(rK.getModulus()).getEncoded();
                digest.update(bytes, 2, bytes.length - 2);
                bytes = new MPInteger(rK.getPublicExponent()).getEncoded();
                digest.update(bytes, 2, bytes.length - 2);
                return digest.digest();
            }
            catch (NoSuchAlgorithmException e) {
                throw new PGPException("can't find MD5", e);
            }
            catch (NoSuchProviderException e) {
                throw new PGPException("can't find MD5", e);
            }
            catch (IOException e) {
                throw new PGPException("can't encode key components: " + e.getMessage(), e);
            }
        }
        if (publicPk.getVersion() == 4) {
            try {
                byte[] kBytes = publicPk.getEncodedContents();
                MessageDigest digest = this.helper.createMessageDigest("SHA1");
                digest.update((byte)-103);
                digest.update((byte)(kBytes.length >> 8));
                digest.update((byte)kBytes.length);
                digest.update(kBytes);
                return digest.digest();
            }
            catch (NoSuchAlgorithmException e) {
                throw new PGPException("can't find SHA1", e);
            }
            catch (NoSuchProviderException e) {
                throw new PGPException("can't find SHA1", e);
            }
            catch (IOException e) {
                throw new PGPException("can't encode key components: " + e.getMessage(), e);
            }
        }
        if (publicPk.getVersion() == 6) {
            try {
                byte[] kBytes = publicPk.getEncodedContents();
                MessageDigest digest = this.helper.createMessageDigest("SHA-256");
                digest.update((byte)-101);
                digest.update((byte)(kBytes.length >> 24));
                digest.update((byte)(kBytes.length >> 16));
                digest.update((byte)(kBytes.length >> 8));
                digest.update((byte)kBytes.length);
                digest.update(kBytes);
                return digest.digest();
            }
            catch (NoSuchAlgorithmException e) {
                throw new PGPException("can't find SHA-256", e);
            }
            catch (NoSuchProviderException e) {
                throw new PGPException("can't find SHA-256", e);
            }
            catch (IOException e) {
                throw new PGPException("can't encode key components: " + e.getMessage(), e);
            }
        }
        throw new UnsupportedPacketVersionException("Unsupported PGP key version: " + publicPk.getVersion());
    }
}

