/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.pqc.crypto.ntru;

import java.util.Arrays;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.ntru.PolynomialPair;
import net.savignano.thirdparty.org.bouncycastle.pqc.math.ntru.HPSPolynomial;
import net.savignano.thirdparty.org.bouncycastle.pqc.math.ntru.HRSSPolynomial;
import net.savignano.thirdparty.org.bouncycastle.pqc.math.ntru.Polynomial;
import net.savignano.thirdparty.org.bouncycastle.pqc.math.ntru.parameters.NTRUHPSParameterSet;
import net.savignano.thirdparty.org.bouncycastle.pqc.math.ntru.parameters.NTRUHRSSParameterSet;
import net.savignano.thirdparty.org.bouncycastle.pqc.math.ntru.parameters.NTRUParameterSet;

class NTRUSampling {
    private final NTRUParameterSet params;

    public NTRUSampling(NTRUParameterSet params) {
        this.params = params;
    }

    public PolynomialPair sampleFg(byte[] uniformBytes) {
        if (this.params instanceof NTRUHRSSParameterSet) {
            HRSSPolynomial f = this.sampleIidPlus(net.savignano.thirdparty.org.bouncycastle.util.Arrays.copyOfRange(uniformBytes, 0, this.params.sampleIidBytes()));
            HRSSPolynomial g = this.sampleIidPlus(net.savignano.thirdparty.org.bouncycastle.util.Arrays.copyOfRange(uniformBytes, this.params.sampleIidBytes(), uniformBytes.length));
            return new PolynomialPair(f, g);
        }
        if (this.params instanceof NTRUHPSParameterSet) {
            HPSPolynomial f = (HPSPolynomial)this.sampleIid(net.savignano.thirdparty.org.bouncycastle.util.Arrays.copyOfRange(uniformBytes, 0, this.params.sampleIidBytes()));
            HPSPolynomial g = this.sampleFixedType(net.savignano.thirdparty.org.bouncycastle.util.Arrays.copyOfRange(uniformBytes, this.params.sampleIidBytes(), uniformBytes.length));
            return new PolynomialPair(f, g);
        }
        throw new IllegalArgumentException("Invalid polynomial type");
    }

    public PolynomialPair sampleRm(byte[] uniformBytes) {
        if (this.params instanceof NTRUHRSSParameterSet) {
            HRSSPolynomial r = (HRSSPolynomial)this.sampleIid(net.savignano.thirdparty.org.bouncycastle.util.Arrays.copyOfRange(uniformBytes, 0, this.params.sampleIidBytes()));
            HRSSPolynomial m = (HRSSPolynomial)this.sampleIid(net.savignano.thirdparty.org.bouncycastle.util.Arrays.copyOfRange(uniformBytes, this.params.sampleIidBytes(), uniformBytes.length));
            return new PolynomialPair(r, m);
        }
        if (this.params instanceof NTRUHPSParameterSet) {
            HPSPolynomial r = (HPSPolynomial)this.sampleIid(net.savignano.thirdparty.org.bouncycastle.util.Arrays.copyOfRange(uniformBytes, 0, this.params.sampleIidBytes()));
            HPSPolynomial m = this.sampleFixedType(net.savignano.thirdparty.org.bouncycastle.util.Arrays.copyOfRange(uniformBytes, this.params.sampleIidBytes(), uniformBytes.length));
            return new PolynomialPair(r, m);
        }
        throw new IllegalArgumentException("Invalid polynomial type");
    }

    public Polynomial sampleIid(byte[] uniformBytes) {
        Polynomial r = this.params.createPolynomial();
        for (int i = 0; i < this.params.n() - 1; ++i) {
            r.coeffs[i] = (short)NTRUSampling.mod3(uniformBytes[i] & 0xFF);
        }
        r.coeffs[this.params.n() - 1] = 0;
        return r;
    }

    public HPSPolynomial sampleFixedType(byte[] uniformBytes) {
        int i;
        int n = this.params.n();
        int weight = ((NTRUHPSParameterSet)this.params).weight();
        HPSPolynomial r = new HPSPolynomial((NTRUHPSParameterSet)this.params);
        int[] s = new int[n - 1];
        for (i = 0; i < (n - 1) / 4; ++i) {
            s[4 * i + 0] = ((uniformBytes[15 * i + 0] & 0xFF) << 2) + ((uniformBytes[15 * i + 1] & 0xFF) << 10) + ((uniformBytes[15 * i + 2] & 0xFF) << 18) + ((uniformBytes[15 * i + 3] & 0xFF) << 26);
            s[4 * i + 1] = ((uniformBytes[15 + i * 3] & 0xFF & 0xC0) >> 4) + ((uniformBytes[15 * i + 4] & 0xFF) << 4) + ((uniformBytes[15 * i + 5] & 0xFF) << 12) + ((uniformBytes[15 * i + 6] & 0xFF) << 20) + ((uniformBytes[15 * i + 7] & 0xFF) << 28);
            s[4 * i + 2] = ((uniformBytes[15 + i * 7] & 0xFF & 0xF0) >> 2) + ((uniformBytes[15 * i + 8] & 0xFF) << 6) + ((uniformBytes[15 * i + 9] & 0xFF) << 14) + ((uniformBytes[15 * i + 10] & 0xFF) << 22) + ((uniformBytes[15 * i + 11] & 0xFF) << 30);
            s[4 * i + 3] = (uniformBytes[15 * i + 11] & 0xFF & 0xFC) + ((uniformBytes[15 * i + 12] & 0xFF) << 8) + ((uniformBytes[15 * i + 13] & 0xFF) << 16) + ((uniformBytes[15 * i + 14] & 0xFF) << 24);
        }
        if (n - 1 > (n - 1) / 4 * 4) {
            i = (n - 1) / 4;
            s[4 * i + 0] = ((uniformBytes[15 * i + 0] & 0xFF) << 2) + ((uniformBytes[15 * i + 1] & 0xFF) << 10) + ((uniformBytes[15 * i + 2] & 0xFF) << 18) + ((uniformBytes[15 * i + 3] & 0xFF) << 26);
            s[4 * i + 1] = ((uniformBytes[15 + i * 3] & 0xFF & 0xC0) >> 4) + ((uniformBytes[15 * i + 4] & 0xFF) << 4) + ((uniformBytes[15 * i + 5] & 0xFF) << 12) + ((uniformBytes[15 * i + 6] & 0xFF) << 20) + ((uniformBytes[15 * i + 7] & 0xFF) << 28);
        }
        i = 0;
        while (i < weight / 2) {
            int n2 = i++;
            s[n2] = s[n2] | 1;
        }
        i = weight / 2;
        while (i < weight) {
            int n3 = i++;
            s[n3] = s[n3] | 2;
        }
        Arrays.sort(s);
        for (i = 0; i < n - 1; ++i) {
            r.coeffs[i] = (short)(s[i] & 3);
        }
        r.coeffs[n - 1] = 0;
        return r;
    }

    public HRSSPolynomial sampleIidPlus(byte[] uniformBytes) {
        int i;
        int n = this.params.n();
        int s = 0;
        HRSSPolynomial r = (HRSSPolynomial)this.sampleIid(uniformBytes);
        for (i = 0; i < n - 1; ++i) {
            r.coeffs[i] = (short)(r.coeffs[i] | -(r.coeffs[i] >>> 1));
        }
        for (i = 0; i < n - 1; ++i) {
            s = (short)(s + (short)(r.coeffs[i + 1] * r.coeffs[i]));
        }
        s = (short)(1 | -((s & 0xFFFF) >>> 15));
        for (i = 0; i < n - 1; i += 2) {
            r.coeffs[i] = (short)(s * r.coeffs[i]);
        }
        for (i = 0; i < n - 1; ++i) {
            r.coeffs[i] = (short)(3 & (r.coeffs[i] & 0xFFFF ^ (r.coeffs[i] & 0xFFFF) >>> 15));
        }
        return r;
    }

    private static int mod3(int a) {
        return a % 3;
    }
}

