/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.pqc.jcajce.provider.rainbow;

import java.io.ByteArrayOutputStream;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.AlgorithmParameterSpec;
import net.savignano.thirdparty.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import net.savignano.thirdparty.org.bouncycastle.crypto.params.ParametersWithRandom;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.rainbow.RainbowParameters;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.rainbow.RainbowPrivateKeyParameters;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.rainbow.RainbowSigner;
import net.savignano.thirdparty.org.bouncycastle.pqc.jcajce.provider.rainbow.BCRainbowPrivateKey;
import net.savignano.thirdparty.org.bouncycastle.pqc.jcajce.provider.rainbow.BCRainbowPublicKey;
import net.savignano.thirdparty.org.bouncycastle.util.Strings;

public class SignatureSpi
extends Signature {
    private ByteArrayOutputStream bOut;
    private RainbowSigner signer;
    private SecureRandom random;
    private RainbowParameters parameters;

    protected SignatureSpi(RainbowSigner signer) {
        super("RAINBOW");
        this.bOut = new ByteArrayOutputStream();
        this.signer = signer;
        this.parameters = null;
    }

    protected SignatureSpi(RainbowSigner signer, RainbowParameters parameters) {
        super(Strings.toUpperCase(parameters.getName()));
        this.parameters = parameters;
        this.bOut = new ByteArrayOutputStream();
        this.signer = signer;
    }

    @Override
    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        String canonicalAlg;
        if (!(publicKey instanceof BCRainbowPublicKey)) {
            try {
                publicKey = new BCRainbowPublicKey(SubjectPublicKeyInfo.getInstance(publicKey.getEncoded()));
            }
            catch (Exception e) {
                throw new InvalidKeyException("unknown public key passed to Rainbow: " + e.getMessage(), e);
            }
        }
        BCRainbowPublicKey key = (BCRainbowPublicKey)publicKey;
        if (this.parameters != null && !(canonicalAlg = Strings.toUpperCase(this.parameters.getName())).equals(key.getAlgorithm())) {
            throw new InvalidKeyException("signature configured for " + canonicalAlg);
        }
        this.signer.init(false, key.getKeyParams());
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey, SecureRandom random) throws InvalidKeyException {
        this.random = random;
        this.engineInitSign(privateKey);
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        if (privateKey instanceof BCRainbowPrivateKey) {
            String canonicalAlg;
            BCRainbowPrivateKey key = (BCRainbowPrivateKey)privateKey;
            RainbowPrivateKeyParameters param = key.getKeyParams();
            if (this.parameters != null && !(canonicalAlg = Strings.toUpperCase(this.parameters.getName())).equals(key.getAlgorithm())) {
                throw new InvalidKeyException("signature configured for " + canonicalAlg);
            }
            if (this.random != null) {
                this.signer.init(true, new ParametersWithRandom(param, this.random));
            } else {
                this.signer.init(true, param);
            }
        } else {
            throw new InvalidKeyException("unknown private key passed to Rainbow");
        }
    }

    @Override
    protected void engineUpdate(byte b) throws SignatureException {
        this.bOut.write(b);
    }

    @Override
    protected void engineUpdate(byte[] b, int off, int len) throws SignatureException {
        this.bOut.write(b, off, len);
    }

    @Override
    protected byte[] engineSign() throws SignatureException {
        try {
            byte[] message = this.bOut.toByteArray();
            this.bOut.reset();
            return this.signer.generateSignature(message);
        }
        catch (Exception e) {
            throw new SignatureException(e.toString());
        }
    }

    @Override
    protected boolean engineVerify(byte[] sigBytes) throws SignatureException {
        byte[] message = this.bOut.toByteArray();
        this.bOut.reset();
        return this.signer.verifySignature(message, sigBytes);
    }

    @Override
    protected void engineSetParameter(AlgorithmParameterSpec params) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    @Override
    protected void engineSetParameter(String param, Object value) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    @Override
    protected Object engineGetParameter(String param) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    public static class RainbowVcomp
    extends SignatureSpi {
        public RainbowVcomp() {
            super(new RainbowSigner(), RainbowParameters.rainbowVcompressed);
        }
    }

    public static class RainbowVcircum
    extends SignatureSpi {
        public RainbowVcircum() {
            super(new RainbowSigner(), RainbowParameters.rainbowVcircumzenithal);
        }
    }

    public static class RainbowVclassic
    extends SignatureSpi {
        public RainbowVclassic() {
            super(new RainbowSigner(), RainbowParameters.rainbowVclassic);
        }
    }

    public static class RainbowIIIcomp
    extends SignatureSpi {
        public RainbowIIIcomp() {
            super(new RainbowSigner(), RainbowParameters.rainbowIIIcompressed);
        }
    }

    public static class RainbowIIIcircum
    extends SignatureSpi {
        public RainbowIIIcircum() {
            super(new RainbowSigner(), RainbowParameters.rainbowIIIcircumzenithal);
        }
    }

    public static class RainbowIIIclassic
    extends SignatureSpi {
        public RainbowIIIclassic() {
            super(new RainbowSigner(), RainbowParameters.rainbowIIIclassic);
        }
    }

    public static class Base
    extends SignatureSpi {
        public Base() {
            super(new RainbowSigner());
        }
    }
}

