/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.confluence.mailer;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;
import com.atlassian.confluence.user.ConfluenceUserPreferences;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.core.user.preferences.UserPreferences;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.user.User;
import com.atlassian.user.search.SearchResult;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.mail.Address;
import javax.mail.Header;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import net.savignano.snotify.confluence.mailer.MessageAndAddress;
import net.savignano.snotify.confluence.mailer.security.CertUtil;
import net.savignano.snotify.confluence.mailer.security.SecurityUtil;
import org.apache.commons.codec.binary.Base64;
import org.bouncycastle.cms.CMSAlgorithm;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.RecipientInfoGenerator;
import org.bouncycastle.cms.jcajce.JceCMSContentEncryptorBuilder;
import org.bouncycastle.cms.jcajce.JceKeyTransRecipientInfoGenerator;
import org.bouncycastle.mail.smime.SMIMEEnvelopedGenerator;
import org.bouncycastle.mail.smime.SMIMEException;
import org.bouncycastle.operator.OutputEncryptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Mailer {
    private static final String PREFIX_PROP = "net.savignano.snotify.";
    public static final String EMAIL_CERT_PROP = "net.savignano.snotify.email.smime.cert";
    public static final String EMAIL_ENCRYPTION_FAILURE_PROP = "net.savignano.snotify.email.encryptionFailure";
    public static final String KEYSTORE_LOCATION_PROP = "net.savignano.snotify.certificate.keystoreLocation";
    public static final String KEYSTORE_PASSWORD_PROP = "net.savignano.snotify.certificate.keystorePassword";
    public static final String CERTIFICATE_LOCATION_PRIORITY_PROP = "net.savignano.snotify.certificate.locationPriority";
    public static final String FREEZE_SNOTIFY_PROP = "net.savignano.snotify.mailer.freeze";
    public static final String DISABLE_SNOTIFY_PROP = "net.savignano.snotify.mailer.disable";
    public static final String BOUNCY_CASTLE_KEYSTORE_TYPE = "BKS";
    public static final String UTF8 = "UTF-8";
    public static final Charset UTF8_CHARSET = Charset.forName("UTF-8");
    private static final String[] SPECIAL_HEADERS = new String[]{"MIME-Version", "Content-Type", "Content-Transfer-Encoding"};
    private static final String INFO_MESSAGE = "Message could not be encrypted. Please contact your Jira administrator.";
    private static final String XENCRPYTED_MAIL_PROPERTY = "X-Encrypted";
    private static final String XENCRPYTED_MAIL_VALUE = "by S/Notify at {0}";
    private static final String SETTINGS_STRING_EXISTS = ".exists";
    private static final String SETTINGS_STRING_PAGES = ".pages";
    private static final String SETTINGS_STRING_PAGE = ".page.";
    private static final Logger log = LoggerFactory.getLogger(Mailer.class);
    private final Provider provider;
    private final KeyStore keyStore;
    private final String hostName;
    private final BandanaManager settings = (BandanaManager)ComponentLocator.getComponent(BandanaManager.class);

    private static final String loadString(UserPreferences prefs, String key) {
        if (prefs == null || key == null) {
            return null;
        }
        if (!prefs.getBoolean(key + SETTINGS_STRING_EXISTS)) {
            return null;
        }
        int pages = (int)prefs.getLong(key + SETTINGS_STRING_PAGES);
        StringBuilder builder = new StringBuilder(255 * pages);
        for (int i = 0; i < pages; ++i) {
            String page = prefs.getString(key + SETTINGS_STRING_PAGE + i);
            builder.append(page);
        }
        return builder.toString();
    }

    private static X509Certificate getUserCertForEmail(String email) throws CertificateException {
        UserAccessor userAccessor = (UserAccessor)ComponentLocator.getComponent(UserAccessor.class);
        SearchResult users = userAccessor.getUsersByEmail(email);
        for (User user : users.pager()) {
            ConfluenceUserPreferences prefs = userAccessor.getConfluenceUserPreferences(user);
            String base64Cert = Mailer.loadString(prefs.getWrappedPreferences(), EMAIL_CERT_PROP);
            if (base64Cert == null || base64Cert.isEmpty()) continue;
            byte[] cert = Base64.decodeBase64((byte[])base64Cert.getBytes(UTF8_CHARSET));
            log.debug("Using certificate of user {} for encrypting email to \"{}\".", (Object)user.getFullName(), (Object)email);
            X509Certificate certificate = CertUtil.createCertificate(cert);
            certificate.checkValidity();
            return certificate;
        }
        return null;
    }

    private static X509Certificate getKeystoreCertForEmail(String email, KeyStore keyStore) {
        return CertUtil.getCertForEmail(keyStore, email);
    }

    private static KeyStore loadKeyStore(String location, String password, Provider provider) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        if (location == null || location.isEmpty()) {
            log.debug("No location given. No keystore loaded.");
            return null;
        }
        if (provider == null || location.isEmpty()) {
            log.debug("No provider given. No keystore loaded.");
            return null;
        }
        KeyStore ks = KeyStore.getInstance(BOUNCY_CASTLE_KEYSTORE_TYPE, provider);
        log.debug("Loading keystore from location: {}", (Object)location);
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(location));){
            ks.load(in, password == null ? null : password.toCharArray());
        }
        log.debug("Loaded keystore from location \"{}\" succesfully.", (Object)location);
        return ks;
    }

    public Mailer() {
        this.provider = SecurityUtil.getProvider();
        this.keyStore = this.loadKeyStore();
        this.hostName = this.getHostName();
    }

    private KeyStore loadKeyStore() {
        String location = this.getStringValue(KEYSTORE_LOCATION_PROP);
        String password = this.getStringValue(KEYSTORE_PASSWORD_PROP);
        try {
            return Mailer.loadKeyStore(location, password, this.provider);
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            log.error("Could not load keystore from location: " + location, (Throwable)e);
            return null;
        }
    }

    public MessageAndAddress[] getMessages(Session session, Message message, Address[] addresses) {
        boolean disabled = this.getBoolValue(DISABLE_SNOTIFY_PROP);
        if (disabled) {
            MessageAndAddress[] result = new MessageAndAddress[addresses.length];
            for (int i = 0; i < result.length; ++i) {
                result[i] = new MessageAndAddress(message, addresses[i]);
            }
            return result;
        }
        EncryptionFailureOption encryptionFailure = this.getEncryptionFailureOption();
        CertificateLocationPriorityOption locationPriority = this.getCertificateLocationPriorityOption();
        boolean frozen = this.getBoolValue(FREEZE_SNOTIFY_PROP);
        boolean licenseErrorReported = false;
        ArrayList<MessageAndAddress> result = new ArrayList<MessageAndAddress>();
        for (Address address : addresses) {
            MessageAndAddress messageAndAddress = new MessageAndAddress();
            messageAndAddress.address = address;
            messageAndAddress.message = message;
            boolean successfulEncryption = false;
            if (frozen) {
                if (!licenseErrorReported) {
                    log.error("Could not encrypt email due to licensing error in S/Notify. Handling unencrypted email as: " + (Object)((Object)encryptionFailure));
                    licenseErrorReported = true;
                }
            } else if (message instanceof MimeMessage) {
                X509Certificate cert = this.getCertificate(address, locationPriority);
                if (cert != null) {
                    try {
                        messageAndAddress.message = this.encrypt(session, cert, (MimeMessage)message, address);
                        successfulEncryption = true;
                    }
                    catch (Exception e) {
                        log.error("Error encrypting email for address " + address + ": " + e.getMessage(), (Throwable)e);
                    }
                } else if (encryptionFailure != EncryptionFailureOption.ALLOW) {
                    log.warn("No public certificate found to encrypt email for: {}", (Object)address);
                }
            } else {
                log.error("Can't encrypt email, because it is not a MIME Email but: " + message.getClass().getCanonicalName());
            }
            if (successfulEncryption || encryptionFailure == EncryptionFailureOption.ALLOW) {
                result.add(messageAndAddress);
                continue;
            }
            if (encryptionFailure != EncryptionFailureOption.REPORT) continue;
            try {
                messageAndAddress.message = this.createInfoMessage(session, message);
                result.add(messageAndAddress);
            }
            catch (MessagingException e) {
                log.error("Error creating info email for email address " + address + ": " + e.getMessage(), (Throwable)e);
            }
        }
        return result.toArray(new MessageAndAddress[result.size()]);
    }

    private X509Certificate getCertificate(Address address, CertificateLocationPriorityOption locationPriority) {
        String email = address.toString();
        X509Certificate cert = null;
        if (locationPriority == CertificateLocationPriorityOption.KEYSTORE) {
            cert = this.getKeystoreCert(email);
        }
        if (cert == null) {
            cert = this.getUserCert(email);
        }
        if (cert == null && locationPriority != CertificateLocationPriorityOption.KEYSTORE) {
            cert = this.getKeystoreCert(email);
        }
        return cert;
    }

    private X509Certificate getKeystoreCert(String email) {
        return Mailer.getKeystoreCertForEmail(email, this.keyStore);
    }

    private X509Certificate getUserCert(String email) {
        try {
            return Mailer.getUserCertForEmail(email);
        }
        catch (CertificateException e) {
            log.error("Error getting user certificate for email address " + email + ": " + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private EncryptionFailureOption getEncryptionFailureOption() {
        EncryptionFailureOption encryptionFailure = EncryptionFailureOption.ALLOW;
        String encryptionFailureProp = this.getStringValue(EMAIL_ENCRYPTION_FAILURE_PROP);
        if (encryptionFailureProp != null) {
            try {
                encryptionFailure = EncryptionFailureOption.valueOf(encryptionFailureProp);
            }
            catch (IllegalArgumentException e) {
                log.warn("Unknwon value for 'Encryption Failure' found. Value found was '" + encryptionFailureProp + "'. Default 'ALLOW' was used. Please go to S/Notify admin settings and select proper value.", (Throwable)e);
            }
        }
        return encryptionFailure;
    }

    private CertificateLocationPriorityOption getCertificateLocationPriorityOption() {
        CertificateLocationPriorityOption certificateLocationPriority = CertificateLocationPriorityOption.KEYSTORE;
        String encryptionFailureProp = this.getStringValue(CERTIFICATE_LOCATION_PRIORITY_PROP);
        if (encryptionFailureProp != null) {
            try {
                certificateLocationPriority = CertificateLocationPriorityOption.valueOf(encryptionFailureProp);
            }
            catch (IllegalArgumentException e) {
                log.warn("Unknwon value for 'Priority' found. Value found was '" + encryptionFailureProp + "'. Default 'KEYSTORE' was used. Please go to S/Notify admin settings and select proper value.", (Throwable)e);
            }
        }
        return certificateLocationPriority;
    }

    private Message encrypt(Session session, X509Certificate cert, MimeMessage origMsg, Address address) throws MessagingException, SMIMEException, IOException, CertificateEncodingException, CMSException {
        OutputEncryptor encryptor;
        log.debug("Encrypting email to \"{}\" with certificate: {}", (Object)address, (Object)cert);
        if (log.isDebugEnabled()) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            origMsg.writeTo((OutputStream)baos);
            log.debug("Original email:\n{}\n", (Object)baos.toString());
        }
        SMIMEEnvelopedGenerator gen = new SMIMEEnvelopedGenerator();
        JceKeyTransRecipientInfoGenerator infoGenerator = new JceKeyTransRecipientInfoGenerator(cert);
        gen.addRecipientInfoGenerator((RecipientInfoGenerator)infoGenerator);
        try {
            log.debug("Using AES256_CBC algorithm for encryption.");
            encryptor = new JceCMSContentEncryptorBuilder(CMSAlgorithm.AES256_CBC).setProvider(this.provider).build();
        }
        catch (CMSException e) {
            if (e.getMessage().contains("Illegal key size")) {
                log.debug(e.getMessage(), (Throwable)e);
                log.warn("\"Java Cryptography Extension (JCE) Unlimited Strength\" is not installed on this machine. AES256_CBC encryption standard can not be used. Using fallback AES128_CBC encryption algorithm.");
                encryptor = new JceCMSContentEncryptorBuilder(CMSAlgorithm.AES128_CBC).setProvider(this.provider).build();
            }
            throw e;
        }
        MimeBodyPart encryptedBody = gen.generate(origMsg, encryptor);
        if (log.isDebugEnabled()) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            encryptedBody.writeTo((OutputStream)baos);
            log.debug("Encrypted body:\n{}\n", (Object)baos.toString());
        }
        MimeMessage msg = new MimeMessage(session);
        Enumeration copyHeaders = origMsg.getNonMatchingHeaderLines(SPECIAL_HEADERS);
        while (copyHeaders.hasMoreElements()) {
            msg.addHeaderLine((String)copyHeaders.nextElement());
        }
        msg.addHeader(XENCRPYTED_MAIL_PROPERTY, MessageFormat.format(XENCRPYTED_MAIL_VALUE, this.hostName));
        msg.setContent(encryptedBody.getContent(), encryptedBody.getContentType());
        msg.saveChanges();
        if (log.isDebugEnabled()) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            msg.writeTo((OutputStream)baos);
            log.debug("Final email:\n{}\n", (Object)baos.toString());
        }
        log.debug("Encrypting email to \"{}\" succesfully finished.", (Object)address);
        return msg;
    }

    private Message createInfoMessage(Session session, Message origMsg) throws MessagingException {
        log.debug("Creating info message.");
        MimeMessage message = new MimeMessage(session);
        Enumeration headers = origMsg.getAllHeaders();
        log.debug("Copying headers from original message.");
        while (headers.hasMoreElements()) {
            Header header = (Header)headers.nextElement();
            message.addHeader(header.getName(), header.getValue());
            log.debug(header.toString());
        }
        log.debug("Copying headers from original message finished.");
        message.setText(INFO_MESSAGE, UTF8);
        return message;
    }

    private String getHostName() {
        try {
            String result = InetAddress.getLocalHost().getHostName();
            if (result != null && !result.isEmpty()) {
                return result;
            }
        }
        catch (UnknownHostException e) {
            log.debug("Could not retrieve host name.", (Throwable)e);
        }
        try {
            String host = System.getenv("COMPUTERNAME");
            if (host != null) {
                return host;
            }
            host = System.getenv("HOSTNAME");
            if (host != null) {
                return host;
            }
        }
        catch (SecurityException e) {
            log.debug("Could not retrieve host name from environment properties.", (Throwable)e);
        }
        return "<Unknown>";
    }

    private String getStringValue(String key) {
        return (String)this.settings.getValue((BandanaContext)ConfluenceBandanaContext.GLOBAL_CONTEXT, key);
    }

    private boolean getBoolValue(String key) {
        Boolean bool = (Boolean)this.settings.getValue((BandanaContext)ConfluenceBandanaContext.GLOBAL_CONTEXT, key);
        return bool != null && bool != false;
    }

    public static enum CertificateLocationPriorityOption {
        KEYSTORE,
        USERSETTINGS;

    }

    public static enum EncryptionFailureOption {
        ALLOW,
        REPORT,
        BLOCK;

    }
}

