/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.confluence.mailer.security;

import java.io.ByteArrayInputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertUtil {
    public static final String X509_FACTORY_KEY = "X.509";
    private static final Logger log = LoggerFactory.getLogger(CertUtil.class);

    public static X509Certificate createCertificate(byte[] content) throws CertificateException {
        ByteArrayInputStream is = new ByteArrayInputStream(content);
        CertificateFactory fact = CertificateFactory.getInstance(X509_FACTORY_KEY);
        return (X509Certificate)fact.generateCertificate(is);
    }

    public static final X509Certificate getCertForEmail(KeyStore keyStore, String email) {
        Enumeration<String> aliases;
        if (keyStore == null || email == null) {
            return null;
        }
        try {
            aliases = keyStore.aliases();
        }
        catch (KeyStoreException e) {
            log.error("Error getting aliases from KeyStore: " + keyStore, (Throwable)e);
            return null;
        }
        X509Certificate chosenCertificate = null;
        boolean isMatchedCertValid = false;
        while (aliases.hasMoreElements()) {
            String alias = aliases.nextElement();
            X509Certificate certificate = CertUtil.getCertForAlias(keyStore, alias);
            if (!CertUtil.isCertForEmail(certificate, email)) continue;
            try {
                certificate.checkValidity();
                log.debug("Found valid certificate for email \"{}\": {}", (Object)email, (Object)certificate);
                if (isMatchedCertValid && chosenCertificate != null) {
                    if (!certificate.getNotAfter().after(chosenCertificate.getNotAfter())) continue;
                    chosenCertificate = certificate;
                    continue;
                }
                chosenCertificate = certificate;
                isMatchedCertValid = true;
            }
            catch (CertificateExpiredException | CertificateNotYetValidException e) {
                log.debug("Found invalid certificate for email \"{}\": {}", (Object)email, (Object)certificate);
                if (chosenCertificate == null) {
                    chosenCertificate = certificate;
                    continue;
                }
                if (isMatchedCertValid || !certificate.getNotAfter().after(chosenCertificate.getNotAfter())) continue;
                chosenCertificate = certificate;
            }
        }
        log.debug("Found certificate for email \"{}\": {}", (Object)email, chosenCertificate);
        return chosenCertificate;
    }

    private static final X509Certificate getCertForAlias(KeyStore keyStore, String alias) {
        Certificate cert;
        try {
            cert = keyStore.getCertificate(alias);
        }
        catch (KeyStoreException e) {
            log.error("Error getting certificate for alias: " + alias, (Throwable)e);
            return null;
        }
        if (!(cert instanceof X509Certificate)) {
            log.debug("Found certificate for alias \"{}\" is not a X509Certificate. It will be skipped. Found certificate: {}", (Object)alias, (Object)cert);
            return null;
        }
        return (X509Certificate)cert;
    }

    private static final boolean isCertForEmail(X509Certificate certificate, String email) {
        X500Name subject;
        if (certificate == null || email == null) {
            return false;
        }
        try {
            subject = CertUtil.getSubject(certificate);
        }
        catch (CertificateEncodingException e) {
            log.error("Error extracting the information from certificate: " + certificate, (Throwable)e);
            return false;
        }
        boolean emailMatches = false;
        String foundEmail = CertUtil.getRDNValue(subject, BCStyle.E);
        if (email.equalsIgnoreCase(foundEmail)) {
            emailMatches = true;
        } else {
            Collection<List<?>> names = null;
            try {
                names = certificate.getSubjectAlternativeNames();
            }
            catch (CertificateParsingException e) {
                log.error("Subject Alternative Names Extension could not be parsed from certificate: " + certificate, (Throwable)e);
            }
            if (names != null) {
                for (List<?> item : names) {
                    int type = (Integer)item.get(0);
                    Object value = item.get(1);
                    if (type != 1 || !email.equalsIgnoreCase(value.toString())) continue;
                    emailMatches = true;
                    break;
                }
            }
        }
        return emailMatches;
    }

    public static final X500Name getIssuer(X509Certificate certificate) throws CertificateEncodingException {
        JcaX509CertificateHolder holder = new JcaX509CertificateHolder(certificate);
        return holder.getIssuer();
    }

    public static final X500Name getSubject(X509Certificate certificate) throws CertificateEncodingException {
        JcaX509CertificateHolder holder = new JcaX509CertificateHolder(certificate);
        return holder.getSubject();
    }

    public static final String getRDNValue(X500Name name, ASN1ObjectIdentifier identifier) {
        RDN[] rdns = name.getRDNs(identifier);
        if (rdns.length == 0) {
            return null;
        }
        return rdns[0].getFirst().getValue().toString();
    }
}

