/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.confluence.mailer.security;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.KeyStore;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.util.Enumeration;
import javax.mail.Address;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import net.savignano.snotify.confluence.mailer.enums.EncryptionKeySource;
import net.savignano.snotify.confluence.mailer.security.AbstractMailEncryptor;
import net.savignano.snotify.confluence.mailer.util.CertUtil;
import net.savignano.snotify.confluence.mailer.util.PropertiesUtil;
import net.savignano.thirdparty.org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import net.savignano.thirdparty.org.bouncycastle.cms.CMSAlgorithm;
import net.savignano.thirdparty.org.bouncycastle.cms.CMSException;
import net.savignano.thirdparty.org.bouncycastle.cms.bc.BcCMSContentEncryptorBuilder;
import net.savignano.thirdparty.org.bouncycastle.cms.bc.BcRSAKeyTransRecipientInfoGenerator;
import net.savignano.thirdparty.org.bouncycastle.mail.smime.SMIMEEnvelopedGenerator;
import net.savignano.thirdparty.org.bouncycastle.mail.smime.SMIMEException;
import net.savignano.thirdparty.org.bouncycastle.operator.OutputEncryptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmimeMailEncryptor
extends AbstractMailEncryptor<X509Certificate> {
    private static final Logger log = LoggerFactory.getLogger(SmimeMailEncryptor.class);
    private static final String XENCRPYTED_MAIL_VALUE = "by S/Notify for Confluence at {0} using S/MIME encryption with {1}";
    private static final String[] SPECIAL_HEADERS = new String[]{"MIME-Version", "Content-Type", "Content-Transfer-Encoding"};
    private KeyStore keyStore;

    public SmimeMailEncryptor(Session session, MimeMessage message, Address address) {
        super(session, message, address);
    }

    @Override
    protected X509Certificate getRepositoryPublicKey() {
        if (this.getKeyStore() == null) {
            log.debug("No key store specified. Can't get certificate from key store.");
            return null;
        }
        return CertUtil.getCertForEmail(this.getKeyStore(), this.getAddress().toString());
    }

    @Override
    protected X509Certificate getUserPublicKey() {
        try {
            byte[] cert = PropertiesUtil.getUserProps().getBytes("net.savignano.snotify.email.smime.cert", this.getUser());
            if (cert != null) {
                log.debug("Using certificate of user {} for encrypting email to \"{}\".", (Object)this.getUser(), (Object)this.getAddress());
                X509Certificate certificate = CertUtil.createCertificate(cert);
                return certificate;
            }
        }
        catch (CertificateException e) {
            log.error("Error retrieving certificate for user " + this.getUser() + ": " + e.getMessage(), (Throwable)e);
            return null;
        }
        log.debug("User {} has no public certificate stored.", (Object)this.getUser());
        return null;
    }

    @Override
    protected boolean isPublicKeyValid(X509Certificate key) {
        if (key == null) {
            log.debug("Certificate is null, considered invalid.");
            return false;
        }
        try {
            key.checkValidity();
        }
        catch (CertificateExpiredException | CertificateNotYetValidException e) {
            log.debug("Certificate with serial number {} is invalid because it expired at: ", (Object)key.getSerialNumber(), (Object)key.getNotAfter());
            return false;
        }
        EncryptionKeySource keySource = PropertiesUtil.getUserProps().getEnum("net.savignano.snotify.email.pgp.keySource", EncryptionKeySource.class, this.getUser());
        boolean allowCustomKey = PropertiesUtil.getAppProps().getBoolean("net.savignano.snotify.pgp.key.allowUserOverwrite", true);
        if (keySource == EncryptionKeySource.USER && !allowCustomKey) {
            log.debug("Certificate with serial number {} is invalid because it was uploaded by a user, but this is not allowed.", (Object)key.getSerialNumber());
            return false;
        }
        log.debug("Certificate with serial number {} is valid.", (Object)key.getSerialNumber());
        return true;
    }

    @Override
    protected void storePublicKey(X509Certificate key) throws IOException {
        byte[] encoded = null;
        if (key != null) {
            try {
                encoded = key.getEncoded();
            }
            catch (CertificateEncodingException e) {
                throw new IOException(e.getMessage(), e);
            }
        }
        PropertiesUtil.getUserProps().setBytes("net.savignano.snotify.email.smime.cert", encoded, this.getUser());
        PropertiesUtil.getUserProps().setLong("net.savignano.snotify.email.smime.timeStamp", System.currentTimeMillis(), this.getUser());
        PropertiesUtil.getUserProps().setEnum("net.savignano.snotify.email.smime.keySource", EncryptionKeySource.KEYSTORE, this.getUser());
    }

    @Override
    public MimeMessage getEncryptedMessage() throws MessagingException, IOException {
        if (this.getPublicKey() == null) {
            throw new MessagingException("No certificate found for address: " + this.getAddress());
        }
        return this.encrypt();
    }

    @Override
    protected MimeMessage encrypt() throws IOException, MessagingException {
        MimeBodyPart encryptedBody;
        String usedEncryptionAlgorithm;
        log.debug("Encrypting email to \"{}\" with certificate: {}", (Object)this.getAddress(), this.getPublicKey());
        if (log.isTraceEnabled()) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            this.getMessage().writeTo((OutputStream)baos);
            log.trace("Original email:\n{}\n", (Object)baos.toString());
        }
        try {
            OutputEncryptor encryptor;
            SMIMEEnvelopedGenerator gen = new SMIMEEnvelopedGenerator();
            BcRSAKeyTransRecipientInfoGenerator infoGenerator = new BcRSAKeyTransRecipientInfoGenerator(new JcaX509CertificateHolder((X509Certificate)this.getPublicKey()));
            gen.addRecipientInfoGenerator(infoGenerator);
            try {
                log.debug("Using AES256_CBC algorithm for encryption.");
                usedEncryptionAlgorithm = "AES256_CBC";
                encryptor = new BcCMSContentEncryptorBuilder(CMSAlgorithm.AES256_CBC).build();
            }
            catch (CMSException e) {
                if (e.getMessage().contains("Illegal key size")) {
                    log.debug(e.getMessage(), (Throwable)e);
                    log.warn("\"Java Cryptography Extension (JCE) Unlimited Strength\" is not installed on this machine. AES256_CBC encryption standard can not be used. Using fallback AES128_CBC encryption algorithm.");
                    usedEncryptionAlgorithm = "AES128_CBC";
                    encryptor = new BcCMSContentEncryptorBuilder(CMSAlgorithm.AES128_CBC).build();
                }
                throw e;
            }
            encryptedBody = gen.generate(this.getMessage(), encryptor);
            if (log.isTraceEnabled()) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                encryptedBody.writeTo((OutputStream)baos);
                log.trace("Encrypted body:\n{}\n", (Object)baos.toString());
            }
        }
        catch (CertificateEncodingException | CMSException | SMIMEException e) {
            throw new MessagingException(e.getLocalizedMessage(), e);
        }
        MimeMessage msg = new MimeMessage(this.getSession());
        Enumeration copyHeaders = this.getMessage().getNonMatchingHeaderLines(SPECIAL_HEADERS);
        while (copyHeaders.hasMoreElements()) {
            msg.addHeaderLine((String)copyHeaders.nextElement());
        }
        msg.addHeader("X-Encrypted", MessageFormat.format(XENCRPYTED_MAIL_VALUE, this.getHostName(), usedEncryptionAlgorithm));
        msg.setContent(encryptedBody.getContent(), encryptedBody.getContentType());
        msg.saveChanges();
        if (log.isTraceEnabled()) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            msg.writeTo((OutputStream)baos);
            log.trace("Final email:\n{}\n", (Object)baos.toString());
        }
        log.debug("Encrypting email to \"{}\" succesfully finished.", (Object)this.getAddress());
        return msg;
    }

    public KeyStore getKeyStore() {
        return this.keyStore;
    }

    public void setKeyStore(KeyStore keyStore) {
        this.keyStore = keyStore;
    }

    @Override
    protected AbstractMailEncryptor.EncryptorPropertiesData getPropertiesData() {
        AbstractMailEncryptor.EncryptorPropertiesData data = new AbstractMailEncryptor.EncryptorPropertiesData();
        data.allowCustomUserKey = PropertiesUtil.getAppProps().getBoolean("net.savignano.snotify.smime.cert.allowUserOverwrite", true);
        data.expireTimeStamp = PropertiesUtil.getAppProps().getLong("net.savignano.snotify.mailer.expireKeys.timeStamp");
        data.keySource = PropertiesUtil.getUserProps().getEnum("net.savignano.snotify.email.smime.keySource", EncryptionKeySource.class, this.getUser());
        data.timeStamp = PropertiesUtil.getUserProps().getLong("net.savignano.snotify.email.smime.timeStamp", this.getUser());
        return data;
    }
}

