/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.asn1;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Encodable;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1EncodableVector;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1OutputStream;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Primitive;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1SequenceParser;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Set;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1TaggedObject;
import net.savignano.thirdparty.org.bouncycastle.asn1.BERSequence;
import net.savignano.thirdparty.org.bouncycastle.asn1.BERTaggedObject;
import net.savignano.thirdparty.org.bouncycastle.asn1.DERSequence;
import net.savignano.thirdparty.org.bouncycastle.asn1.DLSequence;
import net.savignano.thirdparty.org.bouncycastle.util.Arrays;
import net.savignano.thirdparty.org.bouncycastle.util.Iterable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ASN1Sequence
extends ASN1Primitive
implements Iterable<ASN1Encodable> {
    protected Vector seq = new Vector();

    public static ASN1Sequence getInstance(Object obj) {
        ASN1Primitive primitive;
        if (obj == null || obj instanceof ASN1Sequence) {
            return (ASN1Sequence)obj;
        }
        if (obj instanceof ASN1SequenceParser) {
            return ASN1Sequence.getInstance(((ASN1SequenceParser)obj).toASN1Primitive());
        }
        if (obj instanceof byte[]) {
            try {
                return ASN1Sequence.getInstance(ASN1Sequence.fromByteArray((byte[])obj));
            }
            catch (IOException e) {
                throw new IllegalArgumentException("failed to construct sequence from byte[]: " + e.getMessage());
            }
        }
        if (obj instanceof ASN1Encodable && (primitive = ((ASN1Encodable)obj).toASN1Primitive()) instanceof ASN1Sequence) {
            return (ASN1Sequence)primitive;
        }
        throw new IllegalArgumentException("unknown object in getInstance: " + obj.getClass().getName());
    }

    public static ASN1Sequence getInstance(ASN1TaggedObject obj, boolean explicit) {
        if (explicit) {
            if (!obj.isExplicit()) {
                throw new IllegalArgumentException("object implicit - explicit expected.");
            }
            return ASN1Sequence.getInstance(obj.getObject().toASN1Primitive());
        }
        ASN1Primitive o = obj.getObject();
        if (obj.isExplicit()) {
            if (obj instanceof BERTaggedObject) {
                return new BERSequence(o);
            }
            return new DLSequence(o);
        }
        if (o instanceof ASN1Sequence) {
            return (ASN1Sequence)o;
        }
        throw new IllegalArgumentException("unknown object in getInstance: " + obj.getClass().getName());
    }

    protected ASN1Sequence() {
    }

    protected ASN1Sequence(ASN1Encodable obj) {
        this.seq.addElement(obj);
    }

    protected ASN1Sequence(ASN1EncodableVector v) {
        for (int i = 0; i != v.size(); ++i) {
            this.seq.addElement(v.get(i));
        }
    }

    protected ASN1Sequence(ASN1Encodable[] array) {
        for (int i = 0; i != array.length; ++i) {
            this.seq.addElement(array[i]);
        }
    }

    public ASN1Encodable[] toArray() {
        ASN1Encodable[] values = new ASN1Encodable[this.size()];
        for (int i = 0; i != this.size(); ++i) {
            values[i] = this.getObjectAt(i);
        }
        return values;
    }

    public Enumeration getObjects() {
        return this.seq.elements();
    }

    public ASN1SequenceParser parser() {
        final ASN1Sequence outer = this;
        return new ASN1SequenceParser(){
            private final int max;
            private int index;
            {
                this.max = ASN1Sequence.this.size();
            }

            public ASN1Encodable readObject() throws IOException {
                ASN1Encodable obj;
                if (this.index == this.max) {
                    return null;
                }
                if ((obj = ASN1Sequence.this.getObjectAt(this.index++)) instanceof ASN1Sequence) {
                    return ((ASN1Sequence)obj).parser();
                }
                if (obj instanceof ASN1Set) {
                    return ((ASN1Set)obj).parser();
                }
                return obj;
            }

            public ASN1Primitive getLoadedObject() {
                return outer;
            }

            public ASN1Primitive toASN1Primitive() {
                return outer;
            }
        };
    }

    public ASN1Encodable getObjectAt(int index) {
        return (ASN1Encodable)this.seq.elementAt(index);
    }

    public int size() {
        return this.seq.size();
    }

    @Override
    public int hashCode() {
        Enumeration e = this.getObjects();
        int hashCode = this.size();
        while (e.hasMoreElements()) {
            ASN1Encodable o = this.getNext(e);
            hashCode *= 17;
            hashCode ^= o.hashCode();
        }
        return hashCode;
    }

    @Override
    boolean asn1Equals(ASN1Primitive o) {
        if (!(o instanceof ASN1Sequence)) {
            return false;
        }
        ASN1Sequence other = (ASN1Sequence)o;
        if (this.size() != other.size()) {
            return false;
        }
        Enumeration s1 = this.getObjects();
        Enumeration s2 = other.getObjects();
        while (s1.hasMoreElements()) {
            ASN1Primitive o2;
            ASN1Encodable obj1 = this.getNext(s1);
            ASN1Encodable obj2 = this.getNext(s2);
            ASN1Primitive o1 = obj1.toASN1Primitive();
            if (o1 == (o2 = obj2.toASN1Primitive()) || o1.equals(o2)) continue;
            return false;
        }
        return true;
    }

    private ASN1Encodable getNext(Enumeration e) {
        ASN1Encodable encObj = (ASN1Encodable)e.nextElement();
        return encObj;
    }

    @Override
    ASN1Primitive toDERObject() {
        DERSequence derSeq = new DERSequence();
        derSeq.seq = this.seq;
        return derSeq;
    }

    @Override
    ASN1Primitive toDLObject() {
        DLSequence dlSeq = new DLSequence();
        dlSeq.seq = this.seq;
        return dlSeq;
    }

    @Override
    boolean isConstructed() {
        return true;
    }

    @Override
    abstract void encode(ASN1OutputStream var1) throws IOException;

    public String toString() {
        return this.seq.toString();
    }

    @Override
    public Iterator<ASN1Encodable> iterator() {
        return new Arrays.Iterator<ASN1Encodable>(this.toArray());
    }
}

