/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.bcpg;

import java.io.IOException;
import net.savignano.thirdparty.org.bouncycastle.bcpg.BCPGInputStream;
import net.savignano.thirdparty.org.bouncycastle.bcpg.InputStreamPacket;
import net.savignano.thirdparty.org.bouncycastle.util.Arrays;
import net.savignano.thirdparty.org.bouncycastle.util.Strings;

public class LiteralDataPacket
extends InputStreamPacket {
    int format;
    byte[] fileName;
    long modDate;

    LiteralDataPacket(BCPGInputStream in) throws IOException {
        super(in);
        this.format = in.read();
        int l = in.read();
        this.fileName = new byte[l];
        for (int i = 0; i != this.fileName.length; ++i) {
            this.fileName[i] = (byte)in.read();
        }
        this.modDate = (long)in.read() << 24 | (long)(in.read() << 16) | (long)(in.read() << 8) | (long)in.read();
    }

    public int getFormat() {
        return this.format;
    }

    public long getModificationTime() {
        return this.modDate * 1000L;
    }

    public String getFileName() {
        return Strings.fromUTF8ByteArray(this.fileName);
    }

    public byte[] getRawFileName() {
        return Arrays.clone(this.fileName);
    }
}

