/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.openpgp;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import net.savignano.thirdparty.org.bouncycastle.asn1.x9.ECNamedCurveTable;
import net.savignano.thirdparty.org.bouncycastle.bcpg.BCPGInputStream;
import net.savignano.thirdparty.org.bouncycastle.bcpg.BCPGObject;
import net.savignano.thirdparty.org.bouncycastle.bcpg.BCPGOutputStream;
import net.savignano.thirdparty.org.bouncycastle.bcpg.ContainedPacket;
import net.savignano.thirdparty.org.bouncycastle.bcpg.DSASecretBCPGKey;
import net.savignano.thirdparty.org.bouncycastle.bcpg.ECDSAPublicBCPGKey;
import net.savignano.thirdparty.org.bouncycastle.bcpg.ECSecretBCPGKey;
import net.savignano.thirdparty.org.bouncycastle.bcpg.ElGamalSecretBCPGKey;
import net.savignano.thirdparty.org.bouncycastle.bcpg.PublicKeyPacket;
import net.savignano.thirdparty.org.bouncycastle.bcpg.RSASecretBCPGKey;
import net.savignano.thirdparty.org.bouncycastle.bcpg.S2K;
import net.savignano.thirdparty.org.bouncycastle.bcpg.SecretKeyPacket;
import net.savignano.thirdparty.org.bouncycastle.bcpg.SecretSubkeyPacket;
import net.savignano.thirdparty.org.bouncycastle.bcpg.UserAttributePacket;
import net.savignano.thirdparty.org.bouncycastle.bcpg.UserIDPacket;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPException;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPKeyPair;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPPrivateKey;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPPublicKey;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPSignature;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPSignatureGenerator;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPSignatureSubpacketVector;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPUserAttributeSubpacketVector;
import net.savignano.thirdparty.org.bouncycastle.openpgp.SXprUtils;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.PBEProtectionRemoverFactory;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.PBESecretKeyDecryptor;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.PBESecretKeyEncryptor;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.PGPContentSignerBuilder;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.PGPDigestCalculator;

public class PGPSecretKey {
    SecretKeyPacket secret;
    PGPPublicKey pub;

    PGPSecretKey(SecretKeyPacket secret, PGPPublicKey pub) {
        this.secret = secret;
        this.pub = pub;
    }

    PGPSecretKey(PGPPrivateKey privKey, PGPPublicKey pubKey, PGPDigestCalculator checksumCalculator, PBESecretKeyEncryptor keyEncryptor) throws PGPException {
        this(privKey, pubKey, checksumCalculator, false, keyEncryptor);
    }

    public PGPSecretKey(PGPPrivateKey privKey, PGPPublicKey pubKey, PGPDigestCalculator checksumCalculator, boolean isMasterKey, PBESecretKeyEncryptor keyEncryptor) throws PGPException {
        this.pub = pubKey;
        this.secret = PGPSecretKey.buildSecretKeyPacket(isMasterKey, privKey, pubKey, keyEncryptor, checksumCalculator);
    }

    private static SecretKeyPacket buildSecretKeyPacket(boolean isMasterKey, PGPPrivateKey privKey, PGPPublicKey pubKey, PBESecretKeyEncryptor keyEncryptor, PGPDigestCalculator checksumCalculator) throws PGPException {
        BCPGObject secKey = (BCPGObject)((Object)privKey.getPrivateKeyDataPacket());
        if (secKey == null) {
            if (isMasterKey) {
                return new SecretKeyPacket(pubKey.publicPk, 0, null, null, new byte[0]);
            }
            return new SecretSubkeyPacket(pubKey.publicPk, 0, null, null, new byte[0]);
        }
        try {
            int encAlgorithm;
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            BCPGOutputStream pOut = new BCPGOutputStream(bOut);
            pOut.writeObject(secKey);
            byte[] keyData = bOut.toByteArray();
            pOut.write(PGPSecretKey.checksum(checksumCalculator, keyData, keyData.length));
            int n = encAlgorithm = keyEncryptor != null ? keyEncryptor.getAlgorithm() : 0;
            if (encAlgorithm != 0) {
                int s2kUsage;
                keyData = bOut.toByteArray();
                byte[] encData = keyEncryptor.encryptKeyData(keyData, 0, keyData.length);
                byte[] iv = keyEncryptor.getCipherIV();
                S2K s2k = keyEncryptor.getS2K();
                if (checksumCalculator != null) {
                    if (checksumCalculator.getAlgorithm() != 2) {
                        throw new PGPException("only SHA1 supported for key checksum calculations.");
                    }
                    s2kUsage = 254;
                } else {
                    s2kUsage = 255;
                }
                if (isMasterKey) {
                    return new SecretKeyPacket(pubKey.publicPk, encAlgorithm, s2kUsage, s2k, iv, encData);
                }
                return new SecretSubkeyPacket(pubKey.publicPk, encAlgorithm, s2kUsage, s2k, iv, encData);
            }
            if (isMasterKey) {
                return new SecretKeyPacket(pubKey.publicPk, encAlgorithm, null, null, bOut.toByteArray());
            }
            return new SecretSubkeyPacket(pubKey.publicPk, encAlgorithm, null, null, bOut.toByteArray());
        }
        catch (PGPException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PGPException("Exception encrypting key", e);
        }
    }

    public PGPSecretKey(int certificationLevel, PGPKeyPair keyPair, String id, PGPSignatureSubpacketVector hashedPcks, PGPSignatureSubpacketVector unhashedPcks, PGPContentSignerBuilder certificationSignerBuilder, PBESecretKeyEncryptor keyEncryptor) throws PGPException {
        this(certificationLevel, keyPair, id, null, hashedPcks, unhashedPcks, certificationSignerBuilder, keyEncryptor);
    }

    public PGPSecretKey(int certificationLevel, PGPKeyPair keyPair, String id, PGPDigestCalculator checksumCalculator, PGPSignatureSubpacketVector hashedPcks, PGPSignatureSubpacketVector unhashedPcks, PGPContentSignerBuilder certificationSignerBuilder, PBESecretKeyEncryptor keyEncryptor) throws PGPException {
        this(keyPair.getPrivateKey(), PGPSecretKey.certifiedPublicKey(certificationLevel, keyPair, id, hashedPcks, unhashedPcks, certificationSignerBuilder), checksumCalculator, true, keyEncryptor);
    }

    private static PGPPublicKey certifiedPublicKey(int certificationLevel, PGPKeyPair keyPair, String id, PGPSignatureSubpacketVector hashedPcks, PGPSignatureSubpacketVector unhashedPcks, PGPContentSignerBuilder certificationSignerBuilder) throws PGPException {
        PGPSignatureGenerator sGen;
        try {
            sGen = new PGPSignatureGenerator(certificationSignerBuilder);
        }
        catch (Exception e) {
            throw new PGPException("creating signature generator: " + e, e);
        }
        sGen.init(certificationLevel, keyPair.getPrivateKey());
        sGen.setHashedSubpackets(hashedPcks);
        sGen.setUnhashedSubpackets(unhashedPcks);
        try {
            PGPSignature certification = sGen.generateCertification(id, keyPair.getPublicKey());
            return PGPPublicKey.addCertification(keyPair.getPublicKey(), id, certification);
        }
        catch (Exception e) {
            throw new PGPException("exception doing certification: " + e, e);
        }
    }

    public boolean isSigningKey() {
        int algorithm = this.pub.getAlgorithm();
        return algorithm == 1 || algorithm == 3 || algorithm == 17 || algorithm == 19 || algorithm == 20;
    }

    public boolean isMasterKey() {
        return this.pub.isMasterKey();
    }

    public boolean isPrivateKeyEmpty() {
        byte[] secKeyData = this.secret.getSecretKeyData();
        return secKeyData == null || secKeyData.length < 1;
    }

    public int getKeyEncryptionAlgorithm() {
        return this.secret.getEncAlgorithm();
    }

    public long getKeyID() {
        return this.pub.getKeyID();
    }

    public int getS2KUsage() {
        return this.secret.getS2KUsage();
    }

    public S2K getS2K() {
        return this.secret.getS2K();
    }

    public PGPPublicKey getPublicKey() {
        return this.pub;
    }

    public Iterator getUserIDs() {
        return this.pub.getUserIDs();
    }

    public Iterator getUserAttributes() {
        return this.pub.getUserAttributes();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private byte[] extractKeyData(PBESecretKeyDecryptor decryptorFactory) throws PGPException {
        byte[] encData = this.secret.getSecretKeyData();
        byte[] data = null;
        if (this.secret.getEncAlgorithm() == 0) return encData;
        try {
            if (this.secret.getPublicKeyPacket().getVersion() == 4) {
                byte[] key = decryptorFactory.makeKeyFromPassPhrase(this.secret.getEncAlgorithm(), this.secret.getS2K());
                data = decryptorFactory.recoverKeyData(this.secret.getEncAlgorithm(), key, this.secret.getIV(), encData, 0, encData.length);
                boolean useSHA1 = this.secret.getS2KUsage() == 254;
                byte[] check = PGPSecretKey.checksum(useSHA1 ? decryptorFactory.getChecksumCalculator(2) : null, data, useSHA1 ? data.length - 20 : data.length - 2);
                int i = 0;
                while (i != check.length) {
                    if (check[i] != data[data.length - check.length + i]) {
                        throw new PGPException("checksum mismatch at " + i + " of " + check.length);
                    }
                    ++i;
                }
                return data;
            }
            byte[] key = decryptorFactory.makeKeyFromPassPhrase(this.secret.getEncAlgorithm(), this.secret.getS2K());
            data = new byte[encData.length];
            byte[] iv = new byte[this.secret.getIV().length];
            System.arraycopy(this.secret.getIV(), 0, iv, 0, iv.length);
            int pos = 0;
            for (int i = 0; i != 4; ++i) {
                int encLen = ((encData[pos] << 8 | encData[pos + 1] & 0xFF) + 7) / 8;
                data[pos] = encData[pos];
                data[pos + 1] = encData[pos + 1];
                byte[] tmp = decryptorFactory.recoverKeyData(this.secret.getEncAlgorithm(), key, iv, encData, pos + 2, encLen);
                System.arraycopy(tmp, 0, data, pos + 2, tmp.length);
                pos += 2 + encLen;
                if (i == 3) continue;
                System.arraycopy(encData, pos - iv.length, iv, 0, iv.length);
            }
            data[pos] = encData[pos];
            data[pos + 1] = encData[pos + 1];
            int cs = encData[pos] << 8 & 0xFF00 | encData[pos + 1] & 0xFF;
            int calcCs = 0;
            for (int j = 0; j < data.length - 2; ++j) {
                calcCs += data[j] & 0xFF;
            }
            if ((calcCs &= 0xFFFF) == cs) return data;
            throw new PGPException("checksum mismatch: passphrase wrong, expected " + Integer.toHexString(cs) + " found " + Integer.toHexString(calcCs));
        }
        catch (PGPException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PGPException("Exception decrypting key", e);
        }
    }

    public PGPPrivateKey extractPrivateKey(PBESecretKeyDecryptor decryptorFactory) throws PGPException {
        if (this.isPrivateKeyEmpty()) {
            return null;
        }
        PublicKeyPacket pubPk = this.secret.getPublicKeyPacket();
        try {
            byte[] data = this.extractKeyData(decryptorFactory);
            BCPGInputStream in = new BCPGInputStream(new ByteArrayInputStream(data));
            switch (pubPk.getAlgorithm()) {
                case 1: 
                case 2: 
                case 3: {
                    RSASecretBCPGKey rsaPriv = new RSASecretBCPGKey(in);
                    return new PGPPrivateKey(this.getKeyID(), pubPk, rsaPriv);
                }
                case 17: {
                    DSASecretBCPGKey dsaPriv = new DSASecretBCPGKey(in);
                    return new PGPPrivateKey(this.getKeyID(), pubPk, dsaPriv);
                }
                case 16: 
                case 20: {
                    ElGamalSecretBCPGKey elPriv = new ElGamalSecretBCPGKey(in);
                    return new PGPPrivateKey(this.getKeyID(), pubPk, elPriv);
                }
                case 18: 
                case 19: {
                    ECSecretBCPGKey ecPriv = new ECSecretBCPGKey(in);
                    return new PGPPrivateKey(this.getKeyID(), pubPk, ecPriv);
                }
            }
            throw new PGPException("unknown public key algorithm encountered");
        }
        catch (PGPException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PGPException("Exception constructing key", e);
        }
    }

    private static byte[] checksum(PGPDigestCalculator digCalc, byte[] bytes, int length) throws PGPException {
        if (digCalc != null) {
            OutputStream dOut = digCalc.getOutputStream();
            try {
                dOut.write(bytes, 0, length);
                dOut.close();
            }
            catch (Exception e) {
                throw new PGPException("checksum digest calculation failed: " + e.getMessage(), e);
            }
            return digCalc.getDigest();
        }
        int checksum = 0;
        for (int i = 0; i != length; ++i) {
            checksum += bytes[i] & 0xFF;
        }
        byte[] check = new byte[]{(byte)(checksum >> 8), (byte)checksum};
        return check;
    }

    public byte[] getEncoded() throws IOException {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        this.encode(bOut);
        return bOut.toByteArray();
    }

    public void encode(OutputStream outStream) throws IOException {
        BCPGOutputStream out = outStream instanceof BCPGOutputStream ? (BCPGOutputStream)outStream : new BCPGOutputStream(outStream);
        out.writePacket(this.secret);
        if (this.pub.trustPk != null) {
            out.writePacket(this.pub.trustPk);
        }
        if (this.pub.subSigs == null) {
            int i;
            for (i = 0; i != this.pub.keySigs.size(); ++i) {
                ((PGPSignature)this.pub.keySigs.get(i)).encode(out);
            }
            for (i = 0; i != this.pub.ids.size(); ++i) {
                if (this.pub.ids.get(i) instanceof UserIDPacket) {
                    UserIDPacket id = (UserIDPacket)this.pub.ids.get(i);
                    out.writePacket(id);
                } else {
                    PGPUserAttributeSubpacketVector v = (PGPUserAttributeSubpacketVector)this.pub.ids.get(i);
                    out.writePacket(new UserAttributePacket(v.toSubpacketArray()));
                }
                if (this.pub.idTrusts.get(i) != null) {
                    out.writePacket((ContainedPacket)this.pub.idTrusts.get(i));
                }
                ArrayList sigs = (ArrayList)this.pub.idSigs.get(i);
                for (int j = 0; j != sigs.size(); ++j) {
                    ((PGPSignature)sigs.get(j)).encode(out);
                }
            }
        } else {
            for (int j = 0; j != this.pub.subSigs.size(); ++j) {
                ((PGPSignature)this.pub.subSigs.get(j)).encode(out);
            }
        }
    }

    public static PGPSecretKey copyWithNewPassword(PGPSecretKey key, PBESecretKeyDecryptor oldKeyDecryptor, PBESecretKeyEncryptor newKeyEncryptor) throws PGPException {
        byte[] keyData;
        if (key.isPrivateKeyEmpty()) {
            throw new PGPException("no private key in this SecretKey - public key present only.");
        }
        byte[] rawKeyData = key.extractKeyData(oldKeyDecryptor);
        int s2kUsage = key.secret.getS2KUsage();
        byte[] iv = null;
        S2K s2k = null;
        int newEncAlgorithm = 0;
        if (newKeyEncryptor == null || newKeyEncryptor.getAlgorithm() == 0) {
            s2kUsage = 0;
            if (key.secret.getS2KUsage() == 254) {
                keyData = new byte[rawKeyData.length - 18];
                System.arraycopy(rawKeyData, 0, keyData, 0, keyData.length - 2);
                byte[] check = PGPSecretKey.checksum(null, keyData, keyData.length - 2);
                keyData[keyData.length - 2] = check[0];
                keyData[keyData.length - 1] = check[1];
            } else {
                keyData = rawKeyData;
            }
        } else {
            if (s2kUsage == 0) {
                s2kUsage = 255;
            }
            if (key.secret.getPublicKeyPacket().getVersion() < 4) {
                byte[] encKey = newKeyEncryptor.getKey();
                keyData = new byte[rawKeyData.length];
                if (newKeyEncryptor.getHashAlgorithm() != 1) {
                    throw new PGPException("MD5 Digest Calculator required for version 3 key encryptor.");
                }
                int pos = 0;
                for (int i = 0; i != 4; ++i) {
                    byte[] tmp;
                    int encLen = ((rawKeyData[pos] << 8 | rawKeyData[pos + 1] & 0xFF) + 7) / 8;
                    keyData[pos] = rawKeyData[pos];
                    keyData[pos + 1] = rawKeyData[pos + 1];
                    if (i == 0) {
                        tmp = newKeyEncryptor.encryptKeyData(encKey, rawKeyData, pos + 2, encLen);
                        iv = newKeyEncryptor.getCipherIV();
                    } else {
                        byte[] tmpIv = new byte[iv.length];
                        System.arraycopy(keyData, pos - iv.length, tmpIv, 0, tmpIv.length);
                        tmp = newKeyEncryptor.encryptKeyData(encKey, tmpIv, rawKeyData, pos + 2, encLen);
                    }
                    System.arraycopy(tmp, 0, keyData, pos + 2, tmp.length);
                    pos += 2 + encLen;
                }
                keyData[pos] = rawKeyData[pos];
                keyData[pos + 1] = rawKeyData[pos + 1];
                s2k = newKeyEncryptor.getS2K();
                newEncAlgorithm = newKeyEncryptor.getAlgorithm();
            } else {
                keyData = newKeyEncryptor.encryptKeyData(rawKeyData, 0, rawKeyData.length);
                iv = newKeyEncryptor.getCipherIV();
                s2k = newKeyEncryptor.getS2K();
                newEncAlgorithm = newKeyEncryptor.getAlgorithm();
            }
        }
        SecretKeyPacket secret = key.secret instanceof SecretSubkeyPacket ? new SecretSubkeyPacket(key.secret.getPublicKeyPacket(), newEncAlgorithm, s2kUsage, s2k, iv, keyData) : new SecretKeyPacket(key.secret.getPublicKeyPacket(), newEncAlgorithm, s2kUsage, s2k, iv, keyData);
        return new PGPSecretKey(secret, key.pub);
    }

    public static PGPSecretKey replacePublicKey(PGPSecretKey secretKey, PGPPublicKey publicKey) {
        if (publicKey.getKeyID() != secretKey.getKeyID()) {
            throw new IllegalArgumentException("keyIDs do not match");
        }
        return new PGPSecretKey(secretKey.secret, publicKey);
    }

    public static PGPSecretKey parseSecretKeyFromSExpr(InputStream inputStream, PBEProtectionRemoverFactory keyProtectionRemoverFactory, PGPPublicKey pubKey) throws IOException, PGPException {
        SXprUtils.skipOpenParenthesis(inputStream);
        String type = SXprUtils.readString(inputStream, inputStream.read());
        if (type.equals("protected-private-key")) {
            SXprUtils.skipOpenParenthesis(inputStream);
            String keyType = SXprUtils.readString(inputStream, inputStream.read());
            if (!keyType.equals("ecc")) {
                throw new PGPException("no curve details found");
            }
            SXprUtils.skipOpenParenthesis(inputStream);
            String curveID = SXprUtils.readString(inputStream, inputStream.read());
            String curveName = SXprUtils.readString(inputStream, inputStream.read());
            SXprUtils.skipCloseParenthesis(inputStream);
            SXprUtils.skipOpenParenthesis(inputStream);
            type = SXprUtils.readString(inputStream, inputStream.read());
            if (!type.equals("q")) {
                throw new PGPException("no q value found");
            }
            byte[] qVal = SXprUtils.readBytes(inputStream, inputStream.read());
            SXprUtils.skipCloseParenthesis(inputStream);
            byte[] dValue = PGPSecretKey.getDValue(inputStream, keyProtectionRemoverFactory, curveName);
            return new PGPSecretKey(new SecretKeyPacket(pubKey.getPublicKeyPacket(), 0, null, null, new ECSecretBCPGKey(new BigInteger(1, dValue)).getEncoded()), pubKey);
        }
        throw new PGPException("unknown key type found");
    }

    public static PGPSecretKey parseSecretKeyFromSExpr(InputStream inputStream, PBEProtectionRemoverFactory keyProtectionRemoverFactory, KeyFingerPrintCalculator fingerPrintCalculator) throws IOException, PGPException {
        SXprUtils.skipOpenParenthesis(inputStream);
        String type = SXprUtils.readString(inputStream, inputStream.read());
        if (type.equals("protected-private-key")) {
            String curveName;
            SXprUtils.skipOpenParenthesis(inputStream);
            String keyType = SXprUtils.readString(inputStream, inputStream.read());
            if (keyType.equals("ecc")) {
                SXprUtils.skipOpenParenthesis(inputStream);
                String curveID = SXprUtils.readString(inputStream, inputStream.read());
                curveName = SXprUtils.readString(inputStream, inputStream.read());
                if (curveName.startsWith("NIST ")) {
                    curveName = curveName.substring("NIST ".length());
                }
            } else {
                throw new PGPException("no curve details found");
            }
            SXprUtils.skipCloseParenthesis(inputStream);
            SXprUtils.skipOpenParenthesis(inputStream);
            type = SXprUtils.readString(inputStream, inputStream.read());
            if (!type.equals("q")) {
                throw new PGPException("no q value found");
            }
            byte[] qVal = SXprUtils.readBytes(inputStream, inputStream.read());
            PublicKeyPacket pubPacket = new PublicKeyPacket(19, new Date(), new ECDSAPublicBCPGKey(ECNamedCurveTable.getOID(curveName), new BigInteger(1, qVal)));
            SXprUtils.skipCloseParenthesis(inputStream);
            byte[] dValue = PGPSecretKey.getDValue(inputStream, keyProtectionRemoverFactory, curveName);
            return new PGPSecretKey(new SecretKeyPacket(pubPacket, 0, null, null, new ECSecretBCPGKey(new BigInteger(1, dValue)).getEncoded()), new PGPPublicKey(pubPacket, fingerPrintCalculator));
        }
        throw new PGPException("unknown key type found");
    }

    private static byte[] getDValue(InputStream inputStream, PBEProtectionRemoverFactory keyProtectionRemoverFactory, String curveName) throws IOException, PGPException {
        SXprUtils.skipOpenParenthesis(inputStream);
        String type = SXprUtils.readString(inputStream, inputStream.read());
        if (!type.equals("protected")) {
            throw new PGPException("protected block not found");
        }
        String protection = SXprUtils.readString(inputStream, inputStream.read());
        SXprUtils.skipOpenParenthesis(inputStream);
        S2K s2k = SXprUtils.parseS2K(inputStream);
        byte[] iv = SXprUtils.readBytes(inputStream, inputStream.read());
        SXprUtils.skipCloseParenthesis(inputStream);
        byte[] secKeyData = SXprUtils.readBytes(inputStream, inputStream.read());
        PBESecretKeyDecryptor keyDecryptor = keyProtectionRemoverFactory.createDecryptor(protection);
        byte[] key = keyDecryptor.makeKeyFromPassPhrase(7, s2k);
        byte[] data = keyDecryptor.recoverKeyData(7, key, iv, secKeyData, 0, secKeyData.length);
        ByteArrayInputStream keyIn = new ByteArrayInputStream(data);
        SXprUtils.skipOpenParenthesis(keyIn);
        SXprUtils.skipOpenParenthesis(keyIn);
        SXprUtils.skipOpenParenthesis(keyIn);
        String name = SXprUtils.readString(keyIn, ((InputStream)keyIn).read());
        return SXprUtils.readBytes(keyIn, ((InputStream)keyIn).read());
    }
}

