/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.openpgp.operator.jcajce;

import java.io.IOException;
import java.io.OutputStream;
import java.security.Signature;
import java.security.SignatureException;

class SignatureOutputStream
extends OutputStream {
    private Signature sig;

    SignatureOutputStream(Signature sig) {
        this.sig = sig;
    }

    public void write(byte[] bytes, int off, int len) throws IOException {
        try {
            this.sig.update(bytes, off, len);
        }
        catch (SignatureException e) {
            throw new IOException("signature update caused exception: " + e.getMessage());
        }
    }

    public void write(byte[] bytes) throws IOException {
        try {
            this.sig.update(bytes);
        }
        catch (SignatureException e) {
            throw new IOException("signature update caused exception: " + e.getMessage());
        }
    }

    public void write(int b) throws IOException {
        try {
            this.sig.update((byte)b);
        }
        catch (SignatureException e) {
            throw new IOException("signature update caused exception: " + e.getMessage());
        }
    }
}

