/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.confluence.mailer;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.Provider;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.mail.Address;
import javax.mail.Header;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import net.savignano.snotify.confluence.mailer.MessageAndAddress;
import net.savignano.snotify.confluence.mailer.enums.EncryptionFailureBehaviorOption;
import net.savignano.snotify.confluence.mailer.enums.EncryptionTypePriorityOption;
import net.savignano.snotify.confluence.mailer.security.PgpMailEncryptor;
import net.savignano.snotify.confluence.mailer.security.SmimeMailEncryptor;
import net.savignano.snotify.confluence.mailer.util.SecurityUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Mailer {
    public static final String UTF8 = "UTF-8";
    public static final Charset UTF8_CHARSET = StandardCharsets.UTF_8;
    public static final String XENCRPYTED_MAIL_PROPERTY = "X-Encrypted";
    private static final String INFO_MESSAGE = "Message could not be encrypted. Please contact your Jira administrator.";
    private static final Logger log = LoggerFactory.getLogger(Mailer.class);
    private Provider provider;
    private String hostName;
    private EncryptionTypePriorityOption typePriority;
    private EncryptionFailureBehaviorOption failureBehavior;
    private Boolean disabled;
    private Boolean frozen;

    public MessageAndAddress[] getMessages(Session session, Message message, Address[] addresses) {
        if (this.isDisabled()) {
            log.info("S/Notify is disabled. Emails will not be encrypted.");
            MessageAndAddress[] result = new MessageAndAddress[addresses.length];
            for (int i = 0; i < result.length; ++i) {
                result[i] = new MessageAndAddress(message, addresses[i]);
            }
            return result;
        }
        boolean licenseErrorReported = false;
        ArrayList<MessageAndAddress> result = new ArrayList<MessageAndAddress>();
        for (Address address : addresses) {
            MessageAndAddress messageAndAddress = new MessageAndAddress();
            messageAndAddress.address = address;
            messageAndAddress.message = message;
            boolean successfulEncryption = false;
            if (this.isFrozen()) {
                if (!licenseErrorReported) {
                    log.error("Could not encrypt email due to licensing error in S/Notify. Handling unencrypted email as: " + (Object)((Object)this.getFailureBehavior()));
                    licenseErrorReported = true;
                }
            } else if (message instanceof MimeMessage) {
                try {
                    log.debug("Starting email encryption to address: {}", (Object)address);
                    MimeMessage encryptedMessage = this.getEncryptedMessage(session, (MimeMessage)message, address);
                    if (encryptedMessage != null) {
                        messageAndAddress.message = encryptedMessage;
                        successfulEncryption = true;
                        log.debug("Finished email encryption succesfully.");
                    } else if (this.getFailureBehavior() != EncryptionFailureBehaviorOption.ALLOW) {
                        log.warn("Neither public certificate nor public PGP key found to encrypt email for: {}", (Object)address);
                    }
                }
                catch (Exception e) {
                    log.error("Error encrypting email for address " + address + ": " + e.getMessage(), (Throwable)e);
                }
            } else {
                log.error("Can't encrypt email, because it is not a MIME Email but: " + message.getClass().getCanonicalName());
            }
            if (successfulEncryption || this.getFailureBehavior() == EncryptionFailureBehaviorOption.ALLOW) {
                result.add(messageAndAddress);
                continue;
            }
            if (this.getFailureBehavior() != EncryptionFailureBehaviorOption.REPORT) continue;
            try {
                messageAndAddress.message = this.createInfoMessage(session, message);
                result.add(messageAndAddress);
            }
            catch (MessagingException e) {
                log.error("Error creating info email for email address " + address + ": " + e.getMessage(), (Throwable)e);
            }
        }
        return result.toArray(new MessageAndAddress[result.size()]);
    }

    protected Message createInfoMessage(Session session, Message origMsg) throws MessagingException {
        log.debug("Creating info message.");
        MimeMessage message = new MimeMessage(session);
        Enumeration headers = origMsg.getAllHeaders();
        log.debug("Copying headers from original message.");
        while (headers.hasMoreElements()) {
            Header header = (Header)headers.nextElement();
            message.addHeader(header.getName(), header.getValue());
            log.debug(header.toString());
        }
        log.debug("Copying headers from original message finished.");
        message.setText(INFO_MESSAGE, UTF8);
        return message;
    }

    protected MimeMessage getEncryptedMessage(Session session, MimeMessage orgMsg, Address address) throws Exception {
        MimeMessage message = null;
        switch (this.getTypePriority()) {
            case PGP_ONLY: {
                message = this.getEncryptedPgpMessage(session, orgMsg, address);
                break;
            }
            case PGP_PREFERED: {
                message = this.getEncryptedPgpMessage(session, orgMsg, address);
                if (message != null) break;
                message = this.getEncryptedSmimeMessage(session, orgMsg, address);
                break;
            }
            case SMIME_ONLY: {
                message = this.getEncryptedSmimeMessage(session, orgMsg, address);
                break;
            }
            case SMIME_PREFERED: {
                message = this.getEncryptedSmimeMessage(session, orgMsg, address);
                if (message != null) break;
                message = this.getEncryptedPgpMessage(session, orgMsg, address);
                break;
            }
            default: {
                throw new IllegalStateException("The given type priority (" + (Object)((Object)this.getTypePriority()) + ") is not yet implemented.");
            }
        }
        return message;
    }

    private MimeMessage getEncryptedSmimeMessage(Session session, MimeMessage orgMsg, Address address) throws MessagingException, IOException {
        SmimeMailEncryptor encryption = this.getSmimeEncryptor(session, orgMsg, address);
        if (encryption.getPublicKey() != null) {
            return encryption.getEncryptedMessage();
        }
        return null;
    }

    protected SmimeMailEncryptor getSmimeEncryptor(Session session, MimeMessage orgMsg, Address address) {
        SmimeMailEncryptor encryptor = new SmimeMailEncryptor(session, orgMsg, address);
        encryptor.setHostName(this.getHostName());
        return encryptor;
    }

    private MimeMessage getEncryptedPgpMessage(Session session, MimeMessage orgMsg, Address address) throws IOException, MessagingException {
        PgpMailEncryptor encryption = this.getPgpEncryptor(session, orgMsg, address);
        if (encryption.getPublicKey() != null) {
            return encryption.getEncryptedMessage();
        }
        return null;
    }

    protected PgpMailEncryptor getPgpEncryptor(Session session, MimeMessage orgMsg, Address address) {
        PgpMailEncryptor encryptor = new PgpMailEncryptor(session, orgMsg, address);
        encryptor.setHostName(this.getHostName());
        return encryptor;
    }

    public boolean isDisabled() {
        if (this.disabled == null) {
            this.disabled = this.loadDisabled();
        }
        return this.disabled;
    }

    protected boolean loadDisabled() {
        return false;
    }

    public boolean isFrozen() {
        if (this.frozen == null) {
            this.frozen = this.loadFrozen();
        }
        return this.frozen;
    }

    protected boolean loadFrozen() {
        return false;
    }

    public EncryptionTypePriorityOption getTypePriority() {
        if (this.typePriority == null) {
            this.typePriority = this.loadTypePriority();
        }
        return this.typePriority;
    }

    protected EncryptionTypePriorityOption loadTypePriority() {
        return EncryptionTypePriorityOption.SMIME_PREFERED;
    }

    public EncryptionFailureBehaviorOption getFailureBehavior() {
        if (this.failureBehavior == null) {
            this.failureBehavior = this.loadFailureBehavior();
        }
        return this.failureBehavior;
    }

    protected EncryptionFailureBehaviorOption loadFailureBehavior() {
        return EncryptionFailureBehaviorOption.ALLOW;
    }

    public Provider getProvider() {
        if (this.provider == null) {
            this.provider = this.loadProvider();
        }
        return this.provider;
    }

    protected Provider loadProvider() {
        return SecurityUtil.getProvider();
    }

    public String getHostName() {
        if (this.hostName == null) {
            this.hostName = this.loadHostName();
        }
        return this.hostName;
    }

    protected String loadHostName() {
        try {
            String result = InetAddress.getLocalHost().getHostName();
            if (result != null && !result.isEmpty()) {
                return result;
            }
        }
        catch (UnknownHostException e) {
            log.debug("Could not retrieve host name.", (Throwable)e);
        }
        try {
            String host = System.getenv("COMPUTERNAME");
            if (host != null) {
                return host;
            }
            host = System.getenv("HOSTNAME");
            if (host != null) {
                return host;
            }
        }
        catch (SecurityException e) {
            log.debug("Could not retrieve host name from environment properties.", (Throwable)e);
        }
        return "<Unknown>";
    }
}

