/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.confluence.mailer;

import java.util.Arrays;
import java.util.Enumeration;
import javax.mail.Address;
import javax.mail.Header;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.URLName;
import net.savignano.snotify.confluence.mailer.ConfluenceMailer;
import net.savignano.snotify.confluence.mailer.MessageAndAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SMTPTransport
extends com.sun.mail.smtp.SMTPTransport {
    private static final Logger log = LoggerFactory.getLogger(SMTPTransport.class);
    private final ConfluenceMailer mailer = new ConfluenceMailer();

    public SMTPTransport(Session session, URLName urlname) {
        super(session, urlname);
    }

    public synchronized void sendMessage(Message message, Address[] addresses) throws MessagingException {
        MessageAndAddress[] result;
        log.info("Using S/Notify SMTP transport implementation to send emails.");
        log.trace("Session properties used: {}", (Object)this.session.getProperties());
        try {
            result = this.mailer.getMessages(this.session, message, addresses);
        }
        catch (Exception e) {
            throw new MessagingException("Error generating emails: " + e.getMessage(), e);
        }
        MessagingException messagingException = null;
        for (MessageAndAddress messageAndAddress : result) {
            if (messageAndAddress == null) continue;
            try {
                this.printMessage(message, addresses);
                super.sendMessage(messageAndAddress.message, new Address[]{messageAndAddress.address});
            }
            catch (MessagingException ex) {
                if (messagingException != null) continue;
                messagingException = ex;
            }
        }
        if (messagingException != null) {
            throw new MessagingException("Error sending mail: " + messagingException.getMessage(), (Exception)((Object)messagingException));
        }
    }

    private void printMessage(Message message, Address[] addresses) throws MessagingException {
        if (!log.isDebugEnabled()) {
            return;
        }
        StringBuilder output = new StringBuilder();
        output.append("converted message: " + message + "\n");
        output.append("----++++ Sending message " + message + " to " + addresses.length + " addresses: ");
        output.append(Arrays.toString(addresses));
        output.append("\n");
        output.append("--- from: " + message.getFrom()[0] + "\n");
        output.append("--- contentType: " + message.getContentType() + "\n");
        output.append("--- disposition: " + message.getDisposition() + "\n");
        output.append("--- file name: " + message.getFileName() + "\n");
        output.append("--- subject: " + message.getSubject() + "\n");
        Enumeration headers = message.getAllHeaders();
        while (headers.hasMoreElements()) {
            Header header = (Header)headers.nextElement();
            String name = header.getName();
            String value = header.getValue();
            output.append("--- header " + name + ": " + value + "\n");
        }
        log.debug(output.toString());
    }
}

